/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.aarch64;

import java.util.ArrayList;
import java.util.BitSet;
import jdk.graal.compiler.core.common.alloc.RegisterAllocationConfig;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;
import jdk.vm.ci.code.RegisterConfig;

public class AArch64HotSpotRegisterAllocationConfig
extends RegisterAllocationConfig {
    static final Register[] registerAllocationOrder = new Register[]{AArch64.r0, AArch64.r1, AArch64.r2, AArch64.r3, AArch64.r4, AArch64.r5, AArch64.r6, AArch64.r7, AArch64.r8, AArch64.r9, AArch64.r10, AArch64.r11, AArch64.r12, AArch64.r13, AArch64.r14, AArch64.r15, AArch64.r16, AArch64.r17, AArch64.r18, AArch64.r19, AArch64.r20, AArch64.r21, AArch64.r22, AArch64.r23, AArch64.r24, AArch64.r25, AArch64.r26, AArch64.r28, AArch64.r29, AArch64.r30, AArch64.v0, AArch64.v1, AArch64.v2, AArch64.v3, AArch64.v4, AArch64.v5, AArch64.v6, AArch64.v7, AArch64.v8, AArch64.v9, AArch64.v10, AArch64.v11, AArch64.v12, AArch64.v13, AArch64.v14, AArch64.v15, AArch64.v16, AArch64.v17, AArch64.v18, AArch64.v19, AArch64.v20, AArch64.v21, AArch64.v22, AArch64.v23, AArch64.v24, AArch64.v25, AArch64.v26, AArch64.v27, AArch64.v28, AArch64.v29, AArch64.v30, AArch64.v31};
    private final boolean preserveFramePointer;

    public AArch64HotSpotRegisterAllocationConfig(RegisterConfig registerConfig, String[] allocationRestrictedTo, boolean preserveFramePointer) {
        super(registerConfig, allocationRestrictedTo);
        this.preserveFramePointer = preserveFramePointer;
    }

    @Override
    protected RegisterArray initAllocatable(RegisterArray registers) {
        BitSet regMap = new BitSet(this.registerConfig.getAllocatableRegisters().size());
        for (Register reg : registers) {
            regMap.set(reg.number);
        }
        if (this.preserveFramePointer) {
            regMap.clear(AArch64.r29.number);
        }
        ArrayList<Register> allocatableRegisters = new ArrayList<Register>(registers.size());
        for (Register reg : registerAllocationOrder) {
            if (!regMap.get(reg.number)) continue;
            allocatableRegisters.add(reg);
        }
        return super.initAllocatable(new RegisterArray(allocatableRegisters));
    }
}

