/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.aarch64;

import java.util.function.Function;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.core.common.calc.Condition;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.LabelRef;
import jdk.graal.compiler.lir.SwitchStrategy;
import jdk.graal.compiler.lir.aarch64.AArch64ControlFlow;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;

final class AArch64HotSpotStrategySwitchOp
extends AArch64ControlFlow.StrategySwitchOp {
    public static final LIRInstructionClass<AArch64HotSpotStrategySwitchOp> TYPE = LIRInstructionClass.create(AArch64HotSpotStrategySwitchOp.class);

    AArch64HotSpotStrategySwitchOp(SwitchStrategy strategy, LabelRef[] keyTargets, LabelRef defaultTarget, AllocatableValue key, Function<Condition, AArch64Assembler.ConditionFlag> converter) {
        super(TYPE, strategy, keyTargets, defaultTarget, key, converter);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        this.strategy.run(new HotSpotSwitchClosure(this, ValueUtil.asRegister((Value)this.key), crb, masm));
    }

    public class HotSpotSwitchClosure
    extends AArch64ControlFlow.StrategySwitchOp.SwitchClosure {
        protected HotSpotSwitchClosure(AArch64HotSpotStrategySwitchOp this$0, Register keyRegister, CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            super(this$0, keyRegister, crb, masm);
        }

        @Override
        protected void emitComparison(Constant c) {
            if (c instanceof HotSpotMetaspaceConstant) {
                HotSpotMetaspaceConstant meta = (HotSpotMetaspaceConstant)c;
                this.crb.recordInlineDataInCode((Constant)meta);
                if (meta.isCompressed()) {
                    throw GraalError.unimplemented("compressed metaspace constant");
                }
                try (AArch64MacroAssembler.ScratchRegister scratchRegister = this.masm.getScratchRegister();){
                    Register scratch = scratchRegister.getRegister();
                    this.masm.movNativeAddress(scratch, 0xDEADDEADDEADL);
                    this.masm.cmp(64, this.keyRegister, scratch);
                }
            } else {
                super.emitComparison(c);
            }
        }
    }
}

