/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.core.amd64.AMD64NodeMatchRules;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.alloc.RegisterAllocationConfig;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.core.gen.LIRGenerationProvider;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotDataBuilder;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntimeProvider;
import jdk.graal.compiler.hotspot.HotSpotHostBackend;
import jdk.graal.compiler.hotspot.HotSpotLIRGenerationResult;
import jdk.graal.compiler.hotspot.HotSpotMarkId;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotFrameMap;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotFrameMapBuilder;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotLIRGenerator;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotMacroAssembler;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotMove;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotNodeLIRBuilder;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotRegisterAllocationConfig;
import jdk.graal.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.stubs.Stub;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.amd64.AMD64Call;
import jdk.graal.compiler.lir.amd64.AMD64FrameMap;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.asm.CompilationResultBuilderFactory;
import jdk.graal.compiler.lir.asm.EntryPointDecorator;
import jdk.graal.compiler.lir.asm.FrameContext;
import jdk.graal.compiler.lir.framemap.FrameMap;
import jdk.graal.compiler.lir.framemap.FrameMapBuilder;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;

public class AMD64HotSpotBackend
extends HotSpotHostBackend
implements LIRGenerationProvider {
    public static final int PATCHED_VERIFIED_ENTRY_POINT_INSTRUCTION_SIZE = 5;

    public AMD64HotSpotBackend(GraalHotSpotVMConfig config, HotSpotGraalRuntimeProvider runtime, HotSpotProviders providers) {
        super(config, runtime, providers);
    }

    @Override
    protected FrameMapBuilder newFrameMapBuilder(RegisterConfig registerConfig) {
        RegisterConfig registerConfigNonNull = registerConfig == null ? this.getCodeCache().getRegisterConfig() : registerConfig;
        AMD64HotSpotFrameMap frameMap = new AMD64HotSpotFrameMap(this.getCodeCache(), registerConfigNonNull, (FrameMap.ReferenceMapBuilderFactory)this, this.config);
        return new AMD64HotSpotFrameMapBuilder(frameMap, this.getCodeCache(), registerConfigNonNull);
    }

    @Override
    public LIRGeneratorTool newLIRGenerator(LIRGenerationResult lirGenRes) {
        return new AMD64HotSpotLIRGenerator(this.getProviders(), this.config, lirGenRes);
    }

    @Override
    public NodeLIRBuilderTool newNodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool lirGen) {
        return new AMD64HotSpotNodeLIRBuilder(graph, lirGen, new AMD64NodeMatchRules(lirGen));
    }

    @Override
    protected void bangStackWithOffset(CompilationResultBuilder crb, int bangOffset) {
        AMD64MacroAssembler asm = (AMD64MacroAssembler)crb.asm;
        int pos = asm.position();
        asm.movl(new AMD64Address(AMD64.rsp, -bangOffset), AMD64.rax);
        assert (asm.position() - pos >= 5) : asm.position() + "-" + pos;
    }

    @Override
    public CompilationResultBuilder newCompilationResultBuilder(LIRGenerationResult lirGenRen, FrameMap frameMap, CompilationResult compilationResult, CompilationResultBuilderFactory factory) {
        HotSpotLIRGenerationResult gen = (HotSpotLIRGenerationResult)lirGenRen;
        LIR lir = gen.getLIR();
        assert (gen.getDeoptimizationRescueSlot() == null || frameMap.frameNeedsAllocating()) : "method that can deoptimize must have a frame";
        OptionValues options = lir.getOptions();
        DebugContext debug = lir.getDebug();
        Stub stub = gen.getStub();
        AMD64HotSpotMacroAssembler masm = new AMD64HotSpotMacroAssembler(this.config, this.getTarget(), options, this.config.CPU_HAS_INTEL_JCC_ERRATUM);
        HotSpotFrameContext frameContext = new HotSpotFrameContext(stub != null);
        HotSpotDataBuilder dataBuilder = new HotSpotDataBuilder(this.getCodeCache().getTarget());
        CompilationResultBuilder crb = factory.createBuilder(this.getProviders(), frameMap, masm, dataBuilder, frameContext, options, debug, compilationResult, Register.None, lir);
        crb.setTotalFrameSize(frameMap.totalFrameSize());
        crb.setMaxInterpreterFrameSize(gen.getMaxInterpreterFrameSize());
        crb.setMinDataSectionItemAlignment(this.getMinDataSectionItemAlignment());
        StackSlot deoptimizationRescueSlot = gen.getDeoptimizationRescueSlot();
        if (deoptimizationRescueSlot != null && stub == null) {
            crb.compilationResult.setCustomStackAreaOffset(deoptimizationRescueSlot);
        }
        if (stub != null) {
            this.updateStub(stub, gen, frameMap);
        }
        return crb;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, ResolvedJavaMethod installedCodeOwner, EntryPointDecorator entryPointDecorator) {
        AMD64MacroAssembler asm = (AMD64MacroAssembler)crb.asm;
        FrameMap frameMap = crb.frameMap;
        RegisterConfig regConfig = frameMap.getRegisterConfig();
        this.emitCodePrefix(installedCodeOwner, crb, asm, regConfig);
        if (entryPointDecorator != null) {
            entryPointDecorator.emitEntryPoint(crb);
        }
        crb.emitLIR();
        this.emitCodeSuffix(crb, asm);
    }

    public void emitCodePrefix(ResolvedJavaMethod installedCodeOwner, CompilationResultBuilder crb, AMD64MacroAssembler asm, RegisterConfig regConfig) {
        HotSpotProviders providers = this.getProviders();
        if (installedCodeOwner != null && !installedCodeOwner.isStatic()) {
            int before;
            crb.recordMark(HotSpotMarkId.UNVERIFIED_ENTRY);
            CallingConvention cc = regConfig.getCallingConvention((CallingConvention.Type)HotSpotCallingConventionType.JavaCallee, null, new JavaType[]{providers.getMetaAccess().lookupJavaType(Object.class)}, (ValueKindFactory)this);
            Register inlineCacheKlass = AMD64.rax;
            Register receiver = ValueUtil.asRegister((Value)cc.getArgument(0));
            AMD64Address src = new AMD64Address(receiver, this.config.hubOffset);
            if (this.config.useCompressedClassPointers) {
                Register register = AMD64.r10;
                Register heapBase = providers.getRegisters().getHeapBaseRegister();
                AMD64HotSpotMove.decodeKlassPointer(asm, register, heapBase, src, this.config);
                if (this.config.narrowKlassBase != 0L) {
                    if (this.config.narrowOopBase == 0L) {
                        asm.xorq(heapBase, heapBase);
                    } else {
                        asm.movq(heapBase, this.config.narrowOopBase);
                    }
                }
                before = asm.cmpqAndJcc(inlineCacheKlass, register, AMD64Assembler.ConditionFlag.NotEqual, null, false);
            } else {
                before = asm.cmpqAndJcc(inlineCacheKlass, src, AMD64Assembler.ConditionFlag.NotEqual, null, false);
            }
            crb.recordDirectCall(before, asm.position(), this.getForeignCalls().lookupForeignCall(IC_MISS_HANDLER), null);
        }
        asm.align(this.config.codeEntryAlignment);
        crb.recordMark(crb.compilationResult.getEntryBCI() != -1 ? HotSpotMarkId.OSR_ENTRY : HotSpotMarkId.VERIFIED_ENTRY);
    }

    public void emitCodeSuffix(CompilationResultBuilder crb, AMD64MacroAssembler asm) {
        HotSpotProviders providers = this.getProviders();
        HotSpotFrameContext frameContext = (HotSpotFrameContext)crb.frameContext;
        if (!frameContext.isStub) {
            HotSpotHostForeignCallsProvider foreignCalls = providers.getForeignCalls();
            if (crb.getPendingImplicitExceptionList() != null) {
                for (CompilationResultBuilder.PendingImplicitException pendingImplicitException : crb.getPendingImplicitExceptionList()) {
                    int pos = asm.position();
                    Register thread = this.getProviders().getRegisters().getThreadRegister();
                    asm.movl(new AMD64Address(thread, this.config.pendingDeoptimizationOffset), pendingImplicitException.state.deoptReasonAndAction.asInt());
                    JavaConstant deoptSpeculation = pendingImplicitException.state.deoptSpeculation;
                    if (deoptSpeculation.getJavaKind() == JavaKind.Long) {
                        long speculationAsLong = pendingImplicitException.state.deoptSpeculation.asLong();
                        if (NumUtil.isInt(speculationAsLong)) {
                            AMD64Assembler.AMD64MIOp.MOV.emit((AMD64Assembler)asm, AMD64BaseAssembler.OperandSize.QWORD, new AMD64Address(thread, this.config.pendingFailedSpeculationOffset), (int)speculationAsLong);
                        } else {
                            asm.movl(new AMD64Address(thread, this.config.pendingFailedSpeculationOffset), (int)speculationAsLong);
                            asm.movl(new AMD64Address(thread, this.config.pendingFailedSpeculationOffset + 4), (int)(speculationAsLong >> 32));
                        }
                    } else {
                        assert (deoptSpeculation.getJavaKind() == JavaKind.Int) : deoptSpeculation;
                        int speculationAsInt = pendingImplicitException.state.deoptSpeculation.asInt();
                        asm.movl(new AMD64Address(thread, this.config.pendingFailedSpeculationOffset), speculationAsInt);
                    }
                    AMD64Call.directCall(crb, asm, foreignCalls.lookupForeignCall(DEOPT_BLOB_UNCOMMON_TRAP), null, false, pendingImplicitException.state);
                    crb.recordImplicitException(pendingImplicitException.codeOffset, pos, pendingImplicitException.state);
                }
            }
            crb.recordMark(AMD64Call.directCall(crb, asm, foreignCalls.lookupForeignCall(EXCEPTION_HANDLER), null, false, null), HotSpotMarkId.EXCEPTION_HANDLER_ENTRY);
            crb.recordMark(AMD64Call.directCall(crb, asm, foreignCalls.lookupForeignCall(DEOPT_BLOB_UNPACK), null, false, null), HotSpotMarkId.DEOPT_HANDLER_ENTRY);
            if (this.config.supportsMethodHandleDeoptimizationEntry() && crb.needsMHDeoptHandler()) {
                crb.recordMark(AMD64Call.directCall(crb, asm, foreignCalls.lookupForeignCall(DEOPT_BLOB_UNPACK), null, false, null), HotSpotMarkId.DEOPT_MH_HANDLER_ENTRY);
            }
        }
    }

    @Override
    public RegisterAllocationConfig newRegisterAllocationConfig(RegisterConfig registerConfig, String[] allocationRestrictedTo) {
        RegisterConfig registerConfigNonNull = registerConfig == null ? this.getCodeCache().getRegisterConfig() : registerConfig;
        return new AMD64HotSpotRegisterAllocationConfig(registerConfigNonNull, allocationRestrictedTo, this.config.preserveFramePointer);
    }

    public class HotSpotFrameContext
    implements FrameContext {
        final boolean isStub;

        HotSpotFrameContext(boolean isStub) {
            this.isStub = isStub;
        }

        @Override
        public void enter(CompilationResultBuilder crb) {
            AMD64FrameMap frameMap = (AMD64FrameMap)crb.frameMap;
            int frameSize = frameMap.frameSize();
            AMD64HotSpotMacroAssembler asm = (AMD64HotSpotMacroAssembler)crb.asm;
            int verifiedEntryPointOffset = asm.position();
            if (!this.isStub) {
                AMD64HotSpotBackend.this.emitStackOverflowCheck(crb);
            }
            if (frameMap.preserveFramePointer()) {
                asm.push(AMD64.rbp);
                asm.movq(AMD64.rbp, AMD64.rsp);
            }
            if (!this.isStub && asm.position() == verifiedEntryPointOffset) {
                asm.subqWide(AMD64.rsp, frameSize);
                assert (asm.position() - verifiedEntryPointOffset >= 5) : asm.position() + "-" + verifiedEntryPointOffset;
            } else {
                asm.decrementq(AMD64.rsp, frameSize);
            }
            assert (frameMap.getRegisterConfig().getCalleeSaveRegisters() == null);
            if (!this.isStub && ((AMD64HotSpotBackend)AMD64HotSpotBackend.this).config.nmethodEntryBarrier != 0L) {
                this.emitNmethodEntryBarrier(crb, asm);
            } else {
                crb.recordMark(HotSpotMarkId.FRAME_COMPLETE);
            }
            if (GraalOptions.ZapStackOnMethodEntry.getValue(crb.getOptions()).booleanValue()) {
                int intSize = 4;
                for (int i = 0; i < frameSize / 4; ++i) {
                    asm.movl(new AMD64Address(AMD64.rsp, i * 4), -1044266559);
                }
            }
        }

        private void emitNmethodEntryBarrier(CompilationResultBuilder crb, AMD64HotSpotMacroAssembler asm) {
            GraalError.guarantee(HotSpotMarkId.ENTRY_BARRIER_PATCH.isAvailable(), "must be available");
            ForeignCallLinkage callTarget = AMD64HotSpotBackend.this.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.NMETHOD_ENTRY_BARRIER);
            Label continuation = new Label();
            Label entryPoint = new Label();
            asm.align(4);
            crb.recordMark(HotSpotMarkId.FRAME_COMPLETE);
            crb.recordMark(HotSpotMarkId.ENTRY_BARRIER_PATCH);
            asm.nmethodEntryCompare(((AMD64HotSpotBackend)AMD64HotSpotBackend.this).config.threadDisarmedOffset);
            asm.jcc(AMD64Assembler.ConditionFlag.NotEqual, entryPoint);
            crb.getLIR().addSlowPath(null, () -> {
                asm.bind(entryPoint);
                AMD64HotSpotFrameMap frameMap = (AMD64HotSpotFrameMap)crb.frameMap;
                if (!frameMap.preserveFramePointer()) {
                    asm.movq(new AMD64Address(AMD64.rsp, frameMap.offsetForStackSlot(frameMap.getRBPSpillSlot())), AMD64.rbp);
                }
                asm.call((before, after) -> crb.recordDirectCall(before, after, callTarget, null), callTarget);
                asm.jmp(continuation);
            });
            asm.bind(continuation);
        }

        @Override
        public void leave(CompilationResultBuilder crb) {
            AMD64HotSpotFrameMap frameMap = (AMD64HotSpotFrameMap)crb.frameMap;
            AMD64MacroAssembler asm = (AMD64MacroAssembler)crb.asm;
            assert (frameMap.getRegisterConfig().getCalleeSaveRegisters() == null);
            if (frameMap.preserveFramePointer()) {
                asm.movq(AMD64.rsp, AMD64.rbp);
                asm.pop(AMD64.rbp);
            } else {
                asm.incrementq(AMD64.rsp, frameMap.frameSize());
            }
        }

        @Override
        public void returned(CompilationResultBuilder crb) {
        }

        public void rawEnter(CompilationResultBuilder crb) {
            AMD64MacroAssembler asm = (AMD64MacroAssembler)crb.asm;
            AMD64FrameMap frameMap = (AMD64FrameMap)crb.frameMap;
            if (frameMap.preserveFramePointer()) {
                asm.push(AMD64.rbp);
                asm.movq(AMD64.rbp, AMD64.rsp);
            }
            asm.decrementq(AMD64.rsp, frameMap.frameSize());
        }

        public void rawLeave(CompilationResultBuilder crb) {
            this.leave(crb);
        }
    }
}

