/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64;

import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.lir.amd64.AMD64FrameMap;
import jdk.graal.compiler.lir.framemap.FrameMap;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;

public class AMD64HotSpotFrameMap
extends AMD64FrameMap {
    private StackSlot rbpSpillSlot;
    private StackSlot deoptimizationRescueSlot;

    public AMD64HotSpotFrameMap(CodeCacheProvider codeCache, RegisterConfig registerConfig, FrameMap.ReferenceMapBuilderFactory referenceMapFactory, GraalHotSpotVMConfig config) {
        super(codeCache, registerConfig, referenceMapFactory, config.preserveFramePointer);
        if (!this.preserveFramePointer()) {
            assert (this.spillSize == this.initialSpillSize) : "RBP spill slot must be the first allocated stack slots";
            this.rbpSpillSlot = this.allocateSpillSlot(LIRKind.value((PlatformKind)AMD64Kind.QWORD));
            assert (ValueUtil.asStackSlot((Value)this.rbpSpillSlot).getRawOffset() == -16) : ValueUtil.asStackSlot((Value)this.rbpSpillSlot).getRawOffset();
        }
        this.deoptimizationRescueSlot = this.allocateSpillSlot(LIRKind.value((PlatformKind)AMD64Kind.QWORD));
    }

    @Override
    public int offsetForStackSlot(StackSlot slot) {
        int offset = super.offsetForStackSlot(slot);
        assert (!slot.equals((Object)this.rbpSpillSlot) || offset - this.totalFrameSize() == -16) : Assertions.errorMessage(slot, offset);
        return offset;
    }

    public StackSlot getRBPSpillSlot() {
        assert (this.rbpSpillSlot != null);
        return this.rbpSpillSlot;
    }

    public StackSlot getDeoptimizationRescueSlot() {
        assert (this.deoptimizationRescueSlot != null);
        return this.deoptimizationRescueSlot;
    }

    @Override
    protected Register[] filterSavedRegisters(Register[] savedRegisters) {
        Register[] filtered = null;
        for (int i = 0; i < savedRegisters.length; ++i) {
            Register reg = savedRegisters[i];
            if (reg == null || !reg.getRegisterCategory().equals((Object)AMD64.MASK)) continue;
            if (filtered == null) {
                filtered = (Register[])savedRegisters.clone();
            }
            filtered[i] = null;
        }
        return filtered != null ? filtered : savedRegisters;
    }
}

