/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AVXKind;
import jdk.graal.compiler.core.amd64.AMD64ArithmeticLIRGenerator;
import jdk.graal.compiler.core.amd64.AMD64LIRGenerator;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.core.common.spi.LIRKindTool;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotBackend;
import jdk.graal.compiler.hotspot.HotSpotDebugInfoBuilder;
import jdk.graal.compiler.hotspot.HotSpotForeignCallLinkage;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntime;
import jdk.graal.compiler.hotspot.HotSpotLIRGenerationResult;
import jdk.graal.compiler.hotspot.HotSpotLIRGenerator;
import jdk.graal.compiler.hotspot.HotSpotLockStack;
import jdk.graal.compiler.hotspot.amd64.AMD64DeoptimizeOp;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotCRuntimeCallEpilogueOp;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotCRuntimeCallPrologueOp;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotCounterOp;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotDeoptimizeCallerOp;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotDeoptimizeWithExceptionCallerOp;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotFrameMapBuilder;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotLIRKindTool;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotMoveFactory;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotRestoreRbpOp;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotReturnOp;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotStrategySwitchOp;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotUnwindOp;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotZBarrierSetLIRGenerator;
import jdk.graal.compiler.hotspot.debug.BenchmarkCounters;
import jdk.graal.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.stubs.Stub;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.LabelRef;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.SwitchStrategy;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.VirtualStackSlot;
import jdk.graal.compiler.lir.amd64.AMD64AddressValue;
import jdk.graal.compiler.lir.amd64.AMD64ControlFlow;
import jdk.graal.compiler.lir.amd64.AMD64Move;
import jdk.graal.compiler.lir.amd64.AMD64PrefetchOp;
import jdk.graal.compiler.lir.amd64.AMD64ReadTimestampCounterWithProcid;
import jdk.graal.compiler.lir.amd64.AMD64RestoreRegistersOp;
import jdk.graal.compiler.lir.amd64.AMD64SaveRegistersOp;
import jdk.graal.compiler.lir.amd64.AMD64VZeroUpper;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.framemap.FrameMapBuilder;
import jdk.graal.compiler.lir.gen.BarrierSetLIRGenerator;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.gen.MoveFactory;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;

public class AMD64HotSpotLIRGenerator
extends AMD64LIRGenerator
implements HotSpotLIRGenerator {
    final GraalHotSpotVMConfig config;
    private HotSpotDebugInfoBuilder debugInfoBuilder;
    private SaveRbp saveRbp;
    private RescueSlotDummyOp rescueSlotOp;
    List<AMD64HotSpotRestoreRbpOp> epilogueOps = new ArrayList<AMD64HotSpotRestoreRbpOp>(2);
    private Register pollOnReturnScratchRegister;
    private LIRFrameState currentRuntimeCallInfo;

    protected AMD64HotSpotLIRGenerator(HotSpotProviders providers, GraalHotSpotVMConfig config, LIRGenerationResult lirGenRes) {
        this(providers, config, lirGenRes, new MoveFactory.BackupSlotProvider(lirGenRes.getFrameMapBuilder()));
    }

    protected static BarrierSetLIRGenerator getBarrierSet(GraalHotSpotVMConfig config, Providers providers) {
        if (config.gc == HotSpotGraalRuntime.HotSpotGC.Z) {
            return new AMD64HotSpotZBarrierSetLIRGenerator(config, providers);
        }
        return null;
    }

    private AMD64HotSpotLIRGenerator(HotSpotProviders providers, GraalHotSpotVMConfig config, LIRGenerationResult lirGenRes, MoveFactory.BackupSlotProvider backupSlotProvider) {
        this(new AMD64HotSpotLIRKindTool(), new AMD64ArithmeticLIRGenerator(null), AMD64HotSpotLIRGenerator.getBarrierSet(config, providers), new AMD64HotSpotMoveFactory(backupSlotProvider), providers, config, lirGenRes);
    }

    protected AMD64HotSpotLIRGenerator(LIRKindTool lirKindTool, AMD64ArithmeticLIRGenerator arithmeticLIRGen, BarrierSetLIRGenerator barrierSetLIRGen, MoveFactory moveFactory, HotSpotProviders providers, GraalHotSpotVMConfig config, LIRGenerationResult lirGenRes) {
        super(lirKindTool, arithmeticLIRGen, barrierSetLIRGen, moveFactory, providers, lirGenRes);
        int basicLockSize = config.basicLockSize;
        assert (basicLockSize == 8) : basicLockSize;
        this.config = config;
    }

    @Override
    public HotSpotProviders getProviders() {
        return (HotSpotProviders)super.getProviders();
    }

    @Override
    public AVXKind.AVXSize getMaxVectorSize(EnumSet<?> runtimeCheckedCPUFeatures) {
        int maxVectorSize = this.config.maxVectorSize;
        if (this.supports(runtimeCheckedCPUFeatures, AMD64.CPUFeature.AVX512VL) && (maxVectorSize < 0 || maxVectorSize >= 64)) {
            return AVXKind.AVXSize.ZMM;
        }
        if (this.supports(runtimeCheckedCPUFeatures, AMD64.CPUFeature.AVX2) && (maxVectorSize < 0 || maxVectorSize >= 32)) {
            return AVXKind.AVXSize.YMM;
        }
        return AVXKind.AVXSize.XMM;
    }

    @Override
    protected int getAVX3Threshold() {
        return this.config.useAVX3Threshold;
    }

    protected void emitSaveRbp() {
        StandardOp.NoOp placeholder = new StandardOp.NoOp(this.getCurrentBlock(), this.getResult().getLIR().getLIRforBlock(this.getCurrentBlock()).size());
        this.append(placeholder);
        this.saveRbp = new SaveRbp(placeholder);
    }

    private AllocatableValue getOrInitRescueSlot() {
        RescueSlotDummyOp op = this.getOrInitRescueSlotOp();
        return op.getSlot();
    }

    private RescueSlotDummyOp getOrInitRescueSlotOp() {
        if (this.rescueSlotOp == null) {
            this.rescueSlotOp = new RescueSlotDummyOp(this.getResult().getFrameMapBuilder(), this.getLIRKindTool().getWordKind());
        }
        return this.rescueSlotOp;
    }

    @Override
    public <I extends LIRInstruction> I append(I op) {
        I ret = super.append(op);
        if (op instanceof AMD64HotSpotRestoreRbpOp) {
            this.epilogueOps.add((AMD64HotSpotRestoreRbpOp)((Object)op));
        }
        return ret;
    }

    @Override
    public VirtualStackSlot getLockSlot(int lockDepth) {
        return this.getLockStack().makeLockSlot(lockDepth);
    }

    private HotSpotLockStack getLockStack() {
        assert (this.debugInfoBuilder != null);
        assert (this.debugInfoBuilder.lockStack() != null);
        return this.debugInfoBuilder.lockStack();
    }

    private Register findPollOnReturnScratchRegister() {
        RegisterConfig regConfig = this.getProviders().getCodeCache().getRegisterConfig();
        for (Register r : regConfig.getAllocatableRegisters()) {
            if (r.equals((Object)regConfig.getReturnRegister(JavaKind.Long)) || r.equals((Object)AMD64.rbp)) continue;
            return r;
        }
        throw GraalError.shouldNotReachHereUnexpectedValue(regConfig);
    }

    @Override
    public void emitReturn(JavaKind kind, Value input) {
        AllocatableValue operand = Value.ILLEGAL;
        if (input != null) {
            operand = this.resultOperandFor(kind, input.getValueKind());
            this.emitMove(operand, input);
        }
        if (this.pollOnReturnScratchRegister == null) {
            this.pollOnReturnScratchRegister = this.findPollOnReturnScratchRegister();
        }
        Register thread = this.getProviders().getRegisters().getThreadRegister();
        this.append(new AMD64HotSpotReturnOp((Value)operand, this.getStub() != null, thread, this.pollOnReturnScratchRegister, this.config, this.getResult().requiresReservedStackAccessCheck()));
    }

    @Override
    public boolean needOnlyOopMaps() {
        return this.getResult().getStub() != null;
    }

    @Override
    protected void emitForeignCallOp(ForeignCallLinkage linkage, Value targetAddress, Value result, Value[] arguments, Value[] temps, LIRFrameState info) {
        this.currentRuntimeCallInfo = info;
        HotSpotForeignCallLinkage hsLinkage = (HotSpotForeignCallLinkage)linkage;
        AMD64 arch = (AMD64)this.target().arch;
        if (arch.getFeatures().contains(AMD64.CPUFeature.AVX) && hsLinkage.mayContainFP() && !hsLinkage.isCompiledStub()) {
            this.append(new AMD64VZeroUpper(arguments, this.getRegisterConfig()));
        }
        super.emitForeignCallOp(linkage, targetAddress, result, arguments, temps, info);
    }

    protected AMD64SaveRegistersOp emitSaveRegisters(Register[] savedRegisters, AllocatableValue[] savedRegisterLocations) {
        AMD64SaveRegistersOp save = new AMD64SaveRegistersOp(savedRegisters, savedRegisterLocations);
        this.append(save);
        return save;
    }

    protected VirtualStackSlot allocateSaveRegisterLocation(Register register) {
        PlatformKind kind = this.target().arch.getLargestStorableKind(register.getRegisterCategory());
        if (kind.getVectorLength() > 1) {
            kind = AMD64Kind.DOUBLE;
        }
        return this.getResult().getFrameMapBuilder().allocateSpillSlot(LIRKind.value(kind));
    }

    private AMD64SaveRegistersOp emitSaveAllRegisters(boolean forSafepoint) {
        Register[] savedRegisters = this.getSaveableRegisters(forSafepoint);
        AllocatableValue[] savedRegisterLocations = new AllocatableValue[savedRegisters.length];
        for (int i = 0; i < savedRegisters.length; ++i) {
            savedRegisterLocations[i] = this.allocateSaveRegisterLocation(savedRegisters[i]);
        }
        return this.emitSaveRegisters(savedRegisters, savedRegisterLocations);
    }

    protected Register[] getSaveableRegisters(boolean forSafepoint) {
        RegisterArray allocatableRegisters = this.getResult().getRegisterAllocationConfig().getAllocatableRegisters();
        ArrayList<Register> registers = new ArrayList<Register>(allocatableRegisters.size());
        for (Register reg : allocatableRegisters) {
            if (forSafepoint && reg.getRegisterCategory().equals((Object)AMD64.MASK)) continue;
            registers.add(reg);
        }
        return registers.toArray(new Register[registers.size()]);
    }

    protected void emitRestoreRegisters(AMD64SaveRegistersOp save) {
        this.append(new AMD64RestoreRegistersOp((AllocatableValue[])save.getSlots().clone(), save));
    }

    public Stub getStub() {
        return this.getResult().getStub();
    }

    @Override
    public HotSpotLIRGenerationResult getResult() {
        return (HotSpotLIRGenerationResult)super.getResult();
    }

    public void setDebugInfoBuilder(HotSpotDebugInfoBuilder debugInfoBuilder) {
        this.debugInfoBuilder = debugInfoBuilder;
    }

    @Override
    public Variable emitForeignCall(ForeignCallLinkage linkage, LIRFrameState state, Value ... args) {
        CallingConvention inCC;
        Variable result;
        HotSpotForeignCallLinkage hotspotLinkage = (HotSpotForeignCallLinkage)linkage;
        boolean destroysRegisters = hotspotLinkage.destroysRegisters();
        AMD64SaveRegistersOp save = null;
        Stub stub = this.getStub();
        if (destroysRegisters && stub != null && stub.shouldSaveRegistersAroundCalls()) {
            save = this.emitSaveAllRegisters(stub.getLinkage().getDescriptor().getTransition() == HotSpotForeignCallDescriptor.Transition.SAFEPOINT);
        }
        LIRFrameState debugInfo = null;
        if (hotspotLinkage.needsDebugInfo()) {
            debugInfo = state;
            assert (debugInfo != null || stub != null);
        }
        if (hotspotLinkage.needsJavaFrameAnchor()) {
            Register thread = this.getProviders().getRegisters().getThreadRegister();
            this.append(new AMD64HotSpotCRuntimeCallPrologueOp(this.config.threadLastJavaSpOffset(), thread));
            result = super.emitForeignCall(hotspotLinkage, debugInfo, args);
            this.append(new AMD64HotSpotCRuntimeCallEpilogueOp(this.config.threadLastJavaSpOffset(), this.config.threadLastJavaFpOffset(), this.config.threadLastJavaPcOffset(), thread));
        } else {
            result = super.emitForeignCall(hotspotLinkage, debugInfo, args);
        }
        if (stub != null && stub.getLinkage().getEffect() == HotSpotForeignCallLinkage.RegisterEffect.KILLS_NO_REGISTERS && result != null && !(inCC = stub.getLinkage().getIncomingCallingConvention()).getReturn().equals((Object)linkage.getOutgoingCallingConvention().getReturn())) {
            assert (ValueUtil.isStackSlot((Value)inCC.getReturn()));
            this.emitMove(inCC.getReturn(), (Value)result);
        }
        if (save != null) {
            HotSpotLIRGenerationResult generationResult = this.getResult();
            LIRFrameState key = this.currentRuntimeCallInfo;
            if (key == null) {
                key = LIRFrameState.noCalleeSaveInfo();
            }
            assert (!generationResult.getCalleeSaveInfo().containsKey((Object)key));
            generationResult.getCalleeSaveInfo().put((Object)key, (Object)save);
            this.emitRestoreRegisters(save);
        }
        return result;
    }

    @Override
    public void emitUnwind(Value exception) {
        ForeignCallLinkage linkage = this.getForeignCalls().lookupForeignCall(HotSpotBackend.UNWIND_EXCEPTION_TO_CALLER);
        CallingConvention outgoingCc = linkage.getOutgoingCallingConvention();
        int argumentCount = outgoingCc.getArgumentCount();
        assert (argumentCount == 2) : argumentCount;
        RegisterValue exceptionParameter = (RegisterValue)outgoingCc.getArgument(0);
        this.emitMove((AllocatableValue)exceptionParameter, exception);
        this.append(new AMD64HotSpotUnwindOp(exceptionParameter));
    }

    private void moveDeoptValuesToThread(Value actionAndReason, Value speculation) {
        this.moveValueToThread(actionAndReason, this.config.pendingDeoptimizationOffset);
        this.moveValueToThread(speculation, this.config.pendingFailedSpeculationOffset);
    }

    private void moveValueToThread(Value v, int offset) {
        LIRKind wordKind = LIRKind.value(this.target().arch.getWordKind());
        RegisterValue thread = this.getProviders().getRegisters().getThreadRegister().asValue((ValueKind)wordKind);
        AMD64AddressValue address = new AMD64AddressValue(wordKind, (AllocatableValue)thread, offset);
        this.arithmeticLIRGen.emitStore(v.getValueKind(), address, v, null, MemoryOrderMode.PLAIN);
    }

    @Override
    public void emitDeoptimize(Value actionAndReason, Value speculation, LIRFrameState state) {
        this.moveDeoptValuesToThread(actionAndReason, speculation);
        this.append(new AMD64DeoptimizeOp(state));
    }

    @Override
    public void emitDeoptimizeCaller(DeoptimizationAction action, DeoptimizationReason reason) {
        Value actionAndReason = this.emitJavaConstant(this.getMetaAccess().encodeDeoptActionAndReason(action, reason, 0));
        Value speculation = this.emitJavaConstant(this.getMetaAccess().encodeSpeculation(SpeculationLog.NO_SPECULATION));
        this.moveDeoptValuesToThread(actionAndReason, speculation);
        this.append(new AMD64HotSpotDeoptimizeCallerOp());
    }

    @Override
    public void emitDeoptimizeWithExceptionInCaller(Value exception) {
        this.append(new AMD64HotSpotDeoptimizeWithExceptionCallerOp(this.config, exception));
    }

    @Override
    public void beforeRegisterAllocation() {
        super.beforeRegisterAllocation();
        boolean hasDebugInfo = this.getResult().getLIR().hasDebugInfo();
        if (this.config.preserveFramePointer) {
            this.saveRbp.remove();
        } else {
            AllocatableValue savedRbp = this.saveRbp.finalize(hasDebugInfo);
            for (AMD64HotSpotRestoreRbpOp op : this.epilogueOps) {
                op.setSavedRbp(savedRbp);
            }
        }
        if (hasDebugInfo) {
            this.getResult().setDeoptimizationRescueSlot(((AMD64HotSpotFrameMapBuilder)this.getResult().getFrameMapBuilder()).getDeoptimizationRescueSlot());
        }
        this.getResult().setMaxInterpreterFrameSize(this.debugInfoBuilder.maxInterpreterFrameSize());
        if (BenchmarkCounters.enabled) {
            RescueSlotDummyOp op = this.getOrInitRescueSlotOp();
            LIR lir = this.getResult().getLIR();
            ArrayList<LIRInstruction> instructions = lir.getLIRforBlock((BasicBlock<?>)lir.getControlFlowGraph().getStartBlock());
            instructions.add(1, op);
            lir.getDebug().dump(2, lir, "created rescue dummy op");
        }
    }

    @Override
    public Value emitCompress(Value pointer, CompressEncoding encoding, boolean nonNull) {
        LIRKind inputKind = (LIRKind)pointer.getValueKind(LIRKind.class);
        LIRKindTool lirKindTool = this.getLIRKindTool();
        LIRKind objectKind = lirKindTool.getObjectKind();
        assert (inputKind.getPlatformKind() == objectKind.getPlatformKind()) : Assertions.errorMessageContext("inputKind", (Object)inputKind, "lirKindToolObjectKind", (Object)objectKind, "pointer", pointer);
        if (inputKind.isReference(0)) {
            Variable result = this.newVariable(lirKindTool.getNarrowOopKind());
            this.append(new AMD64Move.CompressPointerOp(result, (Value)this.asAllocatable(pointer), (AllocatableValue)this.getProviders().getRegisters().getHeapBaseRegister().asValue(), encoding, nonNull, this.getLIRKindTool()));
            return result;
        }
        Variable result = this.newVariable(lirKindTool.getNarrowPointerKind());
        AllocatableValue base = Value.ILLEGAL;
        if (encoding.hasBase()) {
            base = this.emitLoadConstant(lirKindTool.getWordKind(), (Constant)JavaConstant.forLong((long)encoding.getBase()));
        }
        this.append(new AMD64Move.CompressPointerOp(result, (Value)this.asAllocatable(pointer), base, encoding, nonNull, this.getLIRKindTool()));
        return result;
    }

    @Override
    public Value emitUncompress(Value pointer, CompressEncoding encoding, boolean nonNull) {
        LIRKind inputKind = (LIRKind)pointer.getValueKind(LIRKind.class);
        LIRKindTool lirKindTool = this.getLIRKindTool();
        assert (inputKind.getPlatformKind() == lirKindTool.getNarrowOopKind().getPlatformKind()) : Assertions.errorMessageContext("inputKind", (Object)inputKind, "lirKindToolObjectKind", (Object)lirKindTool.getNarrowOopKind(), "pointer", pointer);
        if (inputKind.isReference(0)) {
            Variable result = this.newVariable(lirKindTool.getObjectKind());
            this.append(new AMD64Move.UncompressPointerOp(result, (Value)this.asAllocatable(pointer), (AllocatableValue)this.getProviders().getRegisters().getHeapBaseRegister().asValue(), encoding, nonNull, lirKindTool));
            return result;
        }
        LIRKind uncompressedKind = lirKindTool.getWordKind();
        Variable result = this.newVariable(uncompressedKind);
        AllocatableValue base = Value.ILLEGAL;
        if (encoding.hasBase()) {
            base = this.emitLoadConstant(uncompressedKind, (Constant)JavaConstant.forLong((long)encoding.getBase()));
        }
        this.append(new AMD64Move.UncompressPointerOp(result, (Value)this.asAllocatable(pointer), base, encoding, nonNull, lirKindTool));
        return result;
    }

    @Override
    public void emitNullCheck(Value address, LIRFrameState state) {
        if (address.getValueKind().getPlatformKind() == this.getLIRKindTool().getNarrowOopKind().getPlatformKind()) {
            Value uncompressed;
            CompressEncoding encoding = this.config.getOopEncoding();
            int shift = encoding.getShift();
            if (AMD64Address.isScaleShiftSupported(shift)) {
                LIRKind wordKind = LIRKind.unknownReference(this.target().arch.getWordKind());
                RegisterValue heapBase = this.getProviders().getRegisters().getHeapBaseRegister().asValue((ValueKind)wordKind);
                Stride stride = Stride.fromLog2(shift);
                uncompressed = new AMD64AddressValue(wordKind, (AllocatableValue)heapBase, this.asAllocatable(address), stride, 0);
            } else {
                uncompressed = this.emitUncompress(address, encoding, false);
            }
            this.append(new AMD64Move.NullCheckOp(this.asAddressValue(uncompressed), state));
            return;
        }
        super.emitNullCheck(address, state);
    }

    @Override
    public LIRInstruction createBenchmarkCounter(String name, String group, Value increment) {
        if (BenchmarkCounters.enabled) {
            return new AMD64HotSpotCounterOp(name, group, increment, this.getProviders().getRegisters(), this.config, this.getOrInitRescueSlot());
        }
        throw GraalError.shouldNotReachHere("BenchmarkCounters are not enabled!");
    }

    @Override
    public LIRInstruction createMultiBenchmarkCounter(String[] names, String[] groups, Value[] increments) {
        if (BenchmarkCounters.enabled) {
            return new AMD64HotSpotCounterOp(names, groups, increments, this.getProviders().getRegisters(), this.config, this.getOrInitRescueSlot());
        }
        throw GraalError.shouldNotReachHere("BenchmarkCounters are not enabled!");
    }

    @Override
    public void emitPrefetchAllocate(Value address) {
        this.append(new AMD64PrefetchOp(this.asAddressValue(address), this.config.allocatePrefetchInstr));
    }

    @Override
    protected AMD64ControlFlow.StrategySwitchOp createStrategySwitchOp(SwitchStrategy strategy, LabelRef[] keyTargets, LabelRef defaultTarget, AllocatableValue key, AllocatableValue temp) {
        return new AMD64HotSpotStrategySwitchOp(strategy, keyTargets, defaultTarget, key, temp);
    }

    @Override
    public Value emitTimeStamp() {
        AMD64ReadTimestampCounterWithProcid timestamp = new AMD64ReadTimestampCounterWithProcid();
        this.append(timestamp);
        AllocatableValue lo = timestamp.getLowResult();
        Value hi = this.getArithmetic().emitZeroExtend((Value)timestamp.getHighResult(), 32, 64);
        return this.combineLoAndHi((Value)lo, hi);
    }

    private Value combineLoAndHi(Value lo, Value hi) {
        Value shiftedHi = this.getArithmetic().emitShl(hi, this.emitConstant(LIRKind.value((PlatformKind)AMD64Kind.DWORD), (Constant)JavaConstant.forInt((int)32)));
        return this.getArithmetic().emitOr(shiftedHi, lo);
    }

    @Override
    public int getArrayLengthOffset() {
        return this.config.arrayOopDescLengthOffset();
    }

    @Override
    public Register getHeapBaseRegister() {
        return this.getProviders().getRegisters().getHeapBaseRegister();
    }

    class SaveRbp {
        final StandardOp.NoOp placeholder;

        SaveRbp(StandardOp.NoOp placeholder) {
            this.placeholder = placeholder;
        }

        public AllocatableValue finalize(boolean useStack) {
            assert (!AMD64HotSpotLIRGenerator.this.config.preserveFramePointer) : "rbp has been pushed onto the stack";
            Variable dst = useStack ? ((AMD64HotSpotFrameMapBuilder)AMD64HotSpotLIRGenerator.this.getResult().getFrameMapBuilder()).getRBPSpillSlot() : AMD64HotSpotLIRGenerator.this.newVariable(LIRKind.value((PlatformKind)AMD64Kind.QWORD));
            this.placeholder.replace(AMD64HotSpotLIRGenerator.this.getResult().getLIR(), new AMD64Move.MoveFromRegOp(AMD64Kind.QWORD, dst, (AllocatableValue)AMD64.rbp.asValue((ValueKind)LIRKind.value((PlatformKind)AMD64Kind.QWORD))));
            return dst;
        }

        public void remove() {
            this.placeholder.remove(AMD64HotSpotLIRGenerator.this.getResult().getLIR());
        }
    }

    private static final class RescueSlotDummyOp
    extends LIRInstruction {
        public static final LIRInstructionClass<RescueSlotDummyOp> TYPE = LIRInstructionClass.create(RescueSlotDummyOp.class);
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.UNINITIALIZED})
        private AllocatableValue slot;

        RescueSlotDummyOp(FrameMapBuilder frameMapBuilder, LIRKind kind) {
            super(TYPE);
            this.slot = frameMapBuilder.allocateSpillSlot(kind);
        }

        public AllocatableValue getSlot() {
            return this.slot;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb) {
        }
    }
}

