/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64;

import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotMarkId;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;

public class AMD64HotSpotMove {
    public static void decodeKlassPointer(AMD64MacroAssembler masm, Register register, Register scratch, AMD64Address address, GraalHotSpotVMConfig config) {
        CompressEncoding encoding = config.getKlassEncoding();
        masm.movl(register, address);
        if (encoding.getShift() != 0) {
            masm.shlq(register, encoding.getShift());
        }
        if (encoding.hasBase()) {
            assert (encoding.getBase() != 0L);
            masm.movq(scratch, encoding.getBase());
            masm.addq(register, scratch);
        }
    }

    public static final class HotSpotLoadMetaspaceConstantOp
    extends AMD64LIRInstruction
    implements StandardOp.LoadConstantOp {
        public static final LIRInstructionClass<HotSpotLoadMetaspaceConstantOp> TYPE = LIRInstructionClass.create(HotSpotLoadMetaspaceConstantOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        private AllocatableValue result;
        private final HotSpotMetaspaceConstant input;

        public HotSpotLoadMetaspaceConstantOp(AllocatableValue result, HotSpotMetaspaceConstant input) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.input = input;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            boolean compressed = this.input.isCompressed();
            if (ValueUtil.isRegister((Value)this.result)) {
                if (compressed) {
                    crb.recordInlineDataInCode((Constant)this.input);
                    masm.movl(ValueUtil.asRegister((Value)this.result), -559030611);
                } else {
                    crb.recordInlineDataInCode((Constant)this.input);
                    masm.movq(ValueUtil.asRegister((Value)this.result), -2401018187971961171L);
                }
            } else {
                assert (ValueUtil.isStackSlot((Value)this.result));
                if (compressed) {
                    crb.recordInlineDataInCode((Constant)this.input);
                    masm.movl((AMD64Address)crb.asAddress((Value)this.result), -559030611);
                } else {
                    throw GraalError.shouldNotReachHere("Cannot store 64-bit constants to memory");
                }
            }
        }

        @Override
        public Constant getConstant() {
            return this.input;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }
    }

    public static final class BaseMove
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<BaseMove> TYPE = LIRInstructionClass.create(BaseMove.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue result;

        public BaseMove(AllocatableValue result) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            masm.movq(ValueUtil.asRegister((Value)this.result), masm.getPlaceholder(-1));
            crb.recordMark(HotSpotMarkId.NARROW_KLASS_BASE_ADDRESS);
        }
    }

    public static final class HotSpotLoadObjectConstantOp
    extends AMD64LIRInstruction
    implements StandardOp.LoadConstantOp {
        public static final LIRInstructionClass<HotSpotLoadObjectConstantOp> TYPE = LIRInstructionClass.create(HotSpotLoadObjectConstantOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        private AllocatableValue result;
        private final HotSpotObjectConstant input;

        public HotSpotLoadObjectConstantOp(AllocatableValue result, HotSpotObjectConstant input) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.input = input;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            boolean compressed = this.input.isCompressed();
            if (crb.target.inlineObjects) {
                crb.recordInlineDataInCode((Constant)this.input);
                if (ValueUtil.isRegister((Value)this.result)) {
                    if (compressed) {
                        masm.movl(ValueUtil.asRegister((Value)this.result), -559030611);
                        return;
                    } else {
                        masm.movq(ValueUtil.asRegister((Value)this.result), -2401018187971961171L);
                    }
                    return;
                } else {
                    assert (ValueUtil.isStackSlot((Value)this.result));
                    if (!compressed) throw GraalError.shouldNotReachHere("Cannot store 64-bit constants to memory");
                    masm.movl((AMD64Address)crb.asAddress((Value)this.result), -559030611);
                }
                return;
            } else {
                if (!ValueUtil.isRegister((Value)this.result)) throw GraalError.shouldNotReachHere("Cannot directly store data patch to memory");
                AMD64Address address = (AMD64Address)crb.recordDataReferenceInCode((Constant)this.input, compressed ? 4 : 8);
                if (compressed) {
                    masm.movl(ValueUtil.asRegister((Value)this.result), address);
                    return;
                } else {
                    masm.movq(ValueUtil.asRegister((Value)this.result), address);
                }
            }
        }

        @Override
        public Constant getConstant() {
            return this.input;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }
    }
}

