/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64;

import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@Opcode(value="PUSH_INTERPRETER_FRAME")
final class AMD64HotSpotPushInterpreterFrameOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64HotSpotPushInterpreterFrameOp> TYPE = LIRInstructionClass.create(AMD64HotSpotPushInterpreterFrameOp.class);
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue frameSize;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue framePc;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue senderSp;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue initialInfo;
    private final GraalHotSpotVMConfig config;

    AMD64HotSpotPushInterpreterFrameOp(AllocatableValue frameSize, AllocatableValue framePc, AllocatableValue senderSp, AllocatableValue initialInfo, GraalHotSpotVMConfig config) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.frameSize = frameSize;
        this.framePc = framePc;
        this.senderSp = senderSp;
        this.initialInfo = initialInfo;
        this.config = config;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Register frameSizeRegister = ValueUtil.asRegister((Value)this.frameSize);
        Register framePcRegister = ValueUtil.asRegister((Value)this.framePc);
        Register senderSpRegister = ValueUtil.asRegister((Value)this.senderSp);
        Register initialInfoRegister = ValueUtil.asRegister((Value)this.initialInfo);
        int wordSize = 8;
        masm.subq(frameSizeRegister, 16);
        masm.push(framePcRegister);
        masm.push(initialInfoRegister);
        masm.movq(initialInfoRegister, AMD64.rsp);
        masm.subq(AMD64.rsp, frameSizeRegister);
        masm.movptr(new AMD64Address(initialInfoRegister, this.config.frameInterpreterFrameLastSpOffset * 8), 0);
        masm.movq(new AMD64Address(initialInfoRegister, this.config.frameInterpreterFrameSenderSpOffset * 8), senderSpRegister);
    }
}

