/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64;

import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.hotspot.HotSpotBackend;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotEpilogueBlockEndOp;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.amd64.AMD64Call;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;

@Opcode(value="UNWIND")
final class AMD64HotSpotUnwindOp
extends AMD64HotSpotEpilogueBlockEndOp {
    public static final LIRInstructionClass<AMD64HotSpotUnwindOp> TYPE = LIRInstructionClass.create(AMD64HotSpotUnwindOp.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected RegisterValue exception;

    AMD64HotSpotUnwindOp(RegisterValue exception) {
        super((LIRInstructionClass<? extends AMD64HotSpotEpilogueBlockEndOp>)TYPE);
        this.exception = exception;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        this.leaveFrameAndRestoreRbp(crb, masm);
        ForeignCallLinkage linkage = crb.getForeignCalls().lookupForeignCall(HotSpotBackend.UNWIND_EXCEPTION_TO_CALLER);
        CallingConvention cc = linkage.getOutgoingCallingConvention();
        assert (cc.getArgumentCount() == 2) : cc;
        assert (this.exception.equals((Object)cc.getArgument(0)));
        Register returnAddress = ValueUtil.asRegister((Value)cc.getArgument(1));
        masm.movq(returnAddress, new AMD64Address(AMD64.rsp, 0));
        AMD64Call.directJmp(crb, masm, linkage, null);
    }
}

