/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotZBarrieredOp;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.amd64.AMD64AddressValue;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@Opcode(value="CAS_Z")
public final class AMD64HotSpotZCompareAndSwapOp
extends AMD64HotSpotZBarrieredOp {
    public static final LIRInstructionClass<AMD64HotSpotZCompareAndSwapOp> TYPE = LIRInstructionClass.create(AMD64HotSpotZCompareAndSwapOp.class);
    private final AMD64Kind accessKind;
    @LIRInstruction.Use
    protected AllocatableValue cmpValue;
    @LIRInstruction.Alive
    protected AllocatableValue newValue;
    @LIRInstruction.Temp
    protected AllocatableValue temp;

    public AMD64HotSpotZCompareAndSwapOp(AMD64Kind accessKind, AllocatableValue result, AMD64AddressValue address, AllocatableValue cmpValue, AllocatableValue newValue, AllocatableValue temp, GraalHotSpotVMConfig config, ForeignCallLinkage callTarget) {
        super(TYPE, result, address, config, callTarget);
        this.accessKind = accessKind;
        this.cmpValue = cmpValue;
        this.newValue = newValue;
        this.temp = temp;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        GraalError.guarantee(this.accessKind == AMD64Kind.QWORD, "ZGC only supports uncomppressed oops");
        assert (ValueUtil.asRegister((Value)this.cmpValue).equals((Object)AMD64.rax)) : this.cmpValue;
        assert (ValueUtil.asRegister((Value)this.result).equals((Object)AMD64.rax)) : this.result;
        assert (LIRValueUtil.differentRegisters(new Object[]{this.cmpValue, this.newValue, this.temp, this.loadAddress}));
        Label success = new Label();
        Label barrierOk = new Label();
        Register newReg = ValueUtil.asRegister((Value)this.newValue);
        masm.movq(ValueUtil.asRegister((Value)this.temp), ValueUtil.asRegister((Value)this.cmpValue));
        if (crb.target.isMP) {
            masm.lock();
        }
        masm.cmpxchgq(newReg, this.loadAddress.toAddress());
        masm.jccb(AMD64Assembler.ConditionFlag.Zero, success);
        this.emitBarrier(crb, masm, AMD64.rax, barrierOk);
        masm.movq(ValueUtil.asRegister((Value)this.cmpValue), ValueUtil.asRegister((Value)this.temp));
        if (crb.target.isMP) {
            masm.lock();
        }
        masm.cmpxchgq(newReg, this.loadAddress.toAddress());
        masm.bind(barrierOk);
        masm.cmpq(ValueUtil.asRegister((Value)this.temp), ValueUtil.asRegister((Value)this.result));
        masm.bind(success);
    }
}

