/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.lir;

import java.util.EnumSet;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.phases.FinalCodeAnalysisPhase;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;

public final class VerifyMaxRegisterSizePhase
extends FinalCodeAnalysisPhase {
    private final int maxVectorSize;

    public VerifyMaxRegisterSizePhase(int maxVectorSize) {
        this.maxVectorSize = maxVectorSize;
    }

    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, FinalCodeAnalysisPhase.FinalCodeAnalysisContext context) {
        LIR lir = lirGenRes.getLIR();
        for (BasicBlock block : lir.getControlFlowGraph().getBlocks()) {
            this.verifyBlock(lir, block);
        }
    }

    protected void verifyBlock(LIR lir, BasicBlock<?> block) {
        for (LIRInstruction inst : lir.getLIRforBlock(block)) {
            this.verifyInstruction(inst);
        }
    }

    protected void verifyInstruction(LIRInstruction inst) {
        inst.visitEachInput(this::verifyOperands);
        inst.visitEachOutput(this::verifyOperands);
        inst.visitEachAlive(this::verifyOperands);
        inst.visitEachTemp(this::verifyOperands);
    }

    protected void verifyOperands(LIRInstruction instruction, Value value, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
        if (ValueUtil.isRegister((Value)value) && value.getPlatformKind().getVectorLength() > 1) assert (value.getPlatformKind().getSizeInBytes() <= this.maxVectorSize) : "value " + String.valueOf(value) + " exceeds MaxVectorSize " + this.maxVectorSize + " at " + String.valueOf(instruction);
    }
}

