/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.meta;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.calc.Condition;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.spi.ForeignCallSignature;
import jdk.graal.compiler.core.common.spi.ForeignCallsProvider;
import jdk.graal.compiler.core.common.spi.MetaAccessExtensionProvider;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.PrimitiveStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugHandlersFactory;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntimeProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import jdk.graal.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotLoweringProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.meta.HotSpotRegistersProvider;
import jdk.graal.compiler.hotspot.nodes.BeginLockScopeNode;
import jdk.graal.compiler.hotspot.nodes.HotSpotCompressionNode;
import jdk.graal.compiler.hotspot.nodes.HotSpotDirectCallTargetNode;
import jdk.graal.compiler.hotspot.nodes.HotSpotIndirectCallTargetNode;
import jdk.graal.compiler.hotspot.nodes.KlassBeingInitializedCheckNode;
import jdk.graal.compiler.hotspot.nodes.VMErrorNode;
import jdk.graal.compiler.hotspot.nodes.VirtualThreadUpdateJFRNode;
import jdk.graal.compiler.hotspot.nodes.type.HotSpotNarrowOopStamp;
import jdk.graal.compiler.hotspot.nodes.type.KlassPointerStamp;
import jdk.graal.compiler.hotspot.nodes.type.MethodPointerStamp;
import jdk.graal.compiler.hotspot.replacements.AssertionSnippets;
import jdk.graal.compiler.hotspot.replacements.ClassGetHubNode;
import jdk.graal.compiler.hotspot.replacements.DigestBaseSnippets;
import jdk.graal.compiler.hotspot.replacements.FastNotifyNode;
import jdk.graal.compiler.hotspot.replacements.HotSpotAllocationSnippets;
import jdk.graal.compiler.hotspot.replacements.HotSpotG1WriteBarrierSnippets;
import jdk.graal.compiler.hotspot.replacements.HotSpotHashCodeSnippets;
import jdk.graal.compiler.hotspot.replacements.HotSpotIsArraySnippets;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.hotspot.replacements.HotSpotSerialWriteBarrierSnippets;
import jdk.graal.compiler.hotspot.replacements.HubGetClassNode;
import jdk.graal.compiler.hotspot.replacements.InstanceOfSnippets;
import jdk.graal.compiler.hotspot.replacements.KlassLayoutHelperNode;
import jdk.graal.compiler.hotspot.replacements.LoadExceptionObjectSnippets;
import jdk.graal.compiler.hotspot.replacements.LogSnippets;
import jdk.graal.compiler.hotspot.replacements.MonitorSnippets;
import jdk.graal.compiler.hotspot.replacements.ObjectCloneSnippets;
import jdk.graal.compiler.hotspot.replacements.ObjectSnippets;
import jdk.graal.compiler.hotspot.replacements.RegisterFinalizerSnippets;
import jdk.graal.compiler.hotspot.replacements.StringToBytesSnippets;
import jdk.graal.compiler.hotspot.replacements.UnsafeCopyMemoryNode;
import jdk.graal.compiler.hotspot.replacements.UnsafeSnippets;
import jdk.graal.compiler.hotspot.replacements.VirtualThreadUpdateJFRSnippets;
import jdk.graal.compiler.hotspot.replacements.arraycopy.CheckcastArrayCopyCallNode;
import jdk.graal.compiler.hotspot.replacements.arraycopy.GenericArrayCopyCallNode;
import jdk.graal.compiler.hotspot.replacements.arraycopy.HotSpotArraycopySnippets;
import jdk.graal.compiler.hotspot.stubs.ForeignCallSnippets;
import jdk.graal.compiler.hotspot.word.KlassPointer;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractDeoptimizeNode;
import jdk.graal.compiler.nodes.CompressionNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.DeadEndNode;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GetObjectAddressNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.LoweredCallTargetNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.SafepointNode;
import jdk.graal.compiler.nodes.StartNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.calc.IntegerConvertNode;
import jdk.graal.compiler.nodes.calc.IntegerDivRemNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.calc.LeftShiftNode;
import jdk.graal.compiler.nodes.calc.RemNode;
import jdk.graal.compiler.nodes.calc.SignedDivNode;
import jdk.graal.compiler.nodes.calc.SignedFloatingIntegerDivNode;
import jdk.graal.compiler.nodes.calc.SignedFloatingIntegerRemNode;
import jdk.graal.compiler.nodes.calc.SignedRemNode;
import jdk.graal.compiler.nodes.debug.StringToBytesNode;
import jdk.graal.compiler.nodes.debug.VerifyHeapNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.extended.GetClassNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.extended.LoadHubNode;
import jdk.graal.compiler.nodes.extended.LoadMethodNode;
import jdk.graal.compiler.nodes.extended.OSRLocalNode;
import jdk.graal.compiler.nodes.extended.OSRLockNode;
import jdk.graal.compiler.nodes.extended.OSRMonitorEnterNode;
import jdk.graal.compiler.nodes.extended.OSRStartNode;
import jdk.graal.compiler.nodes.extended.StoreHubNode;
import jdk.graal.compiler.nodes.gc.G1ArrayRangePostWriteBarrier;
import jdk.graal.compiler.nodes.gc.G1ArrayRangePreWriteBarrier;
import jdk.graal.compiler.nodes.gc.G1PostWriteBarrier;
import jdk.graal.compiler.nodes.gc.G1PreWriteBarrier;
import jdk.graal.compiler.nodes.gc.G1ReferentFieldReadBarrier;
import jdk.graal.compiler.nodes.gc.SerialArrayRangeWriteBarrier;
import jdk.graal.compiler.nodes.gc.SerialWriteBarrier;
import jdk.graal.compiler.nodes.java.ClassIsAssignableFromNode;
import jdk.graal.compiler.nodes.java.DynamicNewArrayNode;
import jdk.graal.compiler.nodes.java.DynamicNewInstanceNode;
import jdk.graal.compiler.nodes.java.InstanceOfDynamicNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.java.LoadExceptionObjectNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.java.MonitorEnterNode;
import jdk.graal.compiler.nodes.java.MonitorExitNode;
import jdk.graal.compiler.nodes.java.MonitorIdNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.graal.compiler.nodes.java.NewInstanceNode;
import jdk.graal.compiler.nodes.java.NewMultiArrayNode;
import jdk.graal.compiler.nodes.java.RegisterFinalizerNode;
import jdk.graal.compiler.nodes.java.ValidateNewInstanceClassNode;
import jdk.graal.compiler.nodes.memory.FloatingReadNode;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.memory.WriteNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.nodes.spi.PlatformConfigurationProvider;
import jdk.graal.compiler.nodes.spi.StampProvider;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.replacements.DefaultJavaLoweringProvider;
import jdk.graal.compiler.replacements.IdentityHashCodeSnippets;
import jdk.graal.compiler.replacements.IsArraySnippets;
import jdk.graal.compiler.replacements.arraycopy.ArrayCopyNode;
import jdk.graal.compiler.replacements.arraycopy.ArrayCopySnippets;
import jdk.graal.compiler.replacements.arraycopy.ArrayCopyWithDelayedLoweringNode;
import jdk.graal.compiler.replacements.nodes.AssertionNode;
import jdk.graal.compiler.replacements.nodes.CStringConstant;
import jdk.graal.compiler.replacements.nodes.LogNode;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.hotspot.HotSpotConstantReflectionProvider;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.services.Services;
import org.graalvm.word.LocationIdentity;

public abstract class DefaultHotSpotLoweringProvider
extends DefaultJavaLoweringProvider
implements HotSpotLoweringProvider {
    protected final HotSpotGraalRuntimeProvider runtime;
    protected final HotSpotRegistersProvider registers;
    protected final HotSpotConstantReflectionProvider constantReflection;
    protected InstanceOfSnippets.Templates instanceofSnippets;
    protected HotSpotAllocationSnippets.Templates allocationSnippets;
    protected MonitorSnippets.Templates monitorSnippets;
    protected HotSpotSerialWriteBarrierSnippets.Templates serialWriteBarrierSnippets;
    protected HotSpotG1WriteBarrierSnippets.Templates g1WriteBarrierSnippets;
    protected LoadExceptionObjectSnippets.Templates exceptionObjectSnippets;
    protected AssertionSnippets.Templates assertionSnippets;
    protected LogSnippets.Templates logSnippets;
    protected ArrayCopySnippets.Templates arraycopySnippets;
    protected StringToBytesSnippets.Templates stringToBytesSnippets;
    protected ObjectSnippets.Templates objectSnippets;
    protected UnsafeSnippets.Templates unsafeSnippets;
    protected ObjectCloneSnippets.Templates objectCloneSnippets;
    protected ForeignCallSnippets.Templates foreignCallSnippets;
    protected RegisterFinalizerSnippets.Templates registerFinalizerSnippets;
    protected VirtualThreadUpdateJFRSnippets.Templates virtualThreadUpdateJFRSnippets;
    protected final Map<Class<? extends Node>, Extension> extensions = new HashMap<Class<? extends Node>, Extension>();

    public DefaultHotSpotLoweringProvider(HotSpotGraalRuntimeProvider runtime, MetaAccessProvider metaAccess, ForeignCallsProvider foreignCalls, HotSpotRegistersProvider registers, HotSpotConstantReflectionProvider constantReflection, PlatformConfigurationProvider platformConfig, MetaAccessExtensionProvider metaAccessExtensionProvider, TargetDescription target) {
        super(metaAccess, foreignCalls, platformConfig, metaAccessExtensionProvider, target, runtime.getVMConfig().useCompressedOops);
        this.runtime = runtime;
        this.registers = registers;
        this.constantReflection = constantReflection;
    }

    public HotSpotGraalRuntimeProvider getRuntime() {
        return this.runtime;
    }

    public HotSpotRegistersProvider getRegisters() {
        return this.registers;
    }

    public HotSpotConstantReflectionProvider getConstantReflection() {
        return this.constantReflection;
    }

    @Override
    public void initialize(OptionValues options, Iterable<DebugHandlersFactory> factories, HotSpotProviders providers, GraalHotSpotVMConfig config) {
        this.initialize(options, factories, providers, config, new ArrayCopySnippets.Templates(new HotSpotArraycopySnippets(), this.runtime, options, providers), new HotSpotAllocationSnippets.Templates(new HotSpotAllocationSnippets(config, providers.getRegisters()), options, this.runtime, providers, config));
    }

    public void initialize(OptionValues options, Iterable<DebugHandlersFactory> factories, HotSpotProviders providers, GraalHotSpotVMConfig config, ArrayCopySnippets.Templates arraycopySnippetTemplates, HotSpotAllocationSnippets.Templates allocationSnippetTemplates) {
        super.initialize(options, this.runtime, providers);
        assert (this.target == providers.getCodeCache().getTarget()) : Assertions.errorMessage(this.target, providers.getCodeCache().getTarget());
        this.instanceofSnippets = new InstanceOfSnippets.Templates(options, this.runtime, providers);
        this.allocationSnippets = allocationSnippetTemplates;
        this.monitorSnippets = new MonitorSnippets.Templates(options, this.runtime, providers, config);
        this.g1WriteBarrierSnippets = new HotSpotG1WriteBarrierSnippets.Templates(options, this.runtime, providers, config);
        this.serialWriteBarrierSnippets = new HotSpotSerialWriteBarrierSnippets.Templates(options, this.runtime, providers);
        this.exceptionObjectSnippets = new LoadExceptionObjectSnippets.Templates(options, providers);
        this.assertionSnippets = new AssertionSnippets.Templates(options, providers);
        this.logSnippets = new LogSnippets.Templates(options, providers);
        this.arraycopySnippets = arraycopySnippetTemplates;
        this.stringToBytesSnippets = new StringToBytesSnippets.Templates(options, providers);
        this.identityHashCodeSnippets = new IdentityHashCodeSnippets.Templates(new HotSpotHashCodeSnippets(), options, providers, HotSpotReplacementsUtil.MARK_WORD_LOCATION);
        this.isArraySnippets = new IsArraySnippets.Templates(new HotSpotIsArraySnippets(), options, providers);
        this.objectCloneSnippets = new ObjectCloneSnippets.Templates(options, providers);
        this.foreignCallSnippets = new ForeignCallSnippets.Templates(options, providers);
        this.registerFinalizerSnippets = new RegisterFinalizerSnippets.Templates(options, providers);
        this.objectSnippets = new ObjectSnippets.Templates(options, providers);
        this.unsafeSnippets = new UnsafeSnippets.Templates(options, providers);
        this.virtualThreadUpdateJFRSnippets = new VirtualThreadUpdateJFRSnippets.Templates(options, providers);
        this.replacements.registerSnippetTemplateCache(new DigestBaseSnippets.Templates(options, providers));
        this.initializeExtensions(options, factories, providers, config, GraalServices.load(Extensions.class));
    }

    @Override
    public final void initializeExtensions(OptionValues options, Iterable<DebugHandlersFactory> factories, HotSpotProviders providers, GraalHotSpotVMConfig config, Iterable<Extensions> iterableExtensions) throws GraalError {
        for (Extensions ep : iterableExtensions) {
            for (Extension ext : ep.createExtensions()) {
                Class<? extends Node> nodeType = ext.getNodeType();
                Extension old = this.extensions.put(nodeType, ext);
                if (old != null) {
                    throw new GraalError("Two lowering extensions conflict on the handling of %s: %s and %s", nodeType.getName(), old, ext);
                }
                ext.initialize(providers, options, config, (HotSpotHostForeignCallsProvider)this.foreignCalls, factories);
            }
        }
    }

    public HotSpotAllocationSnippets.Templates getAllocationSnippets() {
        return this.allocationSnippets;
    }

    public ArrayCopySnippets.Templates getArraycopySnippets() {
        return this.arraycopySnippets;
    }

    public MonitorSnippets.Templates getMonitorSnippets() {
        return this.monitorSnippets;
    }

    private boolean lowerWithoutDelegation(Node n, LoweringTool tool) {
        StructuredGraph graph = (StructuredGraph)n.graph();
        if (n instanceof Invoke) {
            this.lowerInvoke((Invoke)((Object)n), tool, graph);
        } else if (n instanceof LoadMethodNode) {
            this.lowerLoadMethodNode((LoadMethodNode)n);
        } else if (n instanceof GetClassNode) {
            DefaultHotSpotLoweringProvider.lowerGetClassNode((GetClassNode)n, tool, graph);
        } else if (n instanceof StoreHubNode) {
            this.lowerStoreHubNode((StoreHubNode)n, graph);
        } else if (n instanceof OSRStartNode) {
            this.lowerOSRStartNode((OSRStartNode)n);
        } else if (n instanceof BytecodeExceptionNode) {
            if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.MID_TIER) {
                this.lowerBytecodeExceptionNode((BytecodeExceptionNode)n);
            }
        } else if (n instanceof InstanceOfNode) {
            InstanceOfNode instanceOfNode = (InstanceOfNode)n;
            if (graph.getGuardsStage().areDeoptsFixed()) {
                this.instanceofSnippets.lower(instanceOfNode, tool);
            } else if (instanceOfNode.allowsNull()) {
                ValueNode object = instanceOfNode.getValue();
                LogicNode newTypeCheck = graph.addOrUniqueWithInputs(InstanceOfNode.create(instanceOfNode.type(), object, instanceOfNode.profile(), instanceOfNode.getAnchor()));
                LogicNode newNode = LogicNode.or(graph.unique(IsNullNode.create(object)), newTypeCheck, BranchProbabilityNode.NOT_LIKELY_PROFILE);
                instanceOfNode.replaceAndDelete(newNode);
            }
        } else if (n instanceof InstanceOfDynamicNode) {
            InstanceOfDynamicNode instanceOfDynamicNode = (InstanceOfDynamicNode)n;
            if (graph.getGuardsStage().areDeoptsFixed()) {
                this.instanceofSnippets.lower(instanceOfDynamicNode, tool);
            } else {
                ValueNode mirror = instanceOfDynamicNode.getMirrorOrHub();
                if (mirror.stamp(NodeView.DEFAULT).getStackKind() == JavaKind.Object) {
                    ClassGetHubNode classGetHub = graph.unique(new ClassGetHubNode(mirror));
                    instanceOfDynamicNode.setMirror(classGetHub);
                }
                if (instanceOfDynamicNode.allowsNull()) {
                    ValueNode object = instanceOfDynamicNode.getObject();
                    LogicNode newTypeCheck = graph.addOrUniqueWithInputs(InstanceOfDynamicNode.create(graph.getAssumptions(), tool.getConstantReflection(), instanceOfDynamicNode.getMirrorOrHub(), object, false, instanceOfDynamicNode.isExact()));
                    LogicNode newNode = LogicNode.or(graph.unique(IsNullNode.create(object)), newTypeCheck, BranchProbabilityNode.NOT_LIKELY_PROFILE);
                    instanceOfDynamicNode.replaceAndDelete(newNode);
                }
            }
        } else if (n instanceof ClassIsAssignableFromNode) {
            if (graph.getGuardsStage().areDeoptsFixed()) {
                this.instanceofSnippets.lower((ClassIsAssignableFromNode)n, tool);
            }
        } else if (n instanceof NewInstanceNode) {
            if (graph.getGuardsStage().areFrameStatesAtDeopts()) {
                this.getAllocationSnippets().lower((NewInstanceNode)n, tool);
            }
        } else if (n instanceof DynamicNewInstanceNode) {
            if (graph.getGuardsStage().areFrameStatesAtDeopts()) {
                this.getAllocationSnippets().lower((DynamicNewInstanceNode)n, tool);
            }
        } else if (n instanceof ValidateNewInstanceClassNode) {
            ValidateNewInstanceClassNode validateNewInstance = (ValidateNewInstanceClassNode)n;
            if (validateNewInstance.getClassClass() == null) {
                JavaConstant classClassMirror = this.constantReflection.asJavaClass(this.metaAccess.lookupJavaType(Class.class));
                ConstantNode classClass = ConstantNode.forConstant(classClassMirror, tool.getMetaAccess(), graph);
                validateNewInstance.setClassClass(classClass);
            }
            this.getAllocationSnippets().lower(validateNewInstance, tool);
        } else if (n instanceof NewArrayNode) {
            if (graph.getGuardsStage().areFrameStatesAtDeopts()) {
                this.getAllocationSnippets().lower((NewArrayNode)n, tool);
            }
        } else if (n instanceof DynamicNewArrayNode) {
            DynamicNewArrayNode dynamicNewArrayNode = (DynamicNewArrayNode)n;
            if (dynamicNewArrayNode.getVoidClass() == null) {
                JavaConstant voidClassMirror = this.constantReflection.asJavaClass(this.metaAccess.lookupJavaType(Void.TYPE));
                ConstantNode voidClass = ConstantNode.forConstant(voidClassMirror, tool.getMetaAccess(), graph);
                dynamicNewArrayNode.setVoidClass(voidClass);
            }
            if (graph.getGuardsStage().areFrameStatesAtDeopts()) {
                this.getAllocationSnippets().lower(dynamicNewArrayNode, tool);
            }
        } else if (n instanceof VerifyHeapNode) {
            if (graph.getGuardsStage().areFrameStatesAtDeopts()) {
                this.getAllocationSnippets().lower((VerifyHeapNode)n, tool);
            }
        } else if (n instanceof MonitorEnterNode) {
            if (graph.getGuardsStage().areFrameStatesAtDeopts()) {
                this.monitorSnippets.lower((MonitorEnterNode)n, this.registers, tool);
            } else {
                this.loadHubForMonitorEnterNode((MonitorEnterNode)n, tool, graph);
            }
        } else if (n instanceof MonitorExitNode) {
            if (graph.getGuardsStage().areFrameStatesAtDeopts()) {
                this.monitorSnippets.lower((MonitorExitNode)n, this.registers, tool);
            }
        } else if (n instanceof ArrayCopyNode) {
            this.arraycopySnippets.lower((ArrayCopyNode)n, tool);
        } else if (n instanceof GenericArrayCopyCallNode) {
            GenericArrayCopyCallNode arraycopy = (GenericArrayCopyCallNode)n;
            this.lowerGenericArrayCopyCallNode(arraycopy);
        } else if (n instanceof CheckcastArrayCopyCallNode) {
            this.lowerCheckcastArrayCopyCallNode((CheckcastArrayCopyCallNode)n, tool);
        } else if (n instanceof ArrayCopyWithDelayedLoweringNode) {
            this.arraycopySnippets.lower((ArrayCopyWithDelayedLoweringNode)n, tool);
        } else if (n instanceof G1PreWriteBarrier) {
            this.g1WriteBarrierSnippets.lower((G1PreWriteBarrier)n, tool);
        } else if (n instanceof G1PostWriteBarrier) {
            this.g1WriteBarrierSnippets.lower((G1PostWriteBarrier)n, tool);
        } else if (n instanceof G1ReferentFieldReadBarrier) {
            this.g1WriteBarrierSnippets.lower((G1ReferentFieldReadBarrier)n, tool);
        } else if (n instanceof SerialWriteBarrier) {
            this.serialWriteBarrierSnippets.lower((SerialWriteBarrier)n, tool);
        } else if (n instanceof SerialArrayRangeWriteBarrier) {
            this.serialWriteBarrierSnippets.lower((SerialArrayRangeWriteBarrier)n, tool);
        } else if (n instanceof G1ArrayRangePreWriteBarrier) {
            this.g1WriteBarrierSnippets.lower((G1ArrayRangePreWriteBarrier)n, tool);
        } else if (n instanceof G1ArrayRangePostWriteBarrier) {
            this.g1WriteBarrierSnippets.lower((G1ArrayRangePostWriteBarrier)n, tool);
        } else if (n instanceof NewMultiArrayNode) {
            if (graph.getGuardsStage().areFrameStatesAtDeopts()) {
                this.getAllocationSnippets().lower((NewMultiArrayNode)n, tool);
            }
        } else if (n instanceof LoadExceptionObjectNode) {
            this.exceptionObjectSnippets.lower((LoadExceptionObjectNode)n, this.registers, tool);
        } else if (n instanceof AssertionNode) {
            this.assertionSnippets.lower((AssertionNode)n, tool);
        } else if (n instanceof LogNode) {
            this.logSnippets.lower((LogNode)n, tool);
        } else if (n instanceof StringToBytesNode) {
            if (graph.getGuardsStage().areDeoptsFixed()) {
                this.stringToBytesSnippets.lower((StringToBytesNode)n, tool);
            }
        } else if (!(n instanceof AbstractDeoptimizeNode || n instanceof UnwindNode || n instanceof RemNode || n instanceof SafepointNode)) {
            if (n instanceof ClassGetHubNode) {
                this.lowerClassGetHubNode((ClassGetHubNode)n, tool);
            } else if (n instanceof HubGetClassNode) {
                this.lowerHubGetClassNode((HubGetClassNode)n, tool);
            } else if (n instanceof KlassLayoutHelperNode) {
                if (graph.getGuardsStage() == GraphState.GuardsStage.AFTER_FSA) {
                    this.lowerKlassLayoutHelperNode((KlassLayoutHelperNode)n, tool);
                }
            } else if (n instanceof KlassBeingInitializedCheckNode) {
                if (graph.getGuardsStage() == GraphState.GuardsStage.AFTER_FSA) {
                    this.getAllocationSnippets().lower((KlassBeingInitializedCheckNode)n, tool);
                }
            } else if (n instanceof FastNotifyNode) {
                if (graph.getGuardsStage() == GraphState.GuardsStage.AFTER_FSA) {
                    this.objectSnippets.lower(n, tool);
                }
            } else if (n instanceof UnsafeCopyMemoryNode) {
                if (graph.getGuardsStage() == GraphState.GuardsStage.AFTER_FSA) {
                    this.unsafeSnippets.lower((UnsafeCopyMemoryNode)n, tool);
                }
            } else if (n instanceof RegisterFinalizerNode) {
                this.lowerRegisterFinalizer((RegisterFinalizerNode)n, tool);
            } else if (n instanceof DeadEndNode) {
                this.lowerDeadEnd((DeadEndNode)n);
            } else if (n instanceof IntegerDivRemNode) {
                if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
                    this.lowerIntegerDivRem((IntegerDivRemNode)n, tool);
                }
            } else if (n instanceof VirtualThreadUpdateJFRNode) {
                if (graph.getGuardsStage() == GraphState.GuardsStage.AFTER_FSA) {
                    this.virtualThreadUpdateJFRSnippets.lower((VirtualThreadUpdateJFRNode)n, this.registers, tool);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private void lowerGenericArrayCopyCallNode(GenericArrayCopyCallNode arraycopy) {
        StructuredGraph graph = arraycopy.graph();
        if (graph.getGuardsStage().areFrameStatesAtDeopts()) {
            GetObjectAddressNode srcAddr = graph.add(new GetObjectAddressNode(arraycopy.getSource()));
            graph.addBeforeFixed(arraycopy, srcAddr);
            GetObjectAddressNode destAddr = graph.add(new GetObjectAddressNode(arraycopy.getDestination()));
            graph.addBeforeFixed(arraycopy, destAddr);
            ForeignCallNode call = graph.add(new ForeignCallNode(this.foreignCalls, HotSpotHostForeignCallsProvider.GENERIC_ARRAYCOPY, srcAddr, arraycopy.getSrcPos(), destAddr, arraycopy.getDestPos(), arraycopy.getLength()));
            call.setStateAfter(arraycopy.stateAfter());
            graph.replaceFixedWithFixed(arraycopy, call);
        }
    }

    private ValueNode computeBase(LoweringTool tool, CheckcastArrayCopyCallNode n, ValueNode base, ValueNode pos) {
        FixedWithNextNode basePtr = base.graph().add(new GetObjectAddressNode(base));
        base.graph().addBeforeFixed(n, basePtr);
        int shift = CodeUtil.log2((int)tool.getMetaAccess().getArrayIndexScale(JavaKind.Object));
        ValueNode extendedPos = IntegerConvertNode.convert(pos, StampFactory.forKind(this.target.wordJavaKind), base.graph(), NodeView.DEFAULT);
        ValueNode scaledIndex = base.graph().unique(new LeftShiftNode(extendedPos, ConstantNode.forInt(shift, base.graph())));
        ValueNode offset = base.graph().unique(new AddNode(scaledIndex, ConstantNode.forIntegerBits(PrimitiveStamp.getBits(scaledIndex.stamp(NodeView.DEFAULT)), tool.getMetaAccess().getArrayBaseOffset(JavaKind.Object), base.graph())));
        return base.graph().unique(new OffsetAddressNode(basePtr, offset));
    }

    protected void lowerCheckcastArrayCopyCallNode(CheckcastArrayCopyCallNode n, LoweringTool tool) {
        StructuredGraph graph = n.graph();
        if (n.graph().getGuardsStage().areFrameStatesAtDeopts()) {
            ForeignCallDescriptor desc = ((HotSpotHostForeignCallsProvider)this.foreignCalls).lookupCheckcastArraycopyDescriptor(n.isUninit());
            ValueNode srcAddr = this.computeBase(tool, n, n.getSource(), n.getSourcePosition());
            ValueNode destAddr = this.computeBase(tool, n, n.getDestination(), n.getDestinationPosition());
            ValueNode len = n.getLength();
            if (len.stamp(NodeView.DEFAULT).getStackKind() != this.target.wordJavaKind) {
                len = IntegerConvertNode.convert(len, StampFactory.forKind(this.target.wordJavaKind), graph, NodeView.DEFAULT);
            }
            ForeignCallNode call = graph.add(new ForeignCallNode(desc, srcAddr, destAddr, len, n.getSuperCheckOffset(), n.getDestElemKlass()));
            call.setStateAfter(n.stateAfter());
            graph.replaceFixedWithFixed(n, call);
        }
    }

    protected void lowerIntegerDivRem(IntegerDivRemNode n, LoweringTool tool) {
        long minValue;
        if (!n.canFloat()) {
            return;
        }
        ValueNode dividend = n.getX();
        ValueNode divisor = n.getY();
        IntegerStamp dividendStamp = (IntegerStamp)dividend.stamp(NodeView.DEFAULT);
        IntegerStamp divisorStamp = (IntegerStamp)divisor.stamp(NodeView.DEFAULT);
        StructuredGraph graph = n.graph();
        if (!(n instanceof SignedDivNode) && !(n instanceof SignedRemNode)) {
            return;
        }
        if (n.getY().isConstant() && n.getY().asJavaConstant().asLong() == 0L) {
            return;
        }
        if (!GraalOptions.FloatingDivNodes.getValue(n.getOptions()).booleanValue()) {
            return;
        }
        boolean divisionOverflowIsJVMSCompliant = tool.getLowerer().divisionOverflowIsJVMSCompliant();
        if (!divisionOverflowIsJVMSCompliant && dividendStamp.contains(minValue = NumUtil.minValue(dividendStamp.getBits())) && divisorStamp.contains(-1L)) {
            return;
        }
        GuardingNode guard = null;
        if (n.getZeroGuard() == null) {
            boolean val;
            LogicNode conditionDivisor = graph.addOrUniqueWithInputs(CompareNode.createAnyCompareNode(Condition.EQ, n.getY(), ConstantNode.forIntegerBits(divisorStamp.getBits(), 0L), tool.getConstantReflection()));
            if (conditionDivisor instanceof LogicConstantNode && (val = ((LogicConstantNode)conditionDivisor).getValue())) {
                return;
            }
            guard = tool.createGuard(n, conditionDivisor, DeoptimizationReason.ArithmeticException, DeoptimizationAction.InvalidateReprofile, SpeculationLog.NO_SPECULATION, true, null);
            IntegerStamp stampWithout0 = IntegerStamp.create(divisorStamp.getBits(), divisorStamp.lowerBound(), divisorStamp.upperBound(), divisorStamp.mustBeSet(), divisorStamp.mayBeSet(), false);
            divisor = graph.addOrUnique(PiNode.create(n.getY(), stampWithout0, guard.asNode()));
        } else {
            guard = n.getZeroGuard();
            if (divisorStamp.contains(0L)) {
                IntegerStamp stampWithout0 = IntegerStamp.create(divisorStamp.getBits(), divisorStamp.lowerBound(), divisorStamp.upperBound(), divisorStamp.mustBeSet(), divisorStamp.mayBeSet(), false);
                divisor = graph.addOrUnique(PiNode.create(n.getY(), stampWithout0, guard.asNode()));
            }
        }
        GraalError.guarantee(SignedDivNode.divisionIsJVMSCompliant(dividend, divisor, divisionOverflowIsJVMSCompliant), "Division must be allowed to float at this point. Dividend %s divisor %s", (Object)dividend, (Object)divisor);
        ValueNode divRem = null;
        if (n instanceof SignedDivNode) {
            divRem = graph.addOrUnique(SignedFloatingIntegerDivNode.create(dividend, divisor, NodeView.DEFAULT, guard, divisionOverflowIsJVMSCompliant));
        } else if (n instanceof SignedRemNode) {
            divRem = graph.addOrUnique(SignedFloatingIntegerRemNode.create(dividend, divisor, NodeView.DEFAULT, guard, divisionOverflowIsJVMSCompliant));
        } else {
            throw GraalError.shouldNotReachHere("Unkown division node " + String.valueOf(n));
        }
        n.replaceAtUsages(divRem);
        graph.replaceFixedWithFloating(n, divRem);
    }

    @Override
    public void lower(Node n, LoweringTool tool) {
        try (DebugCloseable context = n.withNodeSourcePosition();){
            Class<?> nodeType = n.getClass();
            if (!this.lowerWithoutDelegation(n, tool)) {
                Extension ext = this.extensions.get(nodeType);
                if (ext != null) {
                    ext.lower(ext.getNodeType().cast(n), tool);
                } else {
                    super.lower(n, tool);
                }
            } else {
                Extension ext = this.extensions.get(nodeType);
                if (ext != null) {
                    throw new GraalError("Extension %s is redundant - %s directly handles lowering of %s nodes", ext, this.getClass().getName(), nodeType.getName());
                }
            }
        }
    }

    protected void loadHubForMonitorEnterNode(MonitorEnterNode monitor, LoweringTool tool, StructuredGraph graph) {
        if (monitor.getObjectData() == null) {
            ValueNode objectNonNull = this.createNullCheckedValue(monitor.object(), monitor, tool);
            monitor.setObject(objectNonNull);
            monitor.setObjectData(graph.addOrUnique(LoadHubNode.create(objectNonNull, tool.getStampProvider(), tool.getMetaAccess(), tool.getConstantReflection())));
        }
    }

    private void lowerKlassLayoutHelperNode(KlassLayoutHelperNode n, LoweringTool tool) {
        if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
            return;
        }
        StructuredGraph graph = n.graph();
        assert (!n.getHub().isConstant());
        AddressNode address = this.createOffsetAddress(graph, n.getHub(), this.runtime.getVMConfig().klassLayoutHelperOffset);
        n.replaceAtUsagesAndDelete(graph.unique(new FloatingReadNode(address, HotSpotReplacementsUtil.KLASS_LAYOUT_HELPER_LOCATION, null, n.stamp(NodeView.DEFAULT), null, BarrierType.NONE)));
    }

    private void lowerHubGetClassNode(HubGetClassNode n, LoweringTool tool) {
        if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
            return;
        }
        ValueNode hub = n.getHub();
        GraalHotSpotVMConfig vmConfig = this.runtime.getVMConfig();
        StructuredGraph graph = n.graph();
        assert (!hub.isConstant());
        AddressNode mirrorAddress = this.createOffsetAddress(graph, hub, vmConfig.classMirrorOffset);
        Stamp loadStamp = n.stamp(NodeView.DEFAULT);
        FloatingReadNode read = graph.unique(new FloatingReadNode(mirrorAddress, HotSpotReplacementsUtil.CLASS_MIRROR_LOCATION, null, StampFactory.forKind(this.target.wordJavaKind), null, BarrierType.NONE));
        AddressNode address = this.createOffsetAddress(graph, read, 0L);
        read = graph.unique(new FloatingReadNode(address, HotSpotReplacementsUtil.HOTSPOT_OOP_HANDLE_LOCATION, null, loadStamp, null, this.barrierSet.readBarrierType(HotSpotReplacementsUtil.HOTSPOT_OOP_HANDLE_LOCATION, address, loadStamp)));
        n.replaceAtUsagesAndDelete(read);
    }

    private void lowerClassGetHubNode(ClassGetHubNode n, LoweringTool tool) {
        if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
            return;
        }
        StructuredGraph graph = n.graph();
        assert (!n.getValue().isConstant());
        AddressNode address = this.createOffsetAddress(graph, n.getValue(), this.runtime.getVMConfig().klassOffset);
        FloatingReadNode read = graph.unique(new FloatingReadNode(address, HotSpotReplacementsUtil.CLASS_KLASS_LOCATION, null, n.stamp(NodeView.DEFAULT), null, BarrierType.NONE));
        n.replaceAtUsagesAndDelete(read);
    }

    private void lowerInvoke(Invoke invoke, LoweringTool tool, StructuredGraph graph) {
        if (invoke.callTarget() instanceof Lowerable) {
            ((Lowerable)((Object)invoke.callTarget())).lower(tool);
        }
        if (invoke.callTarget() instanceof MethodCallTargetNode) {
            ResolvedJavaType receiverType;
            HotSpotResolvedJavaMethod hsMethod;
            ValueNode receiver;
            MethodCallTargetNode callTarget = (MethodCallTargetNode)invoke.callTarget();
            assert (callTarget.getClass() == MethodCallTargetNode.class) : "unexpected subclass of MethodCallTargetNode";
            NodeInputList<ValueNode> parameters = callTarget.arguments();
            ValueNode valueNode = receiver = parameters.isEmpty() ? null : (ValueNode)parameters.get(0);
            if (!callTarget.isStatic()) {
                assert (receiver != null) : "non-static call must have a receiver";
                if (receiver.stamp(NodeView.DEFAULT) instanceof ObjectStamp && !StampTool.isPointerNonNull(receiver)) {
                    ValueNode nonNullReceiver = this.createNullCheckedValue(receiver, invoke.asFixedNode(), tool);
                    parameters.set(0, (Object)nonNullReceiver);
                    receiver = nonNullReceiver;
                }
            }
            JavaType[] signature = callTarget.targetMethod().getSignature().toParameterTypes(callTarget.isStatic() ? null : callTarget.targetMethod().getDeclaringClass());
            LoweredCallTargetNode loweredCallTarget = null;
            OptionValues options = graph.getOptions();
            if (GraalOptions.InlineVTableStubs.getValue(options).booleanValue() && callTarget.invokeKind().isIndirect() && (GraalOptions.AlwaysInlineVTableStubs.getValue(options).booleanValue() || invoke.isPolymorphic()) && (hsMethod = (HotSpotResolvedJavaMethod)callTarget.targetMethod()).isInVirtualMethodTable(receiverType = invoke.getReceiverType())) {
                JavaKind wordKind = this.runtime.getTarget().wordJavaKind;
                ValueNode hub = this.createReadHub(graph, receiver, tool);
                ReadNode metaspaceMethod = this.createReadVirtualMethod(graph, hub, hsMethod, receiverType);
                int methodCompiledEntryOffset = this.runtime.getVMConfig().methodCompiledEntryOffset;
                AddressNode address = this.createOffsetAddress(graph, metaspaceMethod, methodCompiledEntryOffset);
                ReadNode compiledEntry = graph.add(new ReadNode(address, LocationIdentity.any(), StampFactory.forKind(wordKind), BarrierType.NONE, MemoryOrderMode.PLAIN));
                loweredCallTarget = graph.add(new HotSpotIndirectCallTargetNode(metaspaceMethod, (ValueNode)compiledEntry, parameters.toArray((A[])new ValueNode[parameters.size()]), callTarget.returnStamp(), signature, callTarget.targetMethod(), (CallingConvention.Type)HotSpotCallingConventionType.JavaCall, callTarget.invokeKind()));
                graph.addBeforeFixed(invoke.asFixedNode(), metaspaceMethod);
                graph.addAfterFixed(metaspaceMethod, compiledEntry);
            }
            if (loweredCallTarget == null) {
                loweredCallTarget = graph.add(new HotSpotDirectCallTargetNode(parameters.toArray((A[])new ValueNode[parameters.size()]), callTarget.returnStamp(), signature, callTarget.targetMethod(), (CallingConvention.Type)HotSpotCallingConventionType.JavaCall, callTarget.invokeKind()));
            }
            callTarget.replaceAndDelete(loweredCallTarget);
        }
    }

    private CompressEncoding getOopEncoding() {
        return this.runtime.getVMConfig().getOopEncoding();
    }

    @Override
    protected Stamp loadCompressedStamp(ObjectStamp stamp) {
        return HotSpotNarrowOopStamp.compressed(stamp, this.getOopEncoding());
    }

    @Override
    protected ValueNode newCompressionNode(CompressionNode.CompressionOp op, ValueNode value) {
        return new HotSpotCompressionNode(op, value, this.getOopEncoding());
    }

    @Override
    public ValueNode staticFieldBase(StructuredGraph graph, ResolvedJavaField f) {
        HotSpotResolvedJavaField field = (HotSpotResolvedJavaField)f;
        JavaConstant base = this.constantReflection.asJavaClass(field.getDeclaringClass());
        return ConstantNode.forConstant(base, this.metaAccess, graph);
    }

    @Override
    protected ValueNode createReadArrayComponentHub(StructuredGraph graph, ValueNode arrayHub, boolean isKnownObjectArray, FixedNode anchor) {
        AbstractBeginNode guard = null;
        if (!isKnownObjectArray) {
            guard = AbstractBeginNode.prevBegin(anchor);
        }
        AddressNode address = this.createOffsetAddress(graph, arrayHub, this.runtime.getVMConfig().arrayClassElementOffset);
        return graph.unique(new FloatingReadNode(address, HotSpotReplacementsUtil.OBJ_ARRAY_KLASS_ELEMENT_KLASS_LOCATION, null, KlassPointerStamp.klassNonNull(), guard));
    }

    private void lowerLoadMethodNode(LoadMethodNode loadMethodNode) {
        StructuredGraph graph = loadMethodNode.graph();
        HotSpotResolvedJavaMethod method = (HotSpotResolvedJavaMethod)loadMethodNode.getMethod();
        ReadNode metaspaceMethod = this.createReadVirtualMethod(graph, loadMethodNode.getHub(), method, loadMethodNode.getReceiverType());
        graph.replaceFixed(loadMethodNode, metaspaceMethod);
    }

    private static void lowerGetClassNode(GetClassNode getClass, LoweringTool tool, StructuredGraph graph) {
        StampProvider stampProvider = tool.getStampProvider();
        LoadHubNode hub = graph.unique(new LoadHubNode(stampProvider, getClass.getObject()));
        HubGetClassNode hubGetClass = graph.unique(new HubGetClassNode(tool.getMetaAccess(), hub));
        getClass.replaceAtUsagesAndDelete(hubGetClass);
        hub.lower(tool);
        hubGetClass.lower(tool);
    }

    private void lowerStoreHubNode(StoreHubNode storeHub, StructuredGraph graph) {
        WriteNode hub = this.createWriteHub(graph, storeHub.getObject(), storeHub.getValue());
        hub.setStateAfter(storeHub.stateAfter());
        graph.replaceFixed(storeHub, hub);
    }

    private void lowerOSRStartNode(OSRStartNode osrStart) {
        StructuredGraph graph = osrStart.graph();
        if (graph.getGuardsStage() == GraphState.GuardsStage.FIXED_DEOPTS) {
            StartNode newStart = graph.add(new StartNode());
            ParameterNode buffer = graph.addWithoutUnique(new ParameterNode(0, StampPair.createSingle(StampFactory.forKind(this.runtime.getTarget().wordJavaKind))));
            ForeignCallNode migrationEnd = graph.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotForeignCallsProviderImpl.OSR_MIGRATION_END, buffer));
            migrationEnd.setStateAfter(osrStart.stateAfter());
            newStart.setNext(migrationEnd);
            FixedNode next = osrStart.next();
            osrStart.setNext(null);
            migrationEnd.setNext(next);
            graph.setStart(newStart);
            int wordSize = this.target.wordSize;
            int localsOffset = (graph.method().getMaxLocals() - 1) * wordSize;
            for (OSRLocalNode osrLocal : graph.getNodes(OSRLocalNode.TYPE)) {
                int size = osrLocal.getStackKind().getSlotCount();
                int offset = localsOffset - (osrLocal.index() + size - 1) * wordSize;
                AddressNode address = this.createOffsetAddress(graph, buffer, offset);
                ReadNode load = graph.add(new ReadNode(address, LocationIdentity.any(), osrLocal.stamp(NodeView.DEFAULT), BarrierType.NONE, MemoryOrderMode.PLAIN));
                osrLocal.replaceAndDelete(load);
                graph.addBeforeFixed(migrationEnd, load);
            }
            int lockCount = osrStart.stateAfter().locksSize();
            int locksOffset = (graph.method().getMaxLocals() + lockCount * 2 - 1) * wordSize;
            for (OSRMonitorEnterNode osrMonitorEnter : graph.getNodes(OSRMonitorEnterNode.TYPE)) {
                MonitorIdNode monitorID = osrMonitorEnter.getMonitorId();
                OSRLockNode lock = (OSRLockNode)osrMonitorEnter.object();
                int index = lock.index();
                int offsetDisplacedHeader = locksOffset - (index * 2 + 1) * wordSize;
                int offsetLockObject = locksOffset - index * 2 * wordSize;
                AddressNode addressDisplacedHeader = this.createOffsetAddress(graph, buffer, offsetDisplacedHeader);
                ReadNode loadDisplacedHeader = graph.add(new ReadNode(addressDisplacedHeader, LocationIdentity.any(), lock.stamp(NodeView.DEFAULT), BarrierType.NONE, MemoryOrderMode.PLAIN));
                graph.addBeforeFixed(migrationEnd, loadDisplacedHeader);
                BeginLockScopeNode beginLockScope = graph.add(new BeginLockScopeNode(lock.getStackKind(), monitorID.getLockDepth()));
                graph.addBeforeFixed(migrationEnd, beginLockScope);
                AddressNode addressDisplacedMark = this.createOffsetAddress(graph, beginLockScope, this.runtime.getVMConfig().basicLockDisplacedHeaderOffset);
                WriteNode writeStackSlot = graph.add(new WriteNode(addressDisplacedMark, HotSpotReplacementsUtil.DISPLACED_MARK_WORD_LOCATION, loadDisplacedHeader, BarrierType.NONE, MemoryOrderMode.PLAIN));
                graph.addBeforeFixed(migrationEnd, writeStackSlot);
                AddressNode addressLockObject = this.createOffsetAddress(graph, buffer, offsetLockObject);
                ReadNode loadObject = graph.add(new ReadNode(addressLockObject, LocationIdentity.any(), lock.stamp(NodeView.DEFAULT), BarrierType.NONE, MemoryOrderMode.PLAIN));
                lock.replaceAndDelete(loadObject);
                graph.addBeforeFixed(migrationEnd, loadObject);
            }
            osrStart.replaceAtUsagesAndDelete(newStart);
        }
    }

    private void throwCachedException(BytecodeExceptionNode node) {
        if (Services.IS_IN_NATIVE_IMAGE) {
            throw new InternalError("Can't throw exception from SVM object");
        }
        Throwable exception = Exceptions.cachedExceptions.get((Object)node.getExceptionKind());
        assert (exception != null);
        StructuredGraph graph = node.graph();
        ConstantNode exceptionNode = ConstantNode.forConstant(this.constantReflection.forObject((Object)exception), this.metaAccess, graph);
        graph.replaceFixedWithFloating(node, exceptionNode);
    }

    private void lowerBytecodeExceptionNode(BytecodeExceptionNode node) {
        if (GraalOptions.OmitHotExceptionStacktrace.getValue(node.getOptions()).booleanValue()) {
            this.throwCachedException(node);
            return;
        }
        ForeignCallSignature signature = RuntimeCalls.runtimeCalls.get((Object)node.getExceptionKind());
        if (signature == null) {
            throw new GraalError("No runtime call available to lower BytecodeExceptionKind " + String.valueOf((Object)node.getExceptionKind()));
        }
        ForeignCallDescriptor descriptor = this.foreignCalls.getDescriptor(signature);
        StructuredGraph graph = node.graph();
        List<ValueNode> arguments = node.getArguments();
        if (node.getExceptionKind() == BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST) {
            assert (arguments.size() == 2) : Assertions.errorMessage(node, arguments);
            arguments = Arrays.asList((ValueNode)arguments.get(0), graph.addOrUniqueWithInputs(ClassGetHubNode.create((ValueNode)arguments.get(1), this.metaAccess, (ConstantReflectionProvider)this.constantReflection)));
        }
        assert (descriptor.getArgumentTypes().length == arguments.size()) : Assertions.errorMessage(node, descriptor, arguments);
        ForeignCallNode foreignCallNode = graph.add(new ForeignCallNode(descriptor, node.stamp(NodeView.DEFAULT), arguments));
        foreignCallNode.setValidateDeoptFrameStates(false);
        FrameState stateDuring = node.stateAfter();
        stateDuring = stateDuring.duplicateModified(graph, stateDuring.bci, FrameState.StackState.BeforePop, JavaKind.Object, null, null, null);
        foreignCallNode.setStateDuring(stateDuring);
        foreignCallNode.setStateAfter(node.stateAfter());
        graph.replaceFixedWithFixed(node, foreignCallNode);
    }

    protected void lowerDeadEnd(DeadEndNode deadEnd) {
        StructuredGraph graph = deadEnd.graph();
        VMErrorNode vmErrorNode = graph.add(new VMErrorNode(new CStringConstant("DeadEnd"), graph.unique(ConstantNode.forLong(0L))));
        DeoptimizeNode deopt = graph.add(new DeoptimizeNode(DeoptimizationAction.None, DeoptimizationReason.UnreachedCode));
        vmErrorNode.setNext(deopt);
        deadEnd.replaceAndDelete(vmErrorNode);
    }

    private ReadNode createReadVirtualMethod(StructuredGraph graph, ValueNode hub, HotSpotResolvedJavaMethod method, ResolvedJavaType receiverType) {
        return this.createReadVirtualMethod(graph, hub, method.vtableEntryOffset(receiverType));
    }

    private ReadNode createReadVirtualMethod(StructuredGraph graph, ValueNode hub, int vtableEntryOffset) {
        assert (vtableEntryOffset > 0) : Assertions.errorMessage(hub, vtableEntryOffset);
        MethodPointerStamp methodStamp = MethodPointerStamp.methodNonNull();
        AddressNode address = this.createOffsetAddress(graph, hub, vtableEntryOffset);
        ReadNode metaspaceMethod = graph.add(new ReadNode(address, LocationIdentity.any(), methodStamp, BarrierType.NONE, MemoryOrderMode.PLAIN));
        return metaspaceMethod;
    }

    @Override
    protected ValueNode createReadHub(StructuredGraph graph, ValueNode object, LoweringTool tool) {
        if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
            return graph.unique(new LoadHubNode(tool.getStampProvider(), object));
        }
        assert (!object.isConstant() || object.isNullConstant());
        KlassPointerStamp hubStamp = KlassPointerStamp.klassNonNull();
        if (this.runtime.getVMConfig().useCompressedClassPointers) {
            hubStamp = hubStamp.compressed(this.runtime.getVMConfig().getKlassEncoding());
        }
        AddressNode address = this.createOffsetAddress(graph, object, this.runtime.getVMConfig().hubOffset);
        LocationIdentity hubLocation = this.runtime.getVMConfig().useCompressedClassPointers ? HotSpotReplacementsUtil.COMPRESSED_HUB_LOCATION : HotSpotReplacementsUtil.HUB_LOCATION;
        FloatingReadNode memoryRead = graph.unique(new FloatingReadNode(address, hubLocation, null, (Stamp)hubStamp, null, BarrierType.NONE));
        if (this.runtime.getVMConfig().useCompressedClassPointers) {
            return HotSpotCompressionNode.uncompress(graph, memoryRead, this.runtime.getVMConfig().getKlassEncoding());
        }
        return memoryRead;
    }

    private WriteNode createWriteHub(StructuredGraph graph, ValueNode object, ValueNode value) {
        assert (!object.isConstant() || object.asConstant().isDefaultForKind());
        ValueNode writeValue = value;
        if (this.runtime.getVMConfig().useCompressedClassPointers) {
            writeValue = HotSpotCompressionNode.compress(graph, value, this.runtime.getVMConfig().getKlassEncoding());
        }
        AddressNode address = this.createOffsetAddress(graph, object, this.runtime.getVMConfig().hubOffset);
        return graph.add(new WriteNode(address, HotSpotReplacementsUtil.HUB_WRITE_LOCATION, writeValue, BarrierType.NONE, MemoryOrderMode.PLAIN));
    }

    @Override
    public int fieldOffset(ResolvedJavaField f) {
        return f.getOffset();
    }

    @Override
    public int arrayLengthOffset() {
        return this.runtime.getVMConfig().arrayOopDescLengthOffset();
    }

    @Override
    public ObjectCloneSnippets.Templates getObjectCloneSnippets() {
        return this.objectCloneSnippets;
    }

    @Override
    public ForeignCallSnippets.Templates getForeignCallSnippets() {
        return this.foreignCallSnippets;
    }

    private void lowerRegisterFinalizer(RegisterFinalizerNode n, LoweringTool tool) {
        this.registerFinalizerSnippets.lower(n, tool);
    }

    public static interface Extensions {
        public List<Extension> createExtensions();
    }

    public static interface Extension {
        public Class<? extends Node> getNodeType();

        public void lower(Node var1, LoweringTool var2);

        public void initialize(HotSpotProviders var1, OptionValues var2, GraalHotSpotVMConfig var3, HotSpotHostForeignCallsProvider var4, Iterable<DebugHandlersFactory> var5);
    }

    static final class Exceptions {
        protected static final EnumMap<BytecodeExceptionNode.BytecodeExceptionKind, RuntimeException> cachedExceptions = new EnumMap(BytecodeExceptionNode.BytecodeExceptionKind.class);

        Exceptions() {
        }

        private static RuntimeException clearStackTrace(RuntimeException ex) {
            ex.setStackTrace(new StackTraceElement[0]);
            return ex;
        }

        static {
            cachedExceptions.put(BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, Exceptions.clearStackTrace(new NullPointerException()));
            cachedExceptions.put(BytecodeExceptionNode.BytecodeExceptionKind.OUT_OF_BOUNDS, Exceptions.clearStackTrace(new ArrayIndexOutOfBoundsException()));
            cachedExceptions.put(BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, Exceptions.clearStackTrace(new ClassCastException()));
            cachedExceptions.put(BytecodeExceptionNode.BytecodeExceptionKind.ARRAY_STORE, Exceptions.clearStackTrace(new ArrayStoreException()));
            cachedExceptions.put(BytecodeExceptionNode.BytecodeExceptionKind.NEGATIVE_ARRAY_SIZE, Exceptions.clearStackTrace(new NegativeArraySizeException()));
            cachedExceptions.put(BytecodeExceptionNode.BytecodeExceptionKind.DIVISION_BY_ZERO, Exceptions.clearStackTrace(new ArithmeticException()));
            cachedExceptions.put(BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_ARGUMENT_IS_NOT_AN_ARRAY, Exceptions.clearStackTrace(new IllegalArgumentException(BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_ARGUMENT_IS_NOT_AN_ARRAY.getExceptionMessage())));
        }
    }

    public static final class RuntimeCalls {
        public static final EnumMap<BytecodeExceptionNode.BytecodeExceptionKind, ForeignCallSignature> runtimeCalls = new EnumMap(BytecodeExceptionNode.BytecodeExceptionKind.class);

        static {
            runtimeCalls.put(BytecodeExceptionNode.BytecodeExceptionKind.ARRAY_STORE, new ForeignCallSignature("createArrayStoreException", ArrayStoreException.class, Object.class));
            runtimeCalls.put(BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, new ForeignCallSignature("createClassCastException", ClassCastException.class, Object.class, KlassPointer.class));
            runtimeCalls.put(BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, new ForeignCallSignature("createNullPointerException", NullPointerException.class, new Class[0]));
            runtimeCalls.put(BytecodeExceptionNode.BytecodeExceptionKind.OUT_OF_BOUNDS, new ForeignCallSignature("createOutOfBoundsException", ArrayIndexOutOfBoundsException.class, Integer.TYPE, Integer.TYPE));
            runtimeCalls.put(BytecodeExceptionNode.BytecodeExceptionKind.NEGATIVE_ARRAY_SIZE, new ForeignCallSignature("createNegativeArraySizeException", NegativeArraySizeException.class, Integer.TYPE));
            runtimeCalls.put(BytecodeExceptionNode.BytecodeExceptionKind.DIVISION_BY_ZERO, new ForeignCallSignature("createDivisionByZeroException", ArithmeticException.class, new Class[0]));
            runtimeCalls.put(BytecodeExceptionNode.BytecodeExceptionKind.INTEGER_EXACT_OVERFLOW, new ForeignCallSignature("createIntegerExactOverflowException", ArithmeticException.class, new Class[0]));
            runtimeCalls.put(BytecodeExceptionNode.BytecodeExceptionKind.LONG_EXACT_OVERFLOW, new ForeignCallSignature("createLongExactOverflowException", ArithmeticException.class, new Class[0]));
            runtimeCalls.put(BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_ARGUMENT_IS_NOT_AN_ARRAY, new ForeignCallSignature("createIllegalArgumentExceptionArgumentIsNotAnArray", IllegalArgumentException.class, new Class[0]));
        }
    }
}

