/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.meta;

import java.util.function.BiConsumer;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.spi.ForeignCallSignature;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.HotSpotForeignCallLinkage;
import jdk.graal.compiler.hotspot.HotSpotForeignCallLinkageImpl;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntimeProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import jdk.graal.compiler.hotspot.meta.HotSpotForeignCallsProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.hotspot.stubs.ForeignCallStub;
import jdk.graal.compiler.hotspot.stubs.InvokeJavaMethodStub;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.word.Word;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.word.LocationIdentity;

public abstract class HotSpotForeignCallsProviderImpl
implements HotSpotForeignCallsProvider {
    public static final LocationIdentity[] NO_LOCATIONS = new LocationIdentity[0];
    public static final HotSpotForeignCallDescriptor OSR_MIGRATION_END = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, NO_LOCATIONS, "OSR_migration_end", Void.TYPE, Long.TYPE);
    public static final HotSpotForeignCallDescriptor IDENTITY_HASHCODE = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, HotSpotReplacementsUtil.MARK_WORD_LOCATION, "identity_hashcode", Integer.TYPE, Object.class);
    public static final HotSpotForeignCallDescriptor VERIFY_OOP = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, NO_LOCATIONS, "verify_oop", Object.class, Object.class);
    public static final HotSpotForeignCallDescriptor LOAD_AND_CLEAR_EXCEPTION = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, LocationIdentity.any(), "load_and_clear_exception", Object.class, Word.class);
    public static final HotSpotForeignCallDescriptor TEST_DEOPTIMIZE_CALL_INT = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, LocationIdentity.any(), "test_deoptimize_call_int", Integer.TYPE, Integer.TYPE);
    protected final HotSpotJVMCIRuntime jvmciRuntime;
    protected final HotSpotGraalRuntimeProvider runtime;
    protected final EconomicMap<ForeignCallSignature, HotSpotForeignCallLinkage> foreignCalls = EconomicMap.create();
    protected final EconomicMap<ForeignCallSignature, HotSpotForeignCallDescriptor> signatureMap = EconomicMap.create();
    protected final MetaAccessProvider metaAccess;
    protected final CodeCacheProvider codeCache;
    protected final WordTypes wordTypes;
    public static final boolean PREPEND_THREAD = true;
    public static final boolean DONT_PREPEND_THREAD = false;

    public HotSpotForeignCallsProviderImpl(HotSpotJVMCIRuntime jvmciRuntime, HotSpotGraalRuntimeProvider runtime, MetaAccessProvider metaAccess, CodeCacheProvider codeCache, WordTypes wordTypes) {
        this.jvmciRuntime = jvmciRuntime;
        this.runtime = runtime;
        this.metaAccess = metaAccess;
        this.codeCache = codeCache;
        this.wordTypes = wordTypes;
    }

    public HotSpotGraalRuntimeProvider getRuntime() {
        return this.runtime;
    }

    public HotSpotJVMCIRuntime getJVMCIRuntime() {
        return this.jvmciRuntime;
    }

    public void register(ForeignCallSignature sig) {
        if (!this.foreignCalls.containsKey((Object)sig)) {
            this.foreignCalls.put((Object)sig, null);
        }
    }

    public HotSpotForeignCallLinkage register(HotSpotForeignCallLinkage linkage) {
        ForeignCallSignature key = linkage.getDescriptor().getSignature();
        HotSpotForeignCallLinkage existing = (HotSpotForeignCallLinkage)this.foreignCalls.put((Object)key, (Object)linkage);
        GraalError.guarantee(existing == null, "already registered linkage for %s: %s", (Object)key, (Object)existing);
        return linkage;
    }

    public HotSpotForeignCallLinkage registerStubCall(HotSpotForeignCallDescriptor descriptor, HotSpotForeignCallLinkage.RegisterEffect effect) {
        return this.register(HotSpotForeignCallLinkageImpl.create(this.metaAccess, this.codeCache, this.wordTypes, this, descriptor, 0L, effect, (CallingConvention.Type)HotSpotCallingConventionType.JavaCall, (CallingConvention.Type)HotSpotCallingConventionType.JavaCallee));
    }

    public HotSpotForeignCallLinkage registerStubCall(ForeignCallSignature signature, HotSpotForeignCallDescriptor.Transition transition, ForeignCallDescriptor.CallSideEffect callSideEffect, HotSpotForeignCallLinkage.RegisterEffect effect, LocationIdentity ... killedLocations) {
        HotSpotForeignCallDescriptor descriptor = new HotSpotForeignCallDescriptor(signature, transition, callSideEffect, killedLocations);
        this.signatureMap.put((Object)signature, (Object)descriptor);
        return this.registerStubCall(descriptor, effect);
    }

    public HotSpotForeignCallLinkage registerForeignCall(HotSpotForeignCallDescriptor descriptor, long address, CallingConvention.Type outgoingCcType) {
        if (address == 0L) {
            throw new IllegalArgumentException("address must be non-zero");
        }
        Class<?> resultType = descriptor.getResultType();
        GraalError.guarantee(descriptor.getTransition() != HotSpotForeignCallDescriptor.Transition.SAFEPOINT || resultType.isPrimitive() || Word.class.isAssignableFrom(resultType), "non-leaf foreign calls must return objects in thread local storage: %s", (Object)descriptor);
        GraalError.guarantee(outgoingCcType.equals((Object)HotSpotCallingConventionType.NativeCall), "only NativeCall");
        return this.register(HotSpotForeignCallLinkageImpl.create(this.metaAccess, this.codeCache, this.wordTypes, this, descriptor, address, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, outgoingCcType, null));
    }

    public void linkForeignCall(OptionValues options, HotSpotProviders providers, HotSpotForeignCallDescriptor descriptor, long address, boolean prependThread) {
        if (address == 0L) {
            throw new IllegalArgumentException("Can't link foreign call with zero address");
        }
        ForeignCallStub stub = new ForeignCallStub(options, this.jvmciRuntime, providers, address, descriptor, prependThread);
        HotSpotForeignCallLinkage linkage = stub.getLinkage();
        HotSpotForeignCallLinkage targetLinkage = stub.getTargetLinkage();
        linkage.setCompiledStub(stub);
        this.register(linkage);
        this.register(targetLinkage);
    }

    public void linkStackOnlyForeignCall(OptionValues options, HotSpotProviders providers, HotSpotForeignCallDescriptor descriptor, long address, boolean prependThread) {
        if (address == 0L) {
            throw new IllegalArgumentException("Can't link foreign call with zero address");
        }
        ForeignCallStub stub = new ForeignCallStub(options, this.jvmciRuntime, providers, address, descriptor, prependThread, HotSpotForeignCallLinkage.RegisterEffect.KILLS_NO_REGISTERS);
        HotSpotForeignCallLinkage linkage = stub.getLinkage();
        HotSpotForeignCallLinkage targetLinkage = stub.getTargetLinkage();
        linkage.setCompiledStub(stub);
        this.register(linkage);
        this.register(targetLinkage);
    }

    public void invokeJavaMethodStub(OptionValues options, HotSpotProviders providers, HotSpotForeignCallDescriptor descriptor, long address, ResolvedJavaMethod staticMethod) {
        if (address == 0L) {
            throw new IllegalArgumentException("Can't link foreign call with zero address");
        }
        InvokeJavaMethodStub stub = new InvokeJavaMethodStub(options, this.jvmciRuntime, providers, address, descriptor, staticMethod);
        HotSpotForeignCallLinkage linkage = stub.getLinkage();
        HotSpotForeignCallLinkage targetLinkage = stub.getTargetLinkage();
        linkage.setCompiledStub(stub);
        this.register(linkage);
        HotSpotForeignCallLinkage registeredTargetLinkage = (HotSpotForeignCallLinkage)this.foreignCalls.get((Object)targetLinkage.getDescriptor().getSignature());
        GraalError.guarantee(registeredTargetLinkage != null, "%s should already be registered", (Object)targetLinkage);
    }

    @Override
    public HotSpotForeignCallLinkage lookupForeignCall(ForeignCallSignature signature) {
        GraalError.guarantee(this.foreignCalls != null, "%s", (Object)signature);
        HotSpotForeignCallLinkage callTarget = (HotSpotForeignCallLinkage)this.foreignCalls.get((Object)signature);
        if (callTarget == null) {
            throw GraalError.shouldNotReachHere("Missing implementation for runtime call: " + String.valueOf(signature));
        }
        callTarget.finalizeAddress(this.runtime.getHostBackend());
        return callTarget;
    }

    @Override
    public HotSpotForeignCallLinkage lookupForeignCall(ForeignCallDescriptor descriptor) {
        return this.lookupForeignCall(descriptor.getSignature());
    }

    @Override
    public HotSpotForeignCallDescriptor getDescriptor(ForeignCallSignature signature) {
        HotSpotForeignCallDescriptor descriptor = (HotSpotForeignCallDescriptor)this.signatureMap.get((Object)signature);
        GraalError.guarantee(descriptor != null, "%s", (Object)signature);
        return descriptor;
    }

    HotSpotForeignCallDescriptor createDescriptor(ForeignCallSignature signature, HotSpotForeignCallDescriptor.Transition transition, ForeignCallDescriptor.CallSideEffect callSideEffect, LocationIdentity ... killLocations) {
        GraalError.guarantee(!this.signatureMap.containsKey((Object)signature), "%s", (Object)signature);
        HotSpotForeignCallDescriptor descriptor = new HotSpotForeignCallDescriptor(signature, transition, callSideEffect, killLocations);
        this.signatureMap.put((Object)signature, (Object)descriptor);
        return descriptor;
    }

    public LIRKind getValueKind(JavaKind javaKind) {
        return LIRKind.fromJavaKind(this.codeCache.getTarget().arch, javaKind);
    }

    public void forEachForeignCall(BiConsumer<ForeignCallSignature, HotSpotForeignCallLinkage> action) {
        MapCursor cursor = this.foreignCalls.getEntries();
        while (cursor.advance()) {
            action.accept((ForeignCallSignature)cursor.getKey(), (HotSpotForeignCallLinkage)cursor.getValue());
        }
    }
}

