/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.meta;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntimeProvider;
import jdk.graal.compiler.hotspot.HotSpotGraalServices;
import jdk.graal.compiler.hotspot.meta.UnimplementedGraalIntrinsics;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.tiers.CompilerConfiguration;
import jdk.graal.compiler.replacements.nodes.MacroInvokable;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.VMIntrinsicMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.Pair;

final class HotSpotInvocationPlugins
extends InvocationPlugins {
    private final HotSpotGraalRuntimeProvider graalRuntime;
    private final GraalHotSpotVMConfig config;
    private final UnimplementedGraalIntrinsics unimplementedIntrinsics;
    private EconomicMap<String, Integer> missingIntrinsicMetrics;
    private final List<Predicate<ResolvedJavaType>> intrinsificationPredicates = new ArrayList<Predicate<ResolvedJavaType>>();
    private final EconomicMap<String, EconomicSet<MethodKey>> disabledIntrinsics = EconomicMap.create();

    HotSpotInvocationPlugins(HotSpotGraalRuntimeProvider graalRuntime, GraalHotSpotVMConfig config, CompilerConfiguration compilerConfiguration, OptionValues options) {
        this.graalRuntime = graalRuntime;
        this.config = config;
        this.unimplementedIntrinsics = InvocationPlugins.Options.WarnMissingIntrinsic.getValue(options) != false ? new UnimplementedGraalIntrinsics() : null;
        this.missingIntrinsicMetrics = null;
        for (VMIntrinsicMethod intrinsic : config.getStore().getIntrinsics()) {
            if (HotSpotGraalServices.isIntrinsicAvailable(intrinsic)) continue;
            String className = "L" + intrinsic.declaringClass + ";";
            EconomicSet methods = (EconomicSet)this.disabledIntrinsics.get((Object)className);
            if (methods == null) {
                methods = EconomicSet.create();
                this.disabledIntrinsics.put((Object)className, (Object)methods);
            }
            MethodKey m = new MethodKey(intrinsic.name, intrinsic.descriptor);
            methods.add((Object)m);
        }
        this.registerIntrinsificationPredicate(HotSpotJVMCIRuntime.runtime().getIntrinsificationTrustPredicate(new Class[]{compilerConfiguration.getClass()}));
    }

    @Override
    protected void register(Type declaringClass, InvocationPlugin plugin, boolean allowOverwrite) {
        if (!this.config.usePopCountInstruction && "bitCount".equals(plugin.name)) {
            GraalError.guarantee(declaringClass.equals(Integer.class) || declaringClass.equals(Long.class), declaringClass.getTypeName());
            return;
        }
        if (!this.config.useUnalignedAccesses && plugin.name.endsWith("Unaligned") && declaringClass.getTypeName().equals("jdk.internal.misc.Unsafe")) {
            return;
        }
        super.register(declaringClass, plugin, allowOverwrite);
    }

    @Override
    public void checkNewNodes(GraphBuilderContext b, InvocationPlugin plugin, NodeIterable<Node> newNodes) {
        for (Node node : newNodes) {
            if (!(node instanceof MacroInvokable)) continue;
            GraalError.guarantee(plugin.inlineOnly(), "plugin that creates a %s (%s) must return true for inlineOnly(): %s", (Object)MacroInvokable.class.getSimpleName(), (Object)node, (Object)plugin);
        }
        super.checkNewNodes(b, plugin, newNodes);
    }

    @Override
    public void registerIntrinsificationPredicate(Predicate<ResolvedJavaType> predicate) {
        this.intrinsificationPredicates.add(predicate);
    }

    @Override
    public boolean canBeIntrinsified(ResolvedJavaType declaringClass) {
        boolean ok = false;
        for (Predicate<ResolvedJavaType> p : this.intrinsificationPredicates) {
            ok |= p.test(declaringClass);
        }
        if (!ok) {
            if (this.graalRuntime.isBootstrapping()) {
                throw GraalError.shouldNotReachHere("Class declaring a method for which a Graal intrinsic is available should be trusted for intrinsification: " + declaringClass.toJavaName());
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public InvocationPlugin lookupInvocation(ResolvedJavaMethod method, boolean allowDecorators, boolean allowDisable, OptionValues options) {
        InvocationPlugin invocationPlugin = super.lookupInvocation(method, allowDecorators, allowDisable, options);
        if (invocationPlugin == null) return invocationPlugin;
        if (!allowDisable) return invocationPlugin;
        if (this.disabledIntrinsics.isEmpty()) return invocationPlugin;
        EconomicSet disabledIntrinsicsSet = (EconomicSet)this.disabledIntrinsics.get((Object)method.getDeclaringClass().getName());
        if (disabledIntrinsicsSet == null) return invocationPlugin;
        if (!disabledIntrinsicsSet.contains((Object)new MethodKey(method.getName(), method.getSignature().toMethodDescriptor()))) return invocationPlugin;
        if (!invocationPlugin.canBeDisabled()) {
            if (!this.shouldLogDisabledIntrinsics(options)) return invocationPlugin;
            TTY.println("[Warning] Intrinsic for %s cannot be disabled.", method.format("%H.%n(%p)"));
            return invocationPlugin;
        }
        if (invocationPlugin.isGraalOnly()) {
            if (!this.shouldLogDisabledIntrinsics(options)) return invocationPlugin;
            TTY.println("[Warning] Intrinsic for %s is only implemented in Graal and cannot be disabled via HotSpot flags. Use -Djdk.graal.DisableIntrinsics= instead.", method.format("%H.%n(%p)"));
            return invocationPlugin;
        }
        if (!this.shouldLogDisabledIntrinsics(options)) return null;
        TTY.println("[Warning] Intrinsic for %s is disabled by HotSpot runtime.", method.format("%H.%n(%p)"));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyNoPlugin(ResolvedJavaMethod targetMethod, OptionValues options) {
        String method;
        if (this.unimplementedIntrinsics != null && this.unimplementedIntrinsics.isMissing(method = String.format("%s.%s%s", targetMethod.getDeclaringClass().toJavaName().replace('.', '/'), targetMethod.getName(), targetMethod.getSignature().toMethodDescriptor()))) {
            HotSpotInvocationPlugins hotSpotInvocationPlugins = this;
            synchronized (hotSpotInvocationPlugins) {
                if (this.missingIntrinsicMetrics == null) {
                    this.missingIntrinsicMetrics = EconomicMap.create();
                    try {
                        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                            if (this.missingIntrinsicMetrics.size() > 0) {
                                TTY.println("[Warning] Missing intrinsics found: %d", this.missingIntrinsicMetrics.size());
                                ArrayList<Pair> data = new ArrayList<Pair>();
                                MapCursor cursor = this.missingIntrinsicMetrics.getEntries();
                                while (cursor.advance()) {
                                    data.add(Pair.create((Object)((String)cursor.getKey()), (Object)((Integer)cursor.getValue())));
                                }
                                data.stream().sorted(Comparator.comparing(Pair::getRight, Comparator.reverseOrder())).forEach(pair -> TTY.println("        - %d occurrences during parsing: %s", pair.getRight(), pair.getLeft()));
                            }
                        }));
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                if (this.missingIntrinsicMetrics.containsKey((Object)method)) {
                    this.missingIntrinsicMetrics.put((Object)method, (Object)((Integer)this.missingIntrinsicMetrics.get((Object)method) + 1));
                } else {
                    TTY.println("[Warning] Missing intrinsic %s found during parsing.", method);
                    this.missingIntrinsicMetrics.put((Object)method, (Object)1);
                }
            }
        }
    }

    record MethodKey(String name, String descriptor) {
    }
}

