/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.nodes;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.VirtualStackSlot;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.word.Word;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.meta.Value;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class AllocaNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<AllocaNode> TYPE = NodeClass.create(AllocaNode.class);
    private final int sizeInBytes;
    private final int alignmentInBytes;

    public AllocaNode(@Node.InjectedNodeParameter WordTypes wordTypes, int sizeInBytes, int alignmentInBytes) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forKind(wordTypes.getWordKind()));
        assert (sizeInBytes > 0 && alignmentInBytes > 0) : Assertions.errorMessage(sizeInBytes, alignmentInBytes);
        this.sizeInBytes = sizeInBytes;
        this.alignmentInBytes = alignmentInBytes;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        VirtualStackSlot array = gen.getLIRGeneratorTool().allocateStackMemory(this.sizeInBytes, this.alignmentInBytes);
        Variable result = gen.getLIRGeneratorTool().emitAddress(array);
        gen.setResult(this, (Value)result);
    }

    @Node.NodeIntrinsic
    public static native Word alloca(@Node.ConstantNodeParameter int var0, @Node.ConstantNodeParameter int var1);
}

