/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.nodes;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.hotspot.HotSpotLIRGenerator;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ControlSinkNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;

@NodeInfo(shortName="DeoptCaller", nameTemplate="DeoptCaller {p#reason/s}", cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8)
public final class DeoptimizeCallerNode
extends ControlSinkNode
implements LIRLowerable {
    public static final NodeClass<DeoptimizeCallerNode> TYPE = NodeClass.create(DeoptimizeCallerNode.class);
    protected final DeoptimizationAction action;
    protected final DeoptimizationReason reason;

    public DeoptimizeCallerNode(DeoptimizationAction action, DeoptimizationReason reason) {
        super((NodeClass<? extends ControlSinkNode>)TYPE, StampFactory.forVoid());
        this.action = action;
        this.reason = reason;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        ((HotSpotLIRGenerator)gen.getLIRGeneratorTool()).emitDeoptimizeCaller(this.action, this.reason);
    }

    @Node.NodeIntrinsic
    public static native void deopt(@Node.ConstantNodeParameter DeoptimizationAction var0, @Node.ConstantNodeParameter DeoptimizationReason var1);
}

