/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.nodes;

import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.hotspot.nodes.CurrentJavaThreadNode;
import jdk.graal.compiler.hotspot.nodes.HotSpotLoadReservedReferenceNode;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractStateSplit;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.JavaWriteNode;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class HotSpotStoreReservedReferenceNode
extends AbstractStateSplit
implements Lowerable,
SingleMemoryKill {
    public static final NodeClass<HotSpotStoreReservedReferenceNode> TYPE = NodeClass.create(HotSpotStoreReservedReferenceNode.class);
    private final WordTypes wordTypes;
    @Node.Input
    protected ValueNode value;
    private final int jvmciReservedReference0Offset;

    public HotSpotStoreReservedReferenceNode(WordTypes wordTypes, ValueNode value, int jvmciReservedReference0Offset) {
        super((NodeClass<? extends AbstractStateSplit>)TYPE, StampFactory.forVoid());
        this.value = value;
        this.wordTypes = wordTypes;
        this.jvmciReservedReference0Offset = jvmciReservedReference0Offset;
    }

    @Override
    public void lower(LoweringTool tool) {
        CurrentJavaThreadNode thread = this.graph().unique(new CurrentJavaThreadNode(this.wordTypes));
        AddressNode address = this.graph().unique(new OffsetAddressNode(thread, this.graph().unique(ConstantNode.forLong(this.jvmciReservedReference0Offset))));
        JavaWriteNode write = this.graph().add(new JavaWriteNode(JavaKind.Object, address, HotSpotLoadReservedReferenceNode.JVMCI_RESERVED_REFERENCE, this.value, BarrierType.NONE, false));
        write.setStateAfter(this.stateAfter());
        this.graph().replaceFixedWithFixed(this, write);
        tool.getLowerer().lower(write, tool);
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return HotSpotLoadReservedReferenceNode.JVMCI_RESERVED_REFERENCE;
    }
}

