/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.phases;

import java.util.BitSet;
import java.util.Optional;
import jdk.graal.compiler.core.common.PermanentBailoutException;
import jdk.graal.compiler.core.common.cfg.Loop;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.CounterKey;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.hotspot.HotSpotGraalServices;
import jdk.graal.compiler.loop.phases.LoopTransformations;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.EntryMarkerNode;
import jdk.graal.compiler.nodes.EntryProxyNode;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.StartNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.extended.OSRLocalNode;
import jdk.graal.compiler.nodes.extended.OSRLockNode;
import jdk.graal.compiler.nodes.extended.OSRMonitorEnterNode;
import jdk.graal.compiler.nodes.extended.OSRStartNode;
import jdk.graal.compiler.nodes.java.AccessMonitorNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.java.MonitorEnterNode;
import jdk.graal.compiler.nodes.java.MonitorExitNode;
import jdk.graal.compiler.nodes.java.MonitorIdNode;
import jdk.graal.compiler.nodes.loop.LoopEx;
import jdk.graal.compiler.nodes.loop.LoopsData;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.DeadCodeEliminationPhase;
import jdk.graal.compiler.serviceprovider.SpeculationReasonGroup;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;

public class OnStackReplacementPhase
extends BasePhase<CoreProviders> {
    private static final CounterKey OsrWithLocksCount = DebugContext.counter("OSRWithLocks");
    private static final SpeculationReasonGroup OSR_LOCAL_SPECULATIONS = new SpeculationReasonGroup("OSRLocal", Integer.TYPE, Stamp.class, Integer.TYPE);

    private static boolean supportOSRWithLocks(OptionValues options) {
        return Options.SupportOSRWithLocks.getValue(options);
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders providers) {
        OSRStartNode osrStart;
        EntryMarkerNode osr;
        DebugContext debug = graph.getDebug();
        if (graph.getEntryBCI() == -1) {
            assert (graph.getNodes(EntryMarkerNode.TYPE).isEmpty());
            return;
        }
        debug.dump(4, (Object)graph, "OnStackReplacement initial at bci %d", graph.getEntryBCI());
        int maxIterations = -1;
        int iterations = 0;
        EntryMarkerNode originalOSRNode = OnStackReplacementPhase.getEntryMarker(graph);
        LoopBeginNode originalOSRLoop = OnStackReplacementPhase.osrLoop(originalOSRNode, providers);
        boolean currentOSRWithLocks = OnStackReplacementPhase.osrWithLocks(originalOSRNode);
        if (originalOSRLoop == null) {
            throw new PermanentBailoutException("OSR compilation without OSR entry loop.");
        }
        if (!OnStackReplacementPhase.supportOSRWithLocks(graph.getOptions()) && currentOSRWithLocks) {
            throw new PermanentBailoutException("OSR with locks disabled.");
        }
        while (true) {
            osr = OnStackReplacementPhase.getEntryMarker(graph);
            LoopsData loops = providers.getLoopsDataProvider().getLoopsData(graph);
            Loop<HIRBlock> l = loops.getCFG().getNodeToBlock().get(osr).getLoop();
            if (l == null) break;
            ++iterations;
            if (maxIterations == -1) {
                maxIterations = l.getDepth();
            } else if (iterations > maxIterations) {
                throw GraalError.shouldNotReachHere(iterations + " " + maxIterations);
            }
            l = l.getOutmostLoop();
            LoopEx loop = loops.loop(l);
            loop.loopBegin().markOsrLoop();
            LoopTransformations.peel(loop);
            osr.prepareDelete();
            GraphUtil.removeFixedWithUnusedInputs(osr);
            debug.dump(4, graph, "OnStackReplacement loop peeling result");
        }
        StartNode start = graph.start();
        FrameState osrState = osr.stateAfter();
        try (DebugCloseable context = osr.withNodeSourcePosition();){
            osr.setStateAfter(null);
            osrStart = graph.add(new OSRStartNode());
            FixedNode next = osr.next();
            osr.setNext(null);
            osrStart.setNext(next);
            graph.setStart(osrStart);
            osrStart.setStateAfter(osrState);
            debug.dump(4, graph, "OnStackReplacement after setting OSR start");
            int localsSize = osrState.localsSize();
            int locksSize = osrState.locksSize();
            ResolvedJavaMethod osrStateMethod = osrState.getMethod();
            GraalError.guarantee(localsSize == osrStateMethod.getMaxLocals(), "%s@%d: locals size %d != %d", (Object)osrStateMethod, (Object)osrState.bci, (Object)localsSize, (Object)osrStateMethod.getMaxLocals());
            BitSet oopMap = OnStackReplacementPhase.getOopMapAt(osrStateMethod, osrState.bci);
            for (int i = 0; i < localsSize + locksSize; ++i) {
                ValueNode value = i >= localsSize ? osrState.lockAt(i - localsSize) : osrState.localAt(i);
                if (value instanceof EntryProxyNode) {
                    EntryProxyNode proxy = (EntryProxyNode)value;
                    proxy.value().inferStamp();
                    Stamp narrowedStamp = proxy.value().stamp(NodeView.DEFAULT);
                    Stamp unrestrictedStamp = proxy.stamp(NodeView.DEFAULT).unrestricted();
                    ValueNode osrLocal = i >= localsSize ? (ValueNode)graph.addOrUnique(new OSRLockNode(i - localsSize, unrestrictedStamp)) : OnStackReplacementPhase.initLocal(graph, unrestrictedStamp, oopMap, i);
                    SpeculationLog.SpeculationReason reason = OSR_LOCAL_SPECULATIONS.createSpeculationReason(osrState.bci, narrowedStamp, i);
                    if (graph.getSpeculationLog().maySpeculate(reason) && osrLocal instanceof OSRLocalNode && value.getStackKind().equals((Object)JavaKind.Object) && !narrowedStamp.isUnrestricted()) {
                        osrLocal = OnStackReplacementPhase.narrowOsrLocal(graph, narrowedStamp, osrLocal, reason, osrStart, proxy, osrState);
                    }
                    proxy.replaceAndDelete(osrLocal);
                    continue;
                }
                assert (value == null || value instanceof OSRLocalNode) : Assertions.errorMessage(value);
            }
            osr.replaceAtUsages((Node)osrStart, InputType.Guard);
            osr.replaceAtUsages((Node)osrStart, InputType.Anchor);
        }
        debug.dump(4, graph, "OnStackReplacement after replacing entry proxies");
        GraphUtil.killCFG(start);
        debug.dump(4, graph, "OnStackReplacement result");
        new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Required).apply(graph);
        if (currentOSRWithLocks) {
            OsrWithLocksCount.increment(debug);
            context = osrStart.withNodeSourcePosition();
            try {
                for (int i = osrState.monitorIdCount() - 1; i >= 0; --i) {
                    MonitorIdNode id = osrState.monitorIdAt(i);
                    ValueNode lockedObject = osrState.lockAt(i);
                    OSRMonitorEnterNode osrMonitorEnter = graph.add(new OSRMonitorEnterNode(lockedObject, id));
                    osrMonitorEnter.setStateAfter(osrStart.stateAfter());
                    for (Node usage : id.usages()) {
                        if (!(usage instanceof AccessMonitorNode)) continue;
                        AccessMonitorNode access = (AccessMonitorNode)usage;
                        access.setObject(lockedObject);
                    }
                    FixedNode oldNext = osrStart.next();
                    oldNext.replaceAtPredecessor(null);
                    osrMonitorEnter.setNext(oldNext);
                    osrStart.setNext(osrMonitorEnter);
                }
            }
            finally {
                if (context != null) {
                    context.close();
                }
            }
            debug.dump(4, graph, "After inserting OSR monitor enters");
            for (MonitorExitNode exit : graph.getNodes(MonitorExitNode.TYPE)) {
                MonitorIdNode id = exit.getMonitorId();
                if (id.usages().filter(MonitorEnterNode.class).count() == 1) continue;
                throw new PermanentBailoutException("Unbalanced monitor enter-exit in OSR compilation with locks. Object is locked before the loop but released inside the loop.");
            }
        }
        debug.dump(4, graph, "OnStackReplacement result");
        new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Required).apply(graph);
        assert (graph.getNodes(ParameterNode.TYPE).count() == 0) : "OSR Compilation contains references to parameters.";
    }

    private static ValueNode narrowOsrLocal(StructuredGraph graph, Stamp narrowedStamp, ValueNode osrLocal, SpeculationLog.SpeculationReason reason, OSRStartNode osrStart, EntryProxyNode proxy, FrameState osrState) {
        LogicNode check = graph.addOrUniqueWithInputs(InstanceOfNode.createHelper((ObjectStamp)narrowedStamp, osrLocal, null, null));
        SpeculationLog.Speculation constant = graph.getSpeculationLog().speculate(reason);
        FixedGuardNode guard = graph.add(new FixedGuardNode(check, DeoptimizationReason.OptimizedTypeCheckViolated, DeoptimizationAction.InvalidateRecompile, constant, false));
        graph.addAfterFixed(osrStart, guard);
        proxy.replaceAtMatchingUsages(osrLocal, n -> n == osrState);
        return graph.addOrUnique(new PiNode(osrLocal, narrowedStamp, guard));
    }

    private static ValueNode initLocal(StructuredGraph graph, Stamp unrestrictedStamp, BitSet oopMap, int i) {
        if (unrestrictedStamp.isObjectStamp() && oopMap != null && !oopMap.get(i)) {
            return ConstantNode.defaultForKind(JavaKind.Object, graph);
        }
        return graph.addOrUnique(new OSRLocalNode(i, unrestrictedStamp));
    }

    private static BitSet getOopMapAt(ResolvedJavaMethod method, int bci) {
        if (!HotSpotGraalServices.hasGetOopMapAt()) {
            return null;
        }
        return HotSpotGraalServices.getOopMapAt(method, bci);
    }

    private static EntryMarkerNode getEntryMarker(StructuredGraph graph) {
        NodeIterable<EntryMarkerNode> osrNodes = graph.getNodes(EntryMarkerNode.TYPE);
        EntryMarkerNode osr = osrNodes.first();
        if (osr == null) {
            throw new GraalError("No OnStackReplacementNode generated");
        }
        if (osrNodes.count() > 1) {
            throw new GraalError("Multiple OnStackReplacementNodes generated");
        }
        if (osr.stateAfter().stackSize() != 0) {
            throw new PermanentBailoutException("OSR with stack entries not supported: %s", osr.stateAfter().toString(Verbosity.Debugger));
        }
        return osr;
    }

    private static LoopBeginNode osrLoop(EntryMarkerNode osr, CoreProviders providers) {
        LoopsData loops = providers.getLoopsDataProvider().getLoopsData(osr.graph());
        Loop<HIRBlock> l = loops.getCFG().getNodeToBlock().get(osr).getLoop();
        if (l == null) {
            return null;
        }
        return (LoopBeginNode)l.getHeader().getBeginNode();
    }

    private static boolean osrWithLocks(EntryMarkerNode osr) {
        return osr.stateAfter().locksSize() != 0;
    }

    @Override
    public float codeSizeIncrease() {
        return 5.0f;
    }

    public static class Options {
        public static final OptionKey<Boolean> DeoptAfterOSR = new OptionKey<Boolean>(true);
        public static final OptionKey<Boolean> SupportOSRWithLocks = new OptionKey<Boolean>(true);
    }
}

