/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.replacements;

import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.nodes.StubForeignCallNode;
import jdk.graal.compiler.hotspot.nodes.StubStartNode;
import jdk.graal.compiler.hotspot.stubs.StubUtil;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.replacements.nodes.AssertionNode;
import jdk.graal.compiler.replacements.nodes.CStringConstant;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.Constant;
import org.graalvm.word.LocationIdentity;

public class AssertionSnippets
implements Snippets {
    @Snippet
    public static void assertion(boolean condition, Word message, long l1, long l2) {
        if (GraalDirectives.injectBranchProbability(1.0E-4, !condition)) {
            AssertionSnippets.vmMessageC(StubUtil.VM_MESSAGE_C, true, message, l1, l2, 0L);
        }
    }

    @Snippet
    public static void stubAssertion(boolean condition, Word message, long l1, long l2) {
        if (GraalDirectives.injectBranchProbability(1.0E-4, !condition)) {
            AssertionSnippets.vmMessageStub(StubUtil.VM_MESSAGE_C, true, message, l1, l2, 0L);
        }
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    static native void vmMessageC(@Node.ConstantNodeParameter ForeignCallDescriptor var0, boolean var1, Word var2, long var3, long var5, long var7);

    @Node.NodeIntrinsic(value=StubForeignCallNode.class)
    static native void vmMessageStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, boolean var1, Word var2, long var3, long var5, long var7);

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo assertion;
        private final SnippetTemplate.SnippetInfo stubAssertion;

        public Templates(OptionValues options, HotSpotProviders providers) {
            super(options, providers);
            this.assertion = this.snippet((Providers)providers, AssertionSnippets.class, "assertion", new LocationIdentity[0]);
            this.stubAssertion = this.snippet((Providers)providers, AssertionSnippets.class, "stubAssertion", new LocationIdentity[0]);
        }

        public void lower(AssertionNode assertionNode, LoweringTool tool) {
            StructuredGraph graph = assertionNode.graph();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(graph.start() instanceof StubStartNode ? this.stubAssertion : this.assertion, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("condition", assertionNode.condition());
            args.add("message", graph.unique(new ConstantNode((Constant)new CStringConstant("failed runtime assertion in snippet/stub: " + assertionNode.message() + " (" + String.valueOf(graph.method()) + ")"), StampFactory.pointer())));
            args.add("l1", assertionNode.getL1());
            args.add("l2", assertionNode.getL2());
            this.template(tool, assertionNode, args).instantiate(tool.getMetaAccess(), assertionNode, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

