/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.replacements;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.DeoptimizingNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.AbstractMemoryCheckpoint;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.Lowerable;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_0, allowedUsageTypes={InputType.Memory})
public class FastNotifyNode
extends AbstractMemoryCheckpoint
implements Lowerable,
SingleMemoryKill,
DeoptimizingNode.DeoptDuring {
    public static final NodeClass<FastNotifyNode> TYPE = NodeClass.create(FastNotifyNode.class);
    private final boolean notifyAll;
    private final int bci;
    @Node.Input
    ValueNode object;
    @Node.OptionalInput(value=InputType.State)
    FrameState stateDuring;

    public FastNotifyNode(ValueNode object, boolean notifyAll, int bci) {
        super((NodeClass<? extends AbstractMemoryCheckpoint>)TYPE, StampFactory.forVoid());
        this.object = object;
        this.notifyAll = notifyAll;
        this.bci = bci;
    }

    public boolean isNotifyAll() {
        return this.notifyAll;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    @Override
    public FrameState stateDuring() {
        return this.stateDuring;
    }

    @Override
    public void setStateDuring(FrameState stateDuring) {
        this.updateUsages(this.stateDuring, stateDuring);
        this.stateDuring = stateDuring;
    }

    @Override
    public void computeStateDuring(FrameState currentStateAfter) {
        FrameState newStateDuring = currentStateAfter.duplicateModifiedDuringCall(this.bci, this.getStackKind());
        this.setStateDuring(newStateDuring);
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    public int getBci() {
        return this.bci;
    }
}

