/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.replacements;

import java.util.function.Function;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.nodes.CurrentJavaThreadNode;
import jdk.graal.compiler.hotspot.nodes.VirtualThreadUpdateJFRNode;
import jdk.graal.compiler.hotspot.nodes.type.KlassPointerStamp;
import jdk.graal.compiler.hotspot.replacements.ClassGetHubNode;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.hotspot.replacements.KlassLayoutHelperNode;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.gc.BarrierSet;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.memory.WriteNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.replacements.InvocationPluginHelper;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.word.LocationIdentity;

public class HotSpotInvocationPluginHelper
extends InvocationPluginHelper {
    private final GraalHotSpotVMConfig config;
    private final BarrierSet barrierSet;

    public HotSpotInvocationPluginHelper(GraphBuilderContext b, ResolvedJavaMethod targetMethod, GraalHotSpotVMConfig config) {
        super(b, targetMethod);
        this.config = config;
        this.barrierSet = b.getPlatformConfigurationProvider().getBarrierSet();
    }

    private Stamp getClassStamp(boolean nonNull) {
        ResolvedJavaType toType = this.b.getMetaAccess().lookupJavaType(Class.class);
        return StampFactory.object(TypeReference.createExactTrusted(toType), nonNull);
    }

    public ValueNode readKlassFromClass(ValueNode clazz) {
        return this.b.add(ClassGetHubNode.create(clazz, this.b.getMetaAccess(), this.b.getConstantReflection()));
    }

    private ValueNode readLocation(ValueNode base, HotSpotVMConfigField field) {
        return this.readLocation(base, field.getOffset(this.config), field.location, field.getStamp(this.getWordKind()), null);
    }

    private ValueNode readLocation(ValueNode base, HotSpotVMConfigField field, Stamp stamp) {
        assert (field.getStamp(this.getWordKind()) == null);
        return this.readLocation(base, field.getOffset(this.config), field.location, stamp, null);
    }

    private ValueNode readLocation(ValueNode base, int offset, LocationIdentity location, Stamp stamp, GuardingNode guard) {
        ValueNode returnValue;
        assert (StampTool.isPointerNonNull(base) || base.stamp(NodeView.DEFAULT).getStackKind() == this.getWordKind()) : "must be null guarded";
        AddressNode address = this.makeOffsetAddress(base, this.asWord(offset));
        ReadNode value = this.b.add(new ReadNode(address, location, stamp, this.barrierSet.readBarrierType(location, address, stamp), MemoryOrderMode.PLAIN));
        if (value == (returnValue = ReadNode.canonicalizeRead(value, value.getAddress(), value.getLocationIdentity(), this.b, NodeView.DEFAULT)) && guard != null) {
            value.setGuard(guard);
        }
        return this.b.add(returnValue);
    }

    public ValueNode readKlassModifierFlags(ValueNode klass) {
        return this.readLocation(klass, HotSpotVMConfigField.KLASS_MODIFIER_FLAGS_OFFSET);
    }

    public ValueNode readKlassAccessFlags(ValueNode klass) {
        return this.readLocation(klass, HotSpotVMConfigField.KLASS_ACCESS_FLAGS_OFFSET);
    }

    public ValueNode klassLayoutHelper(ValueNode klass) {
        return this.b.add(KlassLayoutHelperNode.create(this.config, klass, this.b.getConstantReflection(), this.b.getMetaAccess()));
    }

    public ValueNode readArrayKlassComponentMirror(ValueNode klass, GuardingNode guard) {
        int offset = this.config.getFieldOffset("ArrayKlass::_component_mirror", Integer.class, "oop");
        Stamp stamp = this.getClassStamp(true);
        return this.readLocation(klass, offset, HotSpotReplacementsUtil.ARRAY_KLASS_COMPONENT_MIRROR, stamp, guard);
    }

    public ValueNode readKlassSuperKlass(PiNode klassNonNull) {
        return this.readLocation(klassNonNull, HotSpotVMConfigField.KLASS_SUPER_KLASS_OFFSET);
    }

    public PiNode emitNullReturnGuard(ValueNode klass, ValueNode returnValue, double probability) {
        AbstractBeginNode nonnullGuard = this.emitReturnIf(IsNullNode.create(klass), returnValue, probability);
        return this.piCast(klass, nonnullGuard, KlassPointerStamp.klassNonNull());
    }

    public ValueNode loadArrayKlass(ValueNode componentType) {
        return this.readLocation(componentType, HotSpotVMConfigField.CLASS_ARRAY_KLASS_OFFSET);
    }

    public ValueNode readCurrentThreadObject(boolean readVirtualThread) {
        CurrentJavaThreadNode thread = this.b.add(new CurrentJavaThreadNode(this.getWordKind()));
        ObjectStamp threadStamp = StampFactory.objectNonNull(TypeReference.create(this.b.getAssumptions(), this.b.getMetaAccess().lookupJavaType(Thread.class)));
        Stamp fieldStamp = StampFactory.forKind(this.getWordKind());
        ValueNode value = this.readLocation(thread, readVirtualThread ? HotSpotVMConfigField.JAVA_THREAD_THREAD_OBJECT : HotSpotVMConfigField.JAVA_THREAD_CARRIER_THREAD_OBJECT, fieldStamp);
        AddressNode handleAddress = this.b.add(OffsetAddressNode.create(value));
        LocationIdentity location = readVirtualThread ? HotSpotReplacementsUtil.HOTSPOT_CURRENT_THREAD_OOP_HANDLE_LOCATION : HotSpotReplacementsUtil.HOTSPOT_OOP_HANDLE_LOCATION;
        value = this.b.add(new ReadNode(handleAddress, location, threadStamp, this.barrierSet.readBarrierType(location, handleAddress, threadStamp), MemoryOrderMode.PLAIN));
        return value;
    }

    public void setCurrentThread(ValueNode thread) {
        CurrentJavaThreadNode javaThread = this.b.add(new CurrentJavaThreadNode(this.getWordKind()));
        ValueNode threadObjectHandle = this.readLocation(javaThread, HotSpotVMConfigField.JAVA_THREAD_THREAD_OBJECT, StampFactory.forKind(this.getWordKind()));
        AddressNode handleAddress = this.b.add(OffsetAddressNode.create(threadObjectHandle));
        this.b.add(new WriteNode(handleAddress, HotSpotReplacementsUtil.HOTSPOT_CURRENT_THREAD_OOP_HANDLE_LOCATION, thread, BarrierType.NONE, MemoryOrderMode.PLAIN));
        if (HotSpotReplacementsUtil.supportsVirtualThreadUpdateJFR(this.config)) {
            this.b.add(new VirtualThreadUpdateJFRNode(thread));
        }
    }

    private AddressNode scopedValueCacheHelper() {
        CurrentJavaThreadNode javaThread = this.b.add(new CurrentJavaThreadNode(this.getWordKind()));
        ValueNode scopedValueCacheHandle = this.readLocation(javaThread, HotSpotVMConfigField.JAVA_THREAD_SCOPED_VALUE_CACHE_OFFSET, StampFactory.forKind(this.getWordKind()));
        return this.b.add(OffsetAddressNode.create(scopedValueCacheHandle));
    }

    public ValueNode readThreadScopedValueCache() {
        AddressNode handleAddress = this.scopedValueCacheHelper();
        ObjectStamp stamp = StampFactory.object(TypeReference.create(this.b.getAssumptions(), this.b.getMetaAccess().lookupJavaType(Object[].class)));
        return this.b.add(new ReadNode(handleAddress, HotSpotReplacementsUtil.HOTSPOT_JAVA_THREAD_SCOPED_VALUE_CACHE_HANDLE_LOCATION, stamp, this.barrierSet.readBarrierType(HotSpotReplacementsUtil.HOTSPOT_JAVA_THREAD_SCOPED_VALUE_CACHE_HANDLE_LOCATION, handleAddress, stamp), MemoryOrderMode.PLAIN));
    }

    public void setThreadScopedValueCache(ValueNode cache) {
        AddressNode handleAddress = this.scopedValueCacheHelper();
        this.b.add(new WriteNode(handleAddress, HotSpotReplacementsUtil.HOTSPOT_JAVA_THREAD_SCOPED_VALUE_CACHE_HANDLE_LOCATION, cache, BarrierType.NONE, MemoryOrderMode.PLAIN));
    }

    public ValueNode readOsThread(CurrentJavaThreadNode thread) {
        return this.readLocation(thread, HotSpotVMConfigField.JAVA_THREAD_OSTHREAD_OFFSET);
    }

    static enum HotSpotVMConfigField {
        KLASS_MODIFIER_FLAGS_OFFSET(config -> config.klassModifierFlagsOffset, HotSpotReplacementsUtil.KLASS_MODIFIER_FLAGS_LOCATION, StampFactory.forKind(JavaKind.Int)),
        KLASS_SUPER_KLASS_OFFSET(config -> config.klassSuperKlassOffset, HotSpotReplacementsUtil.KLASS_SUPER_KLASS_LOCATION, KlassPointerStamp.klass()),
        CLASS_ARRAY_KLASS_OFFSET(config -> config.arrayKlassOffset, HotSpotReplacementsUtil.CLASS_ARRAY_KLASS_LOCATION, KlassPointerStamp.klassNonNull()),
        JAVA_THREAD_OSTHREAD_OFFSET(config -> config.osThreadOffset, HotSpotReplacementsUtil.JAVA_THREAD_OSTHREAD_LOCATION),
        JAVA_THREAD_THREAD_OBJECT(config -> config.threadCurrentThreadObjectOffset, HotSpotReplacementsUtil.JAVA_THREAD_CURRENT_THREAD_OBJECT_LOCATION, null),
        JAVA_THREAD_CARRIER_THREAD_OBJECT(config -> config.threadCarrierThreadObjectOffset, HotSpotReplacementsUtil.JAVA_THREAD_CARRIER_THREAD_OBJECT_LOCATION, null),
        JAVA_THREAD_SCOPED_VALUE_CACHE_OFFSET(config -> config.threadScopedValueCacheOffset, HotSpotReplacementsUtil.JAVA_THREAD_SCOPED_VALUE_CACHE_LOCATION, null),
        KLASS_ACCESS_FLAGS_OFFSET(config -> config.klassAccessFlagsOffset, HotSpotReplacementsUtil.KLASS_ACCESS_FLAGS_LOCATION, StampFactory.forKind(JavaKind.Int)),
        HOTSPOT_OOP_HANDLE_VALUE(config -> 0, HotSpotReplacementsUtil.HOTSPOT_OOP_HANDLE_LOCATION, StampFactory.forKind(JavaKind.Object));

        private final Function<GraalHotSpotVMConfig, Integer> getter;
        private final LocationIdentity location;
        private final Stamp stamp;
        private final boolean isWord;

        private HotSpotVMConfigField(Function<GraalHotSpotVMConfig, Integer> getter, LocationIdentity location, Stamp stamp) {
            this.getter = getter;
            this.location = location;
            this.stamp = stamp;
            this.isWord = false;
        }

        private HotSpotVMConfigField(Function<GraalHotSpotVMConfig, Integer> getter, LocationIdentity location) {
            this.getter = getter;
            this.location = location;
            this.stamp = null;
            this.isWord = true;
        }

        public int getOffset(GraalHotSpotVMConfig config) {
            return this.getter.apply(config);
        }

        public Stamp getStamp(JavaKind wordKind) {
            if (this.isWord) {
                return StampFactory.forKind(wordKind);
            }
            return this.stamp;
        }
    }
}

