/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.replacements;

import jdk.graal.compiler.api.runtime.GraalJVMCICompiler;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.extended.LoadHubNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.runtime.JVMCI;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
@Node.NodeIntrinsicFactory
public final class KlassLayoutHelperNode
extends FloatingNode
implements Canonicalizable,
Lowerable {
    public static final NodeClass<KlassLayoutHelperNode> TYPE = NodeClass.create(KlassLayoutHelperNode.class);
    @Node.Input
    protected ValueNode klass;

    public KlassLayoutHelperNode(ValueNode klass) {
        super((NodeClass<? extends FloatingNode>)TYPE, StampFactory.forKind(JavaKind.Int));
        this.klass = klass;
    }

    public static ValueNode create(GraalHotSpotVMConfig config, ValueNode klass, ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess) {
        Stamp stamp = StampFactory.forKind(JavaKind.Int);
        return KlassLayoutHelperNode.canonical(null, config, klass, stamp, constantReflection, metaAccess);
    }

    public static boolean intrinsify(GraphBuilderContext b, @Node.InjectedNodeParameter GraalHotSpotVMConfig config, ValueNode klass) {
        ValueNode valueNode = KlassLayoutHelperNode.create(config, klass, b.getConstantReflection(), b.getMetaAccess());
        b.push(JavaKind.Int, b.append(valueNode));
        return true;
    }

    @Override
    public boolean inferStamp() {
        ObjectStamp objectStamp;
        ResolvedJavaType type;
        LoadHubNode hub;
        Stamp hubStamp;
        if (this.klass instanceof LoadHubNode && (hubStamp = (hub = (LoadHubNode)this.klass).getValue().stamp(NodeView.DEFAULT)) instanceof ObjectStamp && (type = (objectStamp = (ObjectStamp)hubStamp).type()) != null && !type.isJavaLangObject()) {
            GraalHotSpotVMConfig config = KlassLayoutHelperNode.getConfig();
            if (!type.isArray() && !type.isInterface()) {
                return this.updateStamp(StampFactory.forInteger(JavaKind.Int, config.klassLayoutHelperNeutralValue, Integer.MAX_VALUE));
            }
            if (type.isArray()) {
                return this.updateStamp(StampFactory.forInteger(JavaKind.Int, Integer.MIN_VALUE, config.klassLayoutHelperNeutralValue - 1));
            }
        }
        return false;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (tool.allUsagesAvailable() && this.hasNoUsages()) {
            return null;
        }
        return KlassLayoutHelperNode.canonical(this, KlassLayoutHelperNode.getConfig(), this.klass, this.stamp(NodeView.DEFAULT), tool.getConstantReflection(), tool.getMetaAccess());
    }

    private static GraalHotSpotVMConfig getConfig() {
        return ((GraalJVMCICompiler)JVMCI.getRuntime().getCompiler()).getGraalRuntime().getCapability(GraalHotSpotVMConfig.class);
    }

    private static ValueNode canonical(KlassLayoutHelperNode klassLayoutHelperNode, GraalHotSpotVMConfig config, ValueNode klass, Stamp stamp, ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess) {
        ObjectStamp ostamp;
        HotSpotResolvedObjectType type;
        LoadHubNode hub;
        Stamp hubStamp;
        KlassLayoutHelperNode self = klassLayoutHelperNode;
        if (klass.isConstant() && !klass.asConstant().isDefaultForKind()) {
            Constant constant = stamp.readConstant(constantReflection.getMemoryAccessProvider(), klass.asConstant(), config.klassLayoutHelperOffset);
            return ConstantNode.forConstant(stamp, constant, metaAccess);
        }
        if (klass instanceof LoadHubNode && (hubStamp = (hub = (LoadHubNode)klass).getValue().stamp(NodeView.DEFAULT)) instanceof ObjectStamp && (type = (HotSpotResolvedObjectType)(ostamp = (ObjectStamp)hubStamp).type()) != null && type.isArray() && !type.getComponentType().isPrimitive()) {
            Constant constant = stamp.readConstant(constantReflection.getMemoryAccessProvider(), type.klass(), config.klassLayoutHelperOffset);
            return ConstantNode.forConstant(stamp, constant, metaAccess);
        }
        if (self == null) {
            self = new KlassLayoutHelperNode(klass);
        }
        return self;
    }

    public ValueNode getHub() {
        return this.klass;
    }
}

