/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.replacements;

import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.meta.HotSpotRegistersProvider;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.hotspot.replacements.HotspotSnippetsOptions;
import jdk.graal.compiler.hotspot.word.HotSpotWordTypes;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.java.LoadExceptionObjectNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.replacements.nodes.ReadRegisterNode;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.word.WordFactory;

public class LoadExceptionObjectSnippets
implements Snippets {
    @Snippet
    public static Object loadException(@Snippet.ConstantParameter Register threadRegister) {
        Word thread = HotSpotReplacementsUtil.registerAsWord(threadRegister);
        Object exception = HotSpotReplacementsUtil.readExceptionOop(thread);
        HotSpotReplacementsUtil.writeExceptionOop(thread, null);
        HotSpotReplacementsUtil.writeExceptionPc(thread, (Word)WordFactory.zero());
        return PiNode.piCastToSnippetReplaceeStamp(exception);
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo loadException;
        private final HotSpotWordTypes wordTypes;

        public Templates(OptionValues options, HotSpotProviders providers) {
            super(options, providers);
            this.loadException = this.snippet((Providers)providers, LoadExceptionObjectSnippets.class, "loadException", HotSpotReplacementsUtil.EXCEPTION_OOP_LOCATION, HotSpotReplacementsUtil.EXCEPTION_PC_LOCATION);
            this.wordTypes = providers.getWordTypes();
        }

        public void lower(LoadExceptionObjectNode loadExceptionObject, HotSpotRegistersProvider registers, LoweringTool tool) {
            StructuredGraph graph = loadExceptionObject.graph();
            if (HotspotSnippetsOptions.LoadExceptionObjectInVM.getValue(graph.getOptions()).booleanValue()) {
                ResolvedJavaType wordType = tool.getMetaAccess().lookupJavaType(Word.class);
                Stamp stamp = this.wordTypes.getWordStamp(wordType);
                ReadRegisterNode thread = graph.add(new ReadRegisterNode(stamp, registers.getThreadRegister(), true, false));
                graph.addBeforeFixed(loadExceptionObject, thread);
                ForeignCallNode loadExceptionC = graph.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotForeignCallsProviderImpl.LOAD_AND_CLEAR_EXCEPTION, thread));
                loadExceptionC.setStateAfter(loadExceptionObject.stateAfter());
                loadExceptionC.computeStateDuring(loadExceptionObject.stateAfter());
                graph.replaceFixedWithFixed(loadExceptionObject, loadExceptionC);
            } else {
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.loadException, loadExceptionObject.graph().getGuardsStage(), tool.getLoweringStage());
                args.addConst("threadRegister", registers.getThreadRegister());
                this.template(tool, loadExceptionObject, args).instantiate(tool.getMetaAccess(), loadExceptionObject, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }
    }
}

