/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.replacements;

import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.replacements.Log;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.replacements.nodes.CStringConstant;
import jdk.graal.compiler.replacements.nodes.LogNode;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.Constant;
import org.graalvm.word.LocationIdentity;

public class LogSnippets
implements Snippets {
    @Snippet
    public static void print(@Snippet.ConstantParameter Word message) {
        Log.print(message);
    }

    @Snippet
    public static void printf1(@Snippet.ConstantParameter Word message, long l1) {
        Log.printf(message, l1);
    }

    @Snippet
    public static void printf2(@Snippet.ConstantParameter Word message, long l1, long l2) {
        Log.printf(message, l1, l2);
    }

    @Snippet
    public static void printf3(@Snippet.ConstantParameter Word message, long l1, long l2, long l3) {
        Log.printf(message, l1, l2, l3);
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo print;
        private final SnippetTemplate.SnippetInfo printf1;
        private final SnippetTemplate.SnippetInfo printf2;
        private final SnippetTemplate.SnippetInfo printf3;

        public Templates(OptionValues options, HotSpotProviders providers) {
            super(options, providers);
            this.print = this.snippet((Providers)providers, LogSnippets.class, "print", new LocationIdentity[0]);
            this.printf1 = this.snippet((Providers)providers, LogSnippets.class, "printf1", new LocationIdentity[0]);
            this.printf2 = this.snippet((Providers)providers, LogSnippets.class, "printf2", new LocationIdentity[0]);
            this.printf3 = this.snippet((Providers)providers, LogSnippets.class, "printf3", new LocationIdentity[0]);
        }

        public void lower(LogNode logNode, LoweringTool tool) {
            StructuredGraph graph = logNode.graph();
            SnippetTemplate.SnippetInfo info = this.print;
            if (logNode.getL3() != null) {
                info = this.printf3;
            } else if (logNode.getL2() != null) {
                info = this.printf2;
            } else if (logNode.getL1() != null) {
                info = this.printf1;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(info, graph.getGuardsStage(), tool.getLoweringStage());
            args.addConst("message", graph.unique(new ConstantNode((Constant)new CStringConstant(logNode.message()), StampFactory.pointer())));
            if (logNode.getL1() != null) {
                args.add("l1", logNode.getL1());
            }
            if (logNode.getL2() != null) {
                args.add("l2", logNode.getL2());
            }
            if (logNode.getL3() != null) {
                args.add("l3", logNode.getL3());
            }
            this.template(tool, logNode, args).instantiate(tool.getMetaAccess(), logNode, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

