/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.replacements;

import java.util.EnumMap;
import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.nodes.java.DynamicNewArrayNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.replacements.arraycopy.ArrayCopyCallNode;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;

public class ObjectCloneSnippets
implements Snippets {
    @Snippet
    public static boolean[] booleanArrayClone(boolean[] src) {
        boolean[] result = (boolean[])NewArrayNode.newUninitializedArray(Boolean.TYPE, src.length);
        ArrayCopyCallNode.disjointArraycopy(src, 0, result, 0, src.length, JavaKind.Boolean, HotSpotReplacementsUtil.getHeapWordSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        return result;
    }

    @Snippet
    public static byte[] byteArrayClone(byte[] src) {
        byte[] result = (byte[])NewArrayNode.newUninitializedArray(Byte.TYPE, src.length);
        ArrayCopyCallNode.disjointArraycopy(src, 0, result, 0, src.length, JavaKind.Byte, HotSpotReplacementsUtil.getHeapWordSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        return result;
    }

    @Snippet
    public static short[] shortArrayClone(short[] src) {
        short[] result = (short[])NewArrayNode.newUninitializedArray(Short.TYPE, src.length);
        ArrayCopyCallNode.disjointArraycopy(src, 0, result, 0, src.length, JavaKind.Short, HotSpotReplacementsUtil.getHeapWordSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        return result;
    }

    @Snippet
    public static char[] charArrayClone(char[] src) {
        char[] result = (char[])NewArrayNode.newUninitializedArray(Character.TYPE, src.length);
        ArrayCopyCallNode.disjointArraycopy(src, 0, result, 0, src.length, JavaKind.Char, HotSpotReplacementsUtil.getHeapWordSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        return result;
    }

    @Snippet
    public static int[] intArrayClone(int[] src) {
        int[] result = (int[])NewArrayNode.newUninitializedArray(Integer.TYPE, src.length);
        ArrayCopyCallNode.disjointArraycopy(src, 0, result, 0, src.length, JavaKind.Int, HotSpotReplacementsUtil.getHeapWordSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        return result;
    }

    @Snippet
    public static float[] floatArrayClone(float[] src) {
        float[] result = (float[])NewArrayNode.newUninitializedArray(Float.TYPE, src.length);
        ArrayCopyCallNode.disjointArraycopy(src, 0, result, 0, src.length, JavaKind.Float, HotSpotReplacementsUtil.getHeapWordSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        return result;
    }

    @Snippet
    public static long[] longArrayClone(long[] src) {
        long[] result = (long[])NewArrayNode.newUninitializedArray(Long.TYPE, src.length);
        ArrayCopyCallNode.disjointArraycopy(src, 0, result, 0, src.length, JavaKind.Long, HotSpotReplacementsUtil.getHeapWordSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        return result;
    }

    @Snippet
    public static double[] doubleArrayClone(double[] src) {
        double[] result = (double[])NewArrayNode.newUninitializedArray(Double.TYPE, src.length);
        ArrayCopyCallNode.disjointArraycopy(src, 0, result, 0, src.length, JavaKind.Double, HotSpotReplacementsUtil.getHeapWordSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        return result;
    }

    @Snippet
    public static Object[] objectArrayClone(Object[] src) {
        Object[] result = (Object[])DynamicNewArrayNode.newArray(GraalDirectives.guardingNonNull(src.getClass().getComponentType()), src.length, JavaKind.Object);
        ArrayCopyCallNode.disjointUninitializedArraycopy(src, 0, result, 0, src.length, JavaKind.Object, HotSpotReplacementsUtil.getHeapWordSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        return result;
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        final EnumMap<JavaKind, SnippetTemplate.SnippetInfo> arrayCloneMethods = new EnumMap(JavaKind.class);

        public Templates(OptionValues options, HotSpotProviders providers) {
            super(options, providers);
            this.arrayCloneMethods.put(JavaKind.Boolean, this.snippet((Providers)providers, ObjectCloneSnippets.class, "booleanArrayClone", new LocationIdentity[0]));
            this.arrayCloneMethods.put(JavaKind.Byte, this.snippet((Providers)providers, ObjectCloneSnippets.class, "byteArrayClone", new LocationIdentity[0]));
            this.arrayCloneMethods.put(JavaKind.Char, this.snippet((Providers)providers, ObjectCloneSnippets.class, "charArrayClone", new LocationIdentity[0]));
            this.arrayCloneMethods.put(JavaKind.Short, this.snippet((Providers)providers, ObjectCloneSnippets.class, "shortArrayClone", new LocationIdentity[0]));
            this.arrayCloneMethods.put(JavaKind.Int, this.snippet((Providers)providers, ObjectCloneSnippets.class, "intArrayClone", new LocationIdentity[0]));
            this.arrayCloneMethods.put(JavaKind.Float, this.snippet((Providers)providers, ObjectCloneSnippets.class, "floatArrayClone", new LocationIdentity[0]));
            this.arrayCloneMethods.put(JavaKind.Long, this.snippet((Providers)providers, ObjectCloneSnippets.class, "longArrayClone", new LocationIdentity[0]));
            this.arrayCloneMethods.put(JavaKind.Double, this.snippet((Providers)providers, ObjectCloneSnippets.class, "doubleArrayClone", new LocationIdentity[0]));
            this.arrayCloneMethods.put(JavaKind.Object, this.snippet((Providers)providers, ObjectCloneSnippets.class, "objectArrayClone", new LocationIdentity[0]));
        }
    }
}

