/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.replacements;

import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.debug.StringToBytesNode;
import jdk.graal.compiler.nodes.extended.RawStoreNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.ReplacementsUtil;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.replacements.nodes.CStringConstant;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;

public class StringToBytesSnippets
implements Snippets {
    public static final LocationIdentity CSTRING_LOCATION = NamedLocationIdentity.immutable("CString location");

    @Snippet
    public static byte[] transform(@Snippet.ConstantParameter Word cArray, @Snippet.ConstantParameter int length, @Snippet.ConstantParameter LocationIdentity locationIdentity) {
        int i = length;
        byte[] array = (byte[])NewArrayNode.newUninitializedArray(Byte.TYPE, i);
        while (GraalDirectives.injectIterationCount(100.0, i-- > 0)) {
            RawStoreNode.storeByte(array, ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Byte) + i, cArray.readByte(i, CSTRING_LOCATION), JavaKind.Byte, locationIdentity);
        }
        return array;
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo create;

        public Templates(OptionValues options, HotSpotProviders providers) {
            super(options, providers);
            this.create = this.snippet((Providers)providers, StringToBytesSnippets.class, "transform", new LocationIdentity[0]);
        }

        public void lower(StringToBytesNode stringToBytesNode, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.create, stringToBytesNode.graph().getGuardsStage(), tool.getLoweringStage());
            String value = stringToBytesNode.getValue();
            args.addConst("cArray", new CStringConstant(value));
            args.addConst("length", value.length());
            args.addConst("locationIdentity", LocationIdentity.init());
            SnippetTemplate template = this.template(tool, stringToBytesNode, args);
            template.instantiate(tool.getMetaAccess(), stringToBytesNode, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

