/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.replacements;

import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.meta.HotSpotRegistersProvider;
import jdk.graal.compiler.hotspot.nodes.VirtualThreadUpdateJFRNode;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.MembarNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.code.Register;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordBase;

@SyncPort(from="https://github.com/openjdk/jdk/blob/0a3a925ad88921d387aa851157f54ac0054d347b/src/hotspot/share/opto/library_call.cpp#L3453-L3579", sha1="1f980401f5d7d9a363577635fd57fc1e24505d91")
public class VirtualThreadUpdateJFRSnippets
implements Snippets {
    private static final int EXCLUDED_MASK = 32768;
    private static final int EPOCH_MASK = Short.MAX_VALUE;
    private static final byte BOOL_TRUE = 1;
    private static final byte BOOL_FALSE = 0;
    public static final LocationIdentity JAVA_LANG_THREAD_JFR_EPOCH = NamedLocationIdentity.mutable("java/lang/Thread.jfrEpoch");
    public static final LocationIdentity JAVA_LANG_THREAD_TID = NamedLocationIdentity.mutable("java/lang/Thread.tid");
    public static final LocationIdentity JFR_THREAD_LOCAL_VTHREAD_ID = NamedLocationIdentity.mutable("JfrThreadLocal::_vthread_id");
    public static final LocationIdentity JFR_THREAD_LOCAL_VTHREAD_EPOCH = NamedLocationIdentity.mutable("JfrThreadLocal::_vthread_epoch");
    public static final LocationIdentity JFR_THREAD_LOCAL_VTHREAD_EXCLUDED = NamedLocationIdentity.mutable("JfrThreadLocal::_vthread_excluded");
    public static final LocationIdentity JFR_THREAD_LOCAL_VTHREAD = NamedLocationIdentity.mutable("JfrThreadLocal::_vthread");

    @Snippet
    public static void virtualThreadUpdateJFR(@Snippet.ConstantParameter Register javaThreadRegister, Object threadObj) {
        Word javaThread = HotSpotReplacementsUtil.registerAsWord(javaThreadRegister);
        Word carrierThreadHandle = (Word)javaThread.readWord(HotSpotReplacementsUtil.threadCarrierThreadOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.JAVA_THREAD_CARRIER_THREAD_OBJECT_LOCATION);
        Word thread = Word.objectToTrackedPointer(threadObj);
        if (BranchProbabilityNode.probability(0.6, thread.notEqual((Word)carrierThreadHandle.readWord(0, HotSpotReplacementsUtil.HOTSPOT_CARRIER_THREAD_OOP_HANDLE_LOCATION)))) {
            short vthreadEpochRaw = thread.readShort(HotSpotReplacementsUtil.javaLangThreadJFREpochOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), JAVA_LANG_THREAD_JFR_EPOCH);
            Word tid = (Word)thread.readWord(HotSpotReplacementsUtil.javaLangThreadTIDOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), JAVA_LANG_THREAD_TID);
            javaThread.writeWord(HotSpotReplacementsUtil.jfrThreadLocalVthreadIDOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (WordBase)tid, JFR_THREAD_LOCAL_VTHREAD_ID);
            if (BranchProbabilityNode.probability(0.6, (vthreadEpochRaw & 0x8000) == 0)) {
                javaThread.writeChar(HotSpotReplacementsUtil.jfrThreadLocalVthreadEpochOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (char)(vthreadEpochRaw & Short.MAX_VALUE), JFR_THREAD_LOCAL_VTHREAD_EPOCH);
                javaThread.writeByte(HotSpotReplacementsUtil.jfrThreadLocalVthreadExcludedOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (byte)0, JFR_THREAD_LOCAL_VTHREAD_EXCLUDED);
            } else {
                javaThread.writeByte(HotSpotReplacementsUtil.jfrThreadLocalVthreadExcludedOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (byte)1, JFR_THREAD_LOCAL_VTHREAD_EXCLUDED);
            }
            MembarNode.memoryBarrier(MembarNode.FenceKind.STORE_RELEASE);
            javaThread.writeByte(HotSpotReplacementsUtil.jfrThreadLocalVthreadOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (byte)1, JFR_THREAD_LOCAL_VTHREAD);
        } else {
            MembarNode.memoryBarrier(MembarNode.FenceKind.STORE_RELEASE);
            javaThread.writeByte(HotSpotReplacementsUtil.jfrThreadLocalVthreadOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (byte)0, JFR_THREAD_LOCAL_VTHREAD);
        }
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo virtualThreadUpdateJFR;

        public Templates(OptionValues options, HotSpotProviders providers) {
            super(options, providers);
            this.virtualThreadUpdateJFR = this.snippet((Providers)providers, VirtualThreadUpdateJFRSnippets.class, "virtualThreadUpdateJFR", HotSpotReplacementsUtil.JAVA_THREAD_CARRIER_THREAD_OBJECT_LOCATION, HotSpotReplacementsUtil.HOTSPOT_CARRIER_THREAD_OOP_HANDLE_LOCATION, JAVA_LANG_THREAD_JFR_EPOCH, JAVA_LANG_THREAD_TID, JFR_THREAD_LOCAL_VTHREAD_ID, JFR_THREAD_LOCAL_VTHREAD_EPOCH, JFR_THREAD_LOCAL_VTHREAD_EXCLUDED, JFR_THREAD_LOCAL_VTHREAD);
        }

        public void lower(VirtualThreadUpdateJFRNode virtualThreadUpdateJFRNode, HotSpotRegistersProvider registers, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.virtualThreadUpdateJFR, virtualThreadUpdateJFRNode.graph().getGuardsStage(), tool.getLoweringStage());
            args.addConst("javaThreadRegister", registers.getThreadRegister());
            args.add("threadObj", virtualThreadUpdateJFRNode.getThread());
            this.template(tool, virtualThreadUpdateJFRNode, args).instantiate(tool.getMetaAccess(), virtualThreadUpdateJFRNode, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

