/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.stubs;

import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.hotspot.HotSpotGraphBuilderInstance;
import jdk.graal.compiler.java.GraphBuilderPhase;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.InvokeNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.IntrinsicContext;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.phases.common.DeadCodeEliminationPhase;
import jdk.graal.compiler.phases.common.inlining.InliningUtil;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.GraphKit;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.services.Services;

public class HotSpotGraphKit
extends GraphKit {
    public HotSpotGraphKit(DebugContext debug, ResolvedJavaMethod stubMethod, Providers providers, GraphBuilderConfiguration.Plugins graphBuilderPlugins, CompilationIdentifier compilationId, String name, boolean trackNodeSourcePosition, boolean recordInlinedMethods) {
        super(debug, stubMethod, providers, graphBuilderPlugins, compilationId, name, trackNodeSourcePosition, recordInlinedMethods);
    }

    public void inlineInvokesAsIntrinsics(String reason, String phase) {
        while (!this.graph.getNodes().filter(InvokeNode.class).isEmpty()) {
            for (InvokeNode invoke : this.graph.getNodes().filter(InvokeNode.class).snapshot()) {
                this.inlineAsIntrinsic(invoke, reason, phase);
            }
        }
        new DeadCodeEliminationPhase().apply(this.graph);
    }

    public void inlineAsIntrinsic(Invoke invoke, String reason, String phase) {
        StructuredGraph calleeGraph;
        assert (invoke instanceof Node) : Assertions.errorMessage(invoke, reason, phase);
        Node invokeNode = (Node)((Object)invoke);
        ResolvedJavaMethod method = invoke.callTarget().targetMethod();
        GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(this.graphBuilderPlugins);
        GraphBuilderConfiguration config = GraphBuilderConfiguration.getSnippetDefault(plugins);
        if (Services.IS_IN_NATIVE_IMAGE) {
            calleeGraph = this.getReplacements().getSnippet(method, null, null, null, false, null, invokeNode.getOptions());
        } else {
            calleeGraph = new StructuredGraph.Builder(invokeNode.getOptions(), invokeNode.getDebug()).method(method).trackNodeSourcePosition(invokeNode.graph().trackNodeSourcePosition()).setIsSubstitution(true).build();
            IntrinsicContext initialReplacementContext = new IntrinsicContext(method, method, this.getReplacements().getDefaultReplacementBytecodeProvider(), IntrinsicContext.CompilationContext.INLINE_AFTER_PARSING);
            GraphBuilderPhase.Instance instance = this.createGraphBuilderInstance(config, OptimisticOptimizations.NONE, initialReplacementContext);
            instance.apply(calleeGraph);
        }
        new DeadCodeEliminationPhase().apply(calleeGraph);
        InliningUtil.inline(invoke, calleeGraph, false, method, reason, phase);
    }

    protected GraphBuilderPhase.Instance createGraphBuilderInstance(GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
        return new HotSpotGraphBuilderInstance(this.getProviders(), graphBuilderConfig, optimisticOpts, initialIntrinsicContext);
    }
}

