/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.stubs;

import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.HotSpotForeignCallLinkage;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.nodes.AllocaNode;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.hotspot.stubs.CreateExceptionStub;
import jdk.graal.compiler.hotspot.stubs.OutOfBoundsExceptionStub;
import jdk.graal.compiler.hotspot.stubs.StubUtil;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.code.Register;

public class NegativeArraySizeExceptionStub
extends CreateExceptionStub {
    public NegativeArraySizeExceptionStub(OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super("createNegativeArraySizeException", options, providers, linkage);
    }

    @Override
    protected Object getConstantParameterValue(int index, String name) {
        switch (index) {
            case 1: {
                return this.providers.getRegisters().getThreadRegister();
            }
            case 2: {
                return OutOfBoundsExceptionStub.MAX_INT_STRING_SIZE + 1;
            }
            case 3: {
                return true;
            }
        }
        throw GraalError.shouldNotReachHere("unknown parameter " + name + " at index " + index);
    }

    @Snippet
    private static Object createNegativeArraySizeException(int length, @Snippet.ConstantParameter Register threadRegister, @Snippet.ConstantParameter int bufferSizeInBytes, @Snippet.ConstantParameter boolean printLengthInException) {
        if (printLengthInException) {
            Word buffer = AllocaNode.alloca(bufferSizeInBytes, HotSpotReplacementsUtil.wordSize());
            Word ptr = StubUtil.printNumber(buffer, length);
            ptr.writeByte(0, (byte)0);
            return NegativeArraySizeExceptionStub.createException(threadRegister, NegativeArraySizeException.class, buffer);
        }
        return NegativeArraySizeExceptionStub.createException(threadRegister, NegativeArraySizeException.class);
    }
}

