/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.stubs;

import java.util.ListIterator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.core.CompilationPrinter;
import jdk.graal.compiler.core.GraalCompiler;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.target.Backend;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugOptions;
import jdk.graal.compiler.hotspot.HotSpotCompiledCodeBuilder;
import jdk.graal.compiler.hotspot.HotSpotForeignCallLinkage;
import jdk.graal.compiler.hotspot.HotSpotHostBackend;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.nodes.StubStartNode;
import jdk.graal.compiler.hotspot.stubs.StubCompilationIdentifier;
import jdk.graal.compiler.lir.asm.CompilationResultBuilderFactory;
import jdk.graal.compiler.lir.phases.LIRPhase;
import jdk.graal.compiler.lir.phases.LIRSuites;
import jdk.graal.compiler.lir.phases.PostAllocationOptimizationPhase;
import jdk.graal.compiler.lir.profiling.MoveProfilingPhase;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.phases.PhaseSuite;
import jdk.graal.compiler.phases.Speculative;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.graal.compiler.phases.tiers.Suites;
import jdk.graal.compiler.printer.GraalDebugHandlersFactory;
import jdk.graal.compiler.util.CollectionsUtil;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.hotspot.HotSpotCodeCacheProvider;
import jdk.vm.ci.hotspot.HotSpotCompiledCode;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.meta.DefaultProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.TriState;
import org.graalvm.collections.EconomicSet;

public abstract class Stub {
    protected final HotSpotForeignCallLinkage linkage;
    protected InstalledCode code;
    private EconomicSet<Register> destroyedCallerRegisters;
    protected final OptionValues options;
    protected final HotSpotProviders providers;
    private static final AtomicInteger nextStubId = new AtomicInteger();

    private static boolean checkRegisterSetEquivalency(EconomicSet<Register> a, EconomicSet<Register> b) {
        if (a == b) {
            return true;
        }
        if (a.size() != b.size()) {
            return false;
        }
        return CollectionsUtil.allMatch(a, e -> b.contains(e));
    }

    public void initDestroyedCallerRegisters(EconomicSet<Register> registers) {
        assert (registers != null);
        assert (this.destroyedCallerRegisters == null || Stub.checkRegisterSetEquivalency(registers, this.destroyedCallerRegisters)) : "cannot redefine";
        this.destroyedCallerRegisters = registers;
    }

    public EconomicSet<Register> getDestroyedCallerRegisters() {
        assert (this.destroyedCallerRegisters != null) : "not yet initialized";
        return this.destroyedCallerRegisters;
    }

    public boolean shouldSaveRegistersAroundCalls() {
        return this.linkage.getEffect() != HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS;
    }

    public Stub(OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        this.linkage = linkage;
        this.options = new OptionValues(options, GraalOptions.TraceInlining, GraalOptions.TraceInliningForStubsAndSnippets.getValue(options), GraalOptions.RegisterPressure, null, DebugOptions.OptimizationLog, null);
        this.providers = providers;
    }

    public HotSpotForeignCallLinkage getLinkage() {
        return this.linkage;
    }

    public RegisterConfig getRegisterConfig() {
        return null;
    }

    protected abstract StructuredGraph getGraph(DebugContext var1, CompilationIdentifier var2);

    public String toString() {
        return "Stub<" + String.valueOf(this.linkage.getDescriptor().getSignature()) + ">";
    }

    protected abstract ResolvedJavaMethod getInstalledCodeOwner();

    protected abstract Object debugScopeContext();

    private DebugContext openDebugContext(DebugContext outer) {
        if (DebugOptions.DebugStubsAndSnippets.getValue(this.options).booleanValue()) {
            DebugContext.Description description = new DebugContext.Description(this.linkage, "Stub_" + nextStubId.incrementAndGet());
            GraalDebugHandlersFactory factory = new GraalDebugHandlersFactory(this.providers.getSnippetReflection());
            return new DebugContext.Builder(this.options, factory).globalMetrics(outer.getGlobalMetrics()).description(description).build();
        }
        return DebugContext.disabled(this.options);
    }

    public synchronized InstalledCode getCode(Backend backend) {
        if (this.code == null) {
            try (DebugContext debug = this.openDebugContext(DebugContext.forCurrentThread());){
                try (DebugContext.Scope d = debug.scope("CompilingStub", this.providers.getCodeCache(), this.debugScopeContext());){
                    CompilationIdentifier compilationId = this.getStubCompilationId();
                    StructuredGraph graph = this.getGraph(debug, compilationId);
                    CompilationPrinter printer = CompilationPrinter.begin(debug.getOptions(), compilationId, this.linkage.getDescriptor().getSignature(), -1);
                    HotSpotCodeCacheProvider codeCache = this.providers.getCodeCache();
                    CompilationResult compResult = this.buildCompilationResult(debug, backend, graph, compilationId);
                    try (DebugContext.Scope s = debug.scope((Object)"CodeInstall", compResult);
                         DebugContext.Activation a = debug.activate();){
                        assert (this.destroyedCallerRegisters != null);
                        HotSpotCompiledCode compiledCode = HotSpotCompiledCodeBuilder.createCompiledCode((CodeCacheProvider)codeCache, null, null, compResult, this.options);
                        this.code = codeCache.installCode(null, (CompiledCode)compiledCode, null, null, false);
                    }
                    catch (Throwable e) {
                        throw debug.handle(e);
                    }
                    printer.finish(compResult, this.code);
                }
                catch (Throwable e) {
                    throw debug.handle(e);
                }
                assert (this.code != null) : "error installing stub " + String.valueOf(this);
            }
        }
        return this.code;
    }

    private CompilationResult buildCompilationResult(DebugContext debug, Backend backend, StructuredGraph graph, CompilationIdentifier compilationId) {
        CompilationResult compResult = new CompilationResult(compilationId, this.toString());
        assert (graph.getAssumptions() == null);
        if (!(graph.start() instanceof StubStartNode)) {
            StubStartNode newStart = graph.add(new StubStartNode(this));
            newStart.setStateAfter(graph.start().stateAfter());
            graph.replaceFixed(graph.start(), newStart);
        }
        try (DebugContext.Scope s0 = debug.scope("StubCompilation", graph, this.providers.getCodeCache());){
            Suites suites = this.createSuites();
            GraalCompiler.emitFrontEnd(this.providers, backend, graph, this.providers.getSuites().getDefaultGraphBuilderSuite(), OptimisticOptimizations.ALL, DefaultProfilingInfo.get((TriState)TriState.UNKNOWN), suites);
            LIRSuites lirSuites = this.createLIRSuites();
            backend.emitBackEnd(graph, this, this.getInstalledCodeOwner(), compResult, CompilationResultBuilderFactory.Default, null, this.getRegisterConfig(), lirSuites);
            assert (this.checkStubInvariants(compResult));
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        return compResult;
    }

    public CompilationIdentifier getStubCompilationId() {
        return new StubCompilationIdentifier(this);
    }

    private boolean checkStubInvariants(CompilationResult compResult) {
        assert (compResult.getExceptionHandlers().isEmpty()) : this;
        assert (compResult.getAssumptions() == null) : "stubs should not use assumptions: " + String.valueOf(this);
        for (DataPatch data : compResult.getDataPatches()) {
            HotSpotMetaspaceConstant c;
            ConstantReference ref;
            if (data.reference instanceof ConstantReference && (ref = (ConstantReference)data.reference).getConstant() instanceof HotSpotMetaspaceConstant && (c = (HotSpotMetaspaceConstant)ref.getConstant()).asResolvedJavaType() != null && c.asResolvedJavaType().getName().equals("[I")) continue;
            this.checkSafeDataReference(data);
        }
        for (Infopoint infopoint : compResult.getInfopoints()) {
            assert (infopoint instanceof Call) : String.valueOf(this) + " cannot have non-call infopoint: " + String.valueOf(infopoint);
            Call call = (Call)infopoint;
            assert (call.target instanceof HotSpotForeignCallLinkage) : String.valueOf(this) + " cannot have non runtime call: " + String.valueOf(call.target);
            HotSpotForeignCallLinkage callLinkage = (HotSpotForeignCallLinkage)call.target;
            assert (!callLinkage.isCompiledStub() || callLinkage.getDescriptor().equals(HotSpotHostBackend.DEOPT_BLOB_UNCOMMON_TRAP)) : String.valueOf(this) + " cannot call compiled stub " + String.valueOf(callLinkage);
        }
        return true;
    }

    protected void checkSafeDataReference(DataPatch data) {
        assert (!(data.reference instanceof ConstantReference)) : String.valueOf(this) + " cannot have embedded object or metadata constant: " + String.valueOf(data.reference);
    }

    protected Suites createSuites() {
        Suites defaultSuites = this.providers.getSuites().getDefaultSuites(this.options, this.providers.getLowerer().getTarget().arch).copy();
        PhaseSuite<HighTierContext> emptyHighTier = new PhaseSuite<HighTierContext>();
        emptyHighTier.appendPhase(new EmptyHighTier());
        defaultSuites.getMidTier().removeSubTypePhases(Speculative.class);
        defaultSuites.getLowTier().removeSubTypePhases(Speculative.class);
        return new Suites(emptyHighTier, defaultSuites.getMidTier(), defaultSuites.getLowTier());
    }

    protected LIRSuites createLIRSuites() {
        LIRSuites lirSuites = new LIRSuites(this.providers.getSuites().getDefaultLIRSuites(this.options));
        ListIterator<LIRPhase<PostAllocationOptimizationPhase.PostAllocationOptimizationContext>> moveProfiling = lirSuites.getPostAllocationOptimizationStage().findPhase(MoveProfilingPhase.class);
        if (moveProfiling != null) {
            moveProfiling.remove();
        }
        return lirSuites;
    }

    private static class EmptyHighTier
    extends BasePhase<HighTierContext> {
        private EmptyHighTier() {
        }

        @Override
        public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
            return ALWAYS_APPLICABLE;
        }

        @Override
        protected void run(StructuredGraph graph, HighTierContext context) {
        }

        @Override
        public void updateGraphState(GraphState graphState) {
            super.updateGraphState(graphState);
            if (graphState.isBeforeStage(GraphState.StageFlag.HIGH_TIER_LOWERING)) {
                graphState.setAfterStage(GraphState.StageFlag.HIGH_TIER_LOWERING);
            }
        }
    }
}

