/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.stubs;

import java.util.concurrent.atomic.AtomicLong;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.stubs.Stub;

public class StubCompilationIdentifier
implements CompilationIdentifier {
    private static final AtomicLong uniqueStubIds = new AtomicLong();
    private final long id = uniqueStubIds.getAndIncrement();
    private final Stub stub;

    public StubCompilationIdentifier(Stub stub) {
        this.stub = stub;
    }

    @Override
    public final String toString() {
        return this.toString(CompilationIdentifier.Verbosity.DETAILED);
    }

    @Override
    public String toString(CompilationIdentifier.Verbosity verbosity) {
        switch (verbosity) {
            case ID: {
                return this.buildID();
            }
            case NAME: {
                return this.buildName();
            }
            case DETAILED: {
                return this.buildID() + "[" + this.buildName() + "]";
            }
        }
        throw new GraalError("unknown verbosity: " + String.valueOf((Object)verbosity));
    }

    private String buildName() {
        return this.stub.toString();
    }

    private String buildID() {
        return "StubCompilation-" + this.id;
    }
}

