/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.java;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.ToIntFunction;
import jdk.graal.compiler.bytecode.Bytecode;
import jdk.graal.compiler.bytecode.BytecodeLookupSwitch;
import jdk.graal.compiler.bytecode.BytecodeStream;
import jdk.graal.compiler.bytecode.BytecodeSwitch;
import jdk.graal.compiler.bytecode.BytecodeTableSwitch;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.PermanentBailoutException;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.JavaMethodContext;
import jdk.graal.compiler.java.JsrNotSupportedBailout;
import jdk.graal.compiler.java.JsrScope;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;

public class BciBlockMapping
implements JavaMethodContext {
    protected static final int UNASSIGNED_ID = -1;
    private static final BitSet SHARED_EMPTY_BITSET = new BitSet();
    private static final Set<BciBlock> SHARED_EMPTY_BCIBLOCK_SET = Set.of();
    private BciBlock[] blocks;
    protected BciBlock[] blockMap;
    protected EconomicMap<Integer, BciBlock> branchTargetBlocksOOB;
    public final Bytecode code;
    public boolean hasJsrBytecodes;
    private boolean unresolvedExceptionHandlerReachability = false;
    protected final ExceptionHandler[] exceptionHandlers;
    protected BitSet[] bciExceptionHandlerIDs;
    private BciBlock startBlock;
    private BciBlock[] loopHeaders;
    private static final int LOOP_HEADER_MAX_CAPACITY = 4096;
    private static final int LOOP_HEADER_INITIAL_CAPACITY = 4;
    protected int blocksNotYetAssignedId;
    private final DebugContext debug;
    private int postJsrBlockCount;
    private int newDuplicateBlocks;
    private int duplicateBlocks;
    private final ArrayList<BciBlock> jsrVisited = new ArrayList();
    private int nextLoop;

    protected BciBlockMapping(Bytecode code, DebugContext debug) {
        this.code = code;
        this.debug = debug;
        this.exceptionHandlers = code.getExceptionHandlers().length != 0 ? code.getExceptionHandlers() : null;
        this.blockMap = new BciBlock[code.getCodeSize()];
    }

    public BciBlock[] getBlocks() {
        return this.blocks;
    }

    public BitSet getBciExceptionHandlerIDs(int bci) {
        assert (this.bciExceptionHandlerIDs != null);
        return this.bciExceptionHandlerIDs[bci];
    }

    public BciBlock getHandlerBlock(int handlerID) {
        int handlerBci = this.exceptionHandlers[handlerID].getHandlerBCI();
        assert (this.blockMap[handlerBci] != null);
        return this.blockMap[handlerBci];
    }

    public boolean bciUnique() {
        for (BciBlock block : this.blocks) {
            if (block.bciUnique()) continue;
            return false;
        }
        return true;
    }

    public void clearLivenessMetadata() {
        this.blockMap = null;
        this.bciExceptionHandlerIDs = null;
    }

    public void build(BytecodeStream stream, OptionValues options, boolean splitExceptionRanges) {
        this.computeBciExceptionHandlerIDs(stream);
        this.makeExceptionEntries(splitExceptionRanges);
        this.iterateOverBytecodes(stream);
        this.resolveExceptionHandlerReachability();
        this.startBlock = this.blockMap[0];
        if (this.debug.isDumpEnabled(2)) {
            this.debug.dump(2, this, this.code.getMethod().format("After iterateOverBytecodes %f %R %H.%n(%P)"));
        }
        if (this.hasJsrBytecodes) {
            if (!GraalOptions.SupportJsrBytecodes.getValue(options).booleanValue()) {
                throw new JsrNotSupportedBailout("jsr/ret parsing disabled");
            }
            this.createJsrAlternatives(this.startBlock);
            if (this.debug.isDumpEnabled(2)) {
                this.debug.dump(2, this, this.code.getMethod().format("After createJsrAlternatives %f %R %H.%n(%P)"));
            }
        }
        this.postJsrBlockCount = this.blocksNotYetAssignedId;
        if (this.debug.isLogEnabled()) {
            this.log(this.blockMap, "Before BlockOrder");
        }
        this.computeBlockOrder();
        if (this.debug.isDumpEnabled(2)) {
            this.debug.dump(2, this, this.code.getMethod().format("After computeBlockOrder %f %R %H.%n(%P)"));
        }
        assert (this.verify());
        if (this.debug.isLogEnabled()) {
            this.log(this.blockMap, "Before LivenessAnalysis");
        }
    }

    private void resolveExceptionHandlerReachability() {
        if (!this.unresolvedExceptionHandlerReachability) {
            return;
        }
        assert (this.exceptionHandlers != null) : "Cannot resolve exception handler reachability without exception handlers.";
        EconomicMap duplicates = EconomicMap.create();
        for (BciBlock b : this.blockMap) {
            if (b == null) continue;
            for (int i = 0; i < b.successors.size(); ++i) {
                BciBlock sux = b.successors.get(i);
                if (!sux.isExceptionEntry) continue;
                BciBlock dup = (BciBlock)duplicates.get((Object)sux);
                if (dup == null) {
                    dup = sux.duplicateAsNoExceptionHandlerEntry();
                    duplicates.put((Object)sux, (Object)dup);
                    ++this.blocksNotYetAssignedId;
                }
                b.successors.set(i, dup);
                if (duplicates.get((Object)b) == null) continue;
                ((BciBlock)duplicates.get((Object)b)).successors.set(i, dup);
            }
        }
    }

    protected boolean verify() {
        for (BciBlock block : this.blocks) {
            BciBlock idBlock = this.blocks[block.getId()];
            assert (idBlock == block) : "Id block must match block " + Assertions.errorMessageContext("idBlock", idBlock, "block", block);
            for (int i = 0; i < block.getSuccessorCount(); ++i) {
                BciBlock sux = block.getSuccessor(i);
                if (sux instanceof ExceptionDispatchBlock) assert (i == block.getSuccessorCount() - 1) : "Only one exception handler allowed, and it must be last in successors list";
            }
        }
        return true;
    }

    private void computeBciExceptionHandlerIDs(BytecodeStream stream) {
        if (this.exceptionHandlers == null) {
            return;
        }
        this.bciExceptionHandlerIDs = new BitSet[this.code.getCodeSize()];
        stream.setBCI(0);
        while (stream.currentBC() != 256) {
            int bci = stream.currentBCI();
            this.bciExceptionHandlerIDs[bci] = SHARED_EMPTY_BITSET;
            stream.next();
        }
        for (int handlerID = this.exceptionHandlers.length - 1; handlerID >= 0; --handlerID) {
            ExceptionHandler h = this.exceptionHandlers[handlerID];
            for (int bci = h.getStartBCI(); bci < h.getEndBCI(); ++bci) {
                BitSet currentIDs = this.bciExceptionHandlerIDs[bci];
                if (currentIDs == null) continue;
                if (currentIDs == SHARED_EMPTY_BITSET) {
                    this.bciExceptionHandlerIDs[bci] = currentIDs = new BitSet();
                }
                if (h.isCatchAll()) {
                    currentIDs.clear();
                }
                currentIDs.set(handlerID);
            }
        }
    }

    private int findConcreteBci(int bci) {
        assert (this.bciExceptionHandlerIDs != null);
        for (int current = bci; current < this.bciExceptionHandlerIDs.length; ++current) {
            if (this.bciExceptionHandlerIDs[current] == null) continue;
            return current;
        }
        return this.bciExceptionHandlerIDs.length;
    }

    protected BciBlock startNewBlock(int bci) {
        return this.makeBlock(bci);
    }

    protected Set<BciBlock> makeExceptionEntries(boolean splitRanges) {
        if (this.exceptionHandlers == null) {
            return SHARED_EMPTY_BCIBLOCK_SET;
        }
        HashSet<BciBlock> requestedBlockStarts = new HashSet<BciBlock>();
        for (int i = 0; i < this.exceptionHandlers.length; ++i) {
            ExceptionHandler h = this.exceptionHandlers[i];
            BciBlock xhandler = this.startNewBlock(h.getHandlerBCI());
            xhandler.setIsExceptionEntry();
            requestedBlockStarts.add(xhandler);
            if (!splitRanges) continue;
            int startBci = this.findConcreteBci(h.getStartBCI());
            assert (startBci < this.bciExceptionHandlerIDs.length) : Assertions.errorMessageContext("startBCI", startBci, "bciExcpHandlers", this.bciExceptionHandlerIDs);
            requestedBlockStarts.add(this.startNewBlock(startBci));
            int endBci = this.findConcreteBci(h.getEndBCI());
            if (endBci >= this.bciExceptionHandlerIDs.length) continue;
            requestedBlockStarts.add(this.startNewBlock(endBci));
        }
        return requestedBlockStarts;
    }

    protected boolean isStartOfNewBlock(BciBlock current, int bci) {
        return current == null || this.blockMap[bci] != null;
    }

    protected BciBlock getInstructionBlock(int bci) {
        assert (this.blockMap[bci].isInstructionBlock());
        return this.blockMap[bci];
    }

    private void iterateOverBytecodes(BytecodeStream stream) {
        BciBlock current = null;
        stream.setBCI(0);
        while (stream.currentBC() != 256) {
            int bci = stream.currentBCI();
            if (this.isStartOfNewBlock(current, bci)) {
                BciBlock b = this.makeBlock(bci);
                if (current != null) {
                    this.addSuccessor(current.getEndBci(), b);
                }
                current = b;
            }
            this.blockMap[bci] = current;
            current = this.getInstructionBlock(bci);
            current.setEndBci(bci);
            switch (stream.currentBC()) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    current = null;
                    break;
                }
                case 191: {
                    current = null;
                    ExceptionDispatchBlock handler = this.handleExceptions(bci, true, false);
                    if (handler == null) break;
                    this.addSuccessor(bci, handler);
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    current = null;
                    this.addSuccessor(bci, this.makeBlock(stream.readBranchDest()));
                    this.addSuccessor(bci, this.makeBlock(stream.nextBCI()));
                    break;
                }
                case 167: 
                case 200: {
                    current = null;
                    this.addSuccessor(bci, this.makeBlock(stream.readBranchDest()));
                    break;
                }
                case 170: {
                    current = null;
                    this.addSwitchSuccessors(bci, new BytecodeTableSwitch(stream, bci));
                    break;
                }
                case 171: {
                    current = null;
                    this.addSwitchSuccessors(bci, new BytecodeLookupSwitch(stream, bci));
                    break;
                }
                case 168: 
                case 201: {
                    this.hasJsrBytecodes = true;
                    int target = stream.readBranchDest();
                    if (target == 0) {
                        throw new JsrNotSupportedBailout("jsr target bci 0 not allowed");
                    }
                    BciBlock b1 = this.makeBlock(target);
                    current.setJsrSuccessor(b1);
                    current.setJsrReturnBci(stream.nextBCI());
                    current = null;
                    this.addSuccessor(bci, b1);
                    break;
                }
                case 169: {
                    current.setEndsWithRet();
                    current = null;
                    break;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: {
                    current = null;
                    this.addInvokeNormalSuccessor(bci, this.makeBlock(stream.nextBCI()));
                    ExceptionDispatchBlock handler = this.handleExceptions(bci, true, true);
                    if (handler == null) break;
                    this.addSuccessor(bci, handler);
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 108: 
                case 109: 
                case 112: 
                case 113: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 192: 
                case 193: 
                case 194: 
                case 197: {
                    ExceptionDispatchBlock handler = this.handleExceptions(bci, true, false);
                    if (handler == null) break;
                    current = null;
                    this.addSuccessor(bci, this.makeBlock(stream.nextBCI()));
                    this.addSuccessor(bci, handler);
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 110: 
                case 111: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 195: {
                    break;
                }
                default: {
                    throw new GraalError("Unhandled bytecode");
                }
            }
            stream.next();
        }
    }

    protected BciBlock processNewBciBlock(int bci, BciBlock newBlock) {
        return newBlock;
    }

    private BciBlock makeBlock(int startBci) {
        if (startBci >= this.blockMap.length) {
            BciBlock block;
            if (this.branchTargetBlocksOOB == null) {
                this.branchTargetBlocksOOB = EconomicMap.create();
            }
            if ((block = (BciBlock)this.branchTargetBlocksOOB.get((Object)startBci)) == null) {
                block = new BciBlock(startBci);
                block.outOfBounds = true;
                this.branchTargetBlocksOOB.put((Object)startBci, (Object)block);
            }
            return block;
        }
        BciBlock oldBlock = this.blockMap[startBci];
        if (oldBlock == null) {
            BciBlock newBlock = new BciBlock(startBci);
            ++this.blocksNotYetAssignedId;
            this.blockMap[startBci] = newBlock;
            return this.processNewBciBlock(startBci, newBlock);
        }
        if (oldBlock.startBci != startBci) {
            assert (oldBlock.isInstructionBlock());
            BciBlock newBlock = new BciBlock(startBci);
            ++this.blocksNotYetAssignedId;
            newBlock.setEndBci(oldBlock.getEndBci());
            for (BciBlock oldSuccessor : oldBlock.getSuccessors()) {
                newBlock.addSuccessor(oldSuccessor);
            }
            oldBlock.setEndBci(startBci - 1);
            oldBlock.clearSucccessors();
            oldBlock.addSuccessor(newBlock);
            for (int i = startBci; i <= newBlock.getEndBci(); ++i) {
                this.blockMap[i] = newBlock;
            }
            return newBlock;
        }
        return oldBlock;
    }

    private void addSwitchSuccessors(int predBci, BytecodeSwitch bswitch) {
        TreeSet<Integer> targets = new TreeSet<Integer>();
        for (int i = 0; i < bswitch.numberOfCases(); ++i) {
            targets.add(bswitch.targetAt(i));
        }
        targets.add(bswitch.defaultTarget());
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            int targetBci = (Integer)iterator.next();
            this.addSuccessor(predBci, this.makeBlock(targetBci));
        }
    }

    private void addSuccessor(int predBci, BciBlock sux) {
        BciBlock predecessor = this.getInstructionBlock(predBci);
        if (sux.isExceptionEntry()) {
            this.unresolvedExceptionHandlerReachability = true;
        }
        predecessor.addSuccessor(sux);
    }

    protected void addInvokeNormalSuccessor(int invokeBci, BciBlock sux) {
        this.addSuccessor(invokeBci, sux);
    }

    private void createJsrAlternatives(BciBlock block) {
        this.jsrVisited.add(block);
        JsrScope scope = block.getJsrScope();
        if (block.endsWithRet()) {
            block.setRetSuccessor(this.blockMap[scope.nextReturnAddress()]);
            block.addSuccessor(block.getRetSuccessor());
            assert (block.getRetSuccessor() != block.getJsrSuccessor()) : Assertions.errorMessageContext("block", block, "block.retSucc", block.getRetSuccessor(), "lock.jsrSucc", block.getJsrSuccessor());
        }
        this.debug.log("JSR alternatives block %s  sux %s  jsrSux %s  retSux %s  jsrScope %s", block, block.getSuccessors(), (Object)block.getJsrSuccessor(), (Object)block.getRetSuccessor(), (Object)block.getJsrScope());
        if (block.getJsrSuccessor() != null || !scope.isEmpty()) {
            for (int i = 0; i < block.getSuccessorCount(); ++i) {
                BciBlock clone;
                BciBlock successor = block.getSuccessor(i);
                JsrScope nextScope = scope;
                if (successor == block.getJsrSuccessor()) {
                    nextScope = scope.push(block.getJsrReturnBci(), successor);
                }
                if (successor == block.getRetSuccessor()) {
                    nextScope = scope.pop();
                }
                if (!successor.getJsrScope().isPrefixOf(nextScope)) {
                    throw new JsrNotSupportedBailout("unstructured control flow  (" + String.valueOf(successor.getJsrScope()) + " " + String.valueOf(nextScope) + ")");
                }
                if (nextScope.isEmpty()) continue;
                if (successor.getJsrAlternatives() != null && successor.getJsrAlternatives().containsKey((Object)nextScope)) {
                    clone = (BciBlock)successor.getJsrAlternatives().get((Object)nextScope);
                } else {
                    successor.initJsrAlternatives();
                    clone = successor.copy();
                    ++this.blocksNotYetAssignedId;
                    clone.setJsrScope(nextScope);
                    successor.getJsrAlternatives().put((Object)nextScope, (Object)clone);
                }
                block.getSuccessors().set(i, clone);
                if (successor == block.getJsrSuccessor()) {
                    block.setJsrSuccessor(clone);
                }
                if (successor != block.getRetSuccessor()) continue;
                block.setRetSuccessor(clone);
            }
        }
        for (BciBlock successor : block.getSuccessors()) {
            if (this.jsrVisited.contains(successor) || !BciBlockMapping.shouldFollowEdge(successor, scope)) continue;
            this.createJsrAlternatives(successor);
        }
    }

    private static boolean shouldFollowEdge(BciBlock successor, JsrScope scope) {
        if (successor instanceof ExceptionDispatchBlock && scope.getJsrEntryBlock() != null) {
            ExceptionDispatchBlock exceptionDispatchBlock = (ExceptionDispatchBlock)successor;
            int bci = scope.getJsrEntryBlock().startBci;
            if (exceptionDispatchBlock.handler.getStartBCI() < bci && bci < exceptionDispatchBlock.handler.getEndBCI()) {
                return false;
            }
        }
        return true;
    }

    protected ExceptionDispatchBlock processNewExceptionDispatchBlock(int bci, boolean isInvoke, ExceptionDispatchBlock handler) {
        return handler;
    }

    protected ExceptionDispatchBlock handleExceptions(int bci, boolean processNewBlock, boolean isInvoke) {
        ExceptionDispatchBlock lastHandler = null;
        if (this.exceptionHandlers != null) {
            int dispatchBlocks = 0;
            BitSet handlerIDs = this.getBciExceptionHandlerIDs(bci);
            assert (handlerIDs != null) : "missing handlers for bci";
            int handlerID = handlerIDs.length();
            while ((handlerID = handlerIDs.previousSetBit(handlerID - 1)) >= 0) {
                if (!handlerIDs.get(handlerID)) continue;
                ExceptionDispatchBlock curHandler = new ExceptionDispatchBlock(this.exceptionHandlers[handlerID], bci);
                ++dispatchBlocks;
                curHandler.addSuccessor(this.getHandlerBlock(handlerID));
                if (lastHandler != null) {
                    curHandler.addSuccessor(lastHandler);
                }
                lastHandler = curHandler;
            }
            this.blocksNotYetAssignedId += dispatchBlocks;
        }
        if (processNewBlock) {
            return this.processNewExceptionDispatchBlock(bci, isInvoke, lastHandler);
        }
        return lastHandler;
    }

    private void computeBlockOrder() {
        int maxBlocks = this.blocksNotYetAssignedId;
        this.blocks = new BciBlock[this.blocksNotYetAssignedId];
        this.computeBlockOrder(this.blockMap[0]);
        int duplicatedBlocks = this.newDuplicateBlocks + this.duplicateBlocks;
        if (duplicatedBlocks > 0) {
            this.debug.log(2, "Duplicated %d blocks. Original block count: %d", duplicatedBlocks, this.postJsrBlockCount);
        }
        int blockCount = maxBlocks - this.blocksNotYetAssignedId + 1 + this.duplicateBlocks;
        BciBlock[] newBlocks = new BciBlock[blockCount];
        int next = 0;
        for (int i = 0; i < this.blocks.length; ++i) {
            BciBlock b = this.blocks[i];
            if (b == null) continue;
            b.setId(next);
            newBlocks[next++] = b;
            if (!b.isLoopHeader) continue;
            next = this.handleLoopHeader(newBlocks, next, i, b);
        }
        assert (next == newBlocks.length - 1) : Assertions.errorMessageContext("nextId", next, "newBlocks.length", newBlocks.length);
        ExceptionDispatchBlock unwindBlock = new ExceptionDispatchBlock(-4);
        unwindBlock.setId(newBlocks.length - 1);
        newBlocks[newBlocks.length - 1] = unwindBlock;
        this.blocks = newBlocks;
    }

    private int handleLoopHeader(BciBlock[] newBlocks, int nextStart, int i, BciBlock loopHeader) {
        int next = nextStart;
        for (int j = i + 1; j < this.blocks.length; ++j) {
            BciBlock other = this.blocks[j];
            if (other == null || !other.loops.get(loopHeader.loopId)) continue;
            other.setId(next);
            newBlocks[next++] = other;
            this.blocks[j] = null;
            if (!other.isLoopHeader) continue;
            next = this.handleLoopHeader(newBlocks, next, j, other);
        }
        return next;
    }

    public void log(BciBlock[] blockArray, String name) {
        if (this.debug.isLogEnabled()) {
            this.debug.log("%sBlockMap %s: %n%s", (Object)this.debug.getCurrentScopeName(), (Object)name, (Object)BciBlockMapping.toString(blockArray, this.loopHeaders));
        }
    }

    public static String toString(BciBlock[] blockMap, BciBlock[] loopHeadersMap) {
        if (blockMap == null) {
            return "no blockmap";
        }
        StringBuilder sb = new StringBuilder();
        HashMap debugIds = new HashMap();
        int[] nextDebugId = new int[]{-2};
        ToIntFunction<BciBlock> getId = b -> {
            int id = b.getId();
            if (id < 0) {
                id = debugIds.computeIfAbsent(b, bb -> {
                    int n = nextDebugId[0];
                    nextDebugId[0] = n - 1;
                    return n;
                });
            }
            return id;
        };
        for (BciBlock b2 : blockMap) {
            if (b2 == null) continue;
            sb.append("B").append(getId.applyAsInt(b2)).append("[").append(b2.startBci).append("..").append(b2.getEndBci()).append("]");
            if (b2.isLoopHeader) {
                sb.append(" LoopHeader");
            }
            if (b2.isExceptionEntry()) {
                sb.append(" ExceptionEntry");
            }
            if (b2 instanceof ExceptionDispatchBlock) {
                sb.append(" ExceptionDispatch");
            }
            if (!b2.successors.isEmpty()) {
                sb.append(" Successors=[");
                for (BciBlock s : b2.getSuccessors()) {
                    if (sb.charAt(sb.length() - 1) != '[') {
                        sb.append(", ");
                    }
                    sb.append("B").append(getId.applyAsInt(s));
                }
                sb.append("]");
            }
            if (!b2.loops.isEmpty() && loopHeadersMap != null) {
                sb.append(" Loops=[");
                int pos = -1;
                while ((pos = b2.loops.nextSetBit(pos + 1)) >= 0) {
                    if (sb.charAt(sb.length() - 1) != '[') {
                        sb.append(", ");
                    }
                    sb.append("B").append(getId.applyAsInt(loopHeadersMap[pos]));
                }
                sb.append("]");
            }
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    public String toString() {
        return BciBlockMapping.toString(this.blocks, this.loopHeaders);
    }

    public BciBlock getLoopHeader(int index) {
        return this.loopHeaders[index];
    }

    private static int nextPowerOfTwo(int value) {
        assert (NumUtil.assertNonNegativeInt(value));
        return 1 << 32 - Integer.numberOfLeadingZeros(value);
    }

    private void makeLoopHeader(BciBlock block) {
        assert (!block.isLoopHeader);
        block.isLoopHeader = true;
        if (this.nextLoop >= 4096) {
            throw new PermanentBailoutException("Too many loops in method");
        }
        block.loops.set(this.nextLoop);
        this.debug.log("makeLoopHeader(%s) -> %s", (Object)block, (Object)block.loops);
        if (this.loopHeaders == null) {
            this.loopHeaders = new BciBlock[Math.max(BciBlockMapping.nextPowerOfTwo(this.nextLoop), 4)];
        } else if (this.nextLoop >= this.loopHeaders.length) {
            int newLength = BciBlockMapping.nextPowerOfTwo(this.nextLoop);
            this.loopHeaders = Arrays.copyOf(this.loopHeaders, newLength);
        }
        this.loopHeaders[this.nextLoop] = block;
        block.loopId = this.nextLoop++;
    }

    private void propagateLoopBits(TraversalStep step, BitSet loopBits) {
        TraversalStep s = step;
        while (s != null) {
            BitSet missingLoops = (BitSet)loopBits.clone();
            missingLoops.andNot(s.block.loops);
            if (missingLoops.isEmpty()) break;
            s.block.loops.or(missingLoops);
            if (s.block.loopIdChain != null) {
                for (TraversalStep chain : s.block.loopIdChain) {
                    this.propagateLoopBits(chain, loopBits);
                }
            }
            s = s.pred;
        }
    }

    private void computeBlockOrder(BciBlock initialBlock) {
        ArrayDeque<TraversalStep> workStack = new ArrayDeque<TraversalStep>();
        workStack.push(new TraversalStep(initialBlock));
        while (!workStack.isEmpty()) {
            TraversalStep step = (TraversalStep)workStack.peek();
            BciBlock block = step.block;
            if (step.currentSuccessorIndex == 0) {
                block.visited = true;
                block.active = true;
            }
            if (step.currentSuccessorIndex < block.successors.size()) {
                BciBlock successor = block.getSuccessors().get(step.currentSuccessorIndex);
                if (step instanceof DuplicationTraversalStep) {
                    DuplicationTraversalStep duplicationStep = (DuplicationTraversalStep)step;
                    BciBlock targetHeader = duplicationStep.loopHeader;
                    if (successor != targetHeader && successor.loops.get(targetHeader.loopId)) {
                        BciBlock duplicate = (BciBlock)duplicationStep.duplicationMap.get((Object)successor);
                        if (duplicate == null) {
                            duplicate = successor.duplicate();
                            ++this.newDuplicateBlocks;
                            duplicationStep.duplicationMap.put((Object)successor, (Object)duplicate);
                        }
                        successor = duplicate;
                        ++successor.predecessorCount;
                        block.successors.set(step.currentSuccessorIndex, successor);
                    } else {
                        this.debug.dump(4, (Object)this, "Exiting duplication @ %s", successor);
                        this.debug.log("Exiting duplication @ %s", successor);
                        ++successor.predecessorCount;
                    }
                }
                if (successor.visited) {
                    BitSet loopBits;
                    boolean duplicationStarted = false;
                    if (successor.active) {
                        if (!successor.isLoopHeader) {
                            this.makeLoopHeader(successor);
                        }
                        loopBits = (BitSet)successor.loops.clone();
                    } else {
                        loopBits = (BitSet)successor.loops.clone();
                        if (successor.isLoopHeader) {
                            loopBits.clear(successor.loopId);
                        }
                        BitSet checkBits = loopBits;
                        int outermostInactiveLoopId = -1;
                        int pos = -1;
                        while ((pos = checkBits.nextSetBit(pos + 1)) >= 0) {
                            int id = pos;
                            if (this.loopHeaders[id].active) continue;
                            if (Options.MaxDuplicationFactor.getValue(this.debug.getOptions()) <= 1.0) {
                                throw new PermanentBailoutException("Irreducible");
                            }
                            if (outermostInactiveLoopId != -1 && this.loopHeaders[id].loops.get(outermostInactiveLoopId)) continue;
                            outermostInactiveLoopId = id;
                        }
                        if (outermostInactiveLoopId != -1) {
                            assert (!(step instanceof DuplicationTraversalStep)) : step;
                            --successor.predecessorCount;
                            BciBlock duplicate = successor.duplicate();
                            ++duplicate.predecessorCount;
                            block.successors.set(step.currentSuccessorIndex, duplicate);
                            DuplicationTraversalStep duplicationStep = new DuplicationTraversalStep(step, duplicate, this.loopHeaders[outermostInactiveLoopId]);
                            workStack.push(duplicationStep);
                            this.debug.log("Starting duplication @ %s", duplicate);
                            this.debug.dump(4, (Object)this, "Starting duplication @ %s", duplicate);
                            duplicationStep.duplicationMap.put((Object)successor, (Object)duplicate);
                            ++this.newDuplicateBlocks;
                            duplicationStarted = true;
                        }
                    }
                    if (!duplicationStarted) {
                        this.propagateLoopBits(step, loopBits);
                        if (successor.loopIdChain == null) {
                            successor.loopIdChain = new ArrayList<TraversalStep>(2);
                        }
                        successor.loopIdChain.add(step);
                        this.debug.dump(4, (Object)this, "After re-reaching %s", successor);
                    }
                } else if (step instanceof DuplicationTraversalStep) {
                    workStack.push(new DuplicationTraversalStep((DuplicationTraversalStep)step, successor));
                } else {
                    workStack.push(new TraversalStep(step, successor));
                }
                ++step.currentSuccessorIndex;
                continue;
            }
            block.active = false;
            assert (this.checkBlocks(this.blocksNotYetAssignedId, block));
            --this.blocksNotYetAssignedId;
            if (this.blocksNotYetAssignedId < 0) {
                OptionValues options = this.debug.getOptions();
                double factor = Options.MaxDuplicationFactor.getValue(options);
                this.duplicateBlocks += this.newDuplicateBlocks;
                if ((double)this.duplicateBlocks > (double)this.postJsrBlockCount * factor) {
                    throw new PermanentBailoutException("Non-reducible loop requires too much duplication. Setting " + Options.MaxDuplicationFactor.getName() + " to a value higher than " + factor + " may resolve this.");
                }
                this.debug.log(2, "Re-numbering blocks to make room for duplicates (old length: %d; new blocks: %d)", this.blocks.length, this.newDuplicateBlocks);
                BciBlock[] newBlocks = new BciBlock[this.blocks.length + this.newDuplicateBlocks];
                for (int i = 0; i < this.blocks.length; ++i) {
                    newBlocks[i + this.newDuplicateBlocks] = this.blocks[i];
                    int id = this.blocks[i].id;
                    assert (id == -1) : id;
                }
                this.blocksNotYetAssignedId += this.newDuplicateBlocks;
                assert (NumUtil.assertNonNegativeInt(this.blocksNotYetAssignedId));
                this.newDuplicateBlocks = 0;
                this.blocks = newBlocks;
            }
            this.blocks[this.blocksNotYetAssignedId] = block;
            this.debug.log("computeBlockOrder(%s) -> %s", (Object)block, (Object)block.loops);
            this.debug.dump(4, (Object)this, "After adding %s", block);
            workStack.pop();
        }
        BitSet loops = (BitSet)initialBlock.loops.clone();
        if (initialBlock.isLoopHeader) {
            loops.clear(initialBlock.loopId);
        }
        GraalError.guarantee(loops.isEmpty(), "Irreducible loops should already have been detected to duplicated");
    }

    private boolean checkBlocks(int start, BciBlock inserting) {
        for (int i = 0; i < start; ++i) {
            assert (this.blocks[i] == null);
        }
        EconomicSet seen = EconomicSet.create((int)(this.blocks.length - start));
        for (int i = start; i < this.blocks.length; ++i) {
            assert (this.blocks[i] != null);
            assert (seen.add((Object)this.blocks[i]));
        }
        assert (!seen.contains((Object)inserting)) : "Trying to add " + String.valueOf(inserting) + " again";
        return true;
    }

    public static BciBlockMapping create(BytecodeStream stream, Bytecode code, OptionValues options, DebugContext debug, boolean hasAsyncExceptions) {
        BciBlockMapping map = new BciBlockMapping(code, debug);
        BciBlockMapping.buildMap(stream, code, options, debug, map, hasAsyncExceptions);
        return map;
    }

    protected static void buildMap(BytecodeStream stream, Bytecode code, OptionValues options, DebugContext debug, BciBlockMapping map, boolean splitExceptionRanges) {
        try (DebugContext.Scope scope = debug.scope((Object)"BciBlockMapping", map);){
            map.build(stream, options, splitExceptionRanges);
            if (debug.isDumpEnabled(2)) {
                debug.dump(2, map, code.getMethod().format("After block building %f %R %H.%n(%P)"));
            }
        }
        catch (Throwable t) {
            throw debug.handle(t);
        }
    }

    public BciBlock[] getLoopHeaders() {
        return this.loopHeaders;
    }

    public BciBlock getStartBlock() {
        return this.startBlock;
    }

    public ExceptionDispatchBlock getUnwindBlock() {
        return (ExceptionDispatchBlock)this.blocks[this.blocks.length - 1];
    }

    public int getLoopCount() {
        return this.nextLoop;
    }

    public int getBlockCount() {
        return this.blocks.length;
    }

    @Override
    public JavaMethod asJavaMethod() {
        return this.code.getMethod();
    }

    public static class BciBlock
    implements Cloneable {
        int id = -1;
        final int startBci;
        private int endBci;
        private boolean isExceptionEntry;
        private boolean isLoopHeader;
        int loopId;
        List<BciBlock> successors;
        private int predecessorCount;
        private boolean visited;
        private boolean active;
        BitSet loops;
        JSRData jsrData;
        List<TraversalStep> loopIdChain;
        boolean duplicate;
        private boolean outOfBounds;

        public BciBlock(int startBci) {
            this.startBci = startBci;
            this.successors = new ArrayList<BciBlock>();
            this.loops = new BitSet();
        }

        protected BciBlock(int startBci, int endBci) {
            this(startBci);
            this.endBci = endBci;
        }

        public boolean bciUnique() {
            return this.jsrData == null && !this.duplicate;
        }

        public int getStartBci() {
            return this.startBci;
        }

        public int getEndBci() {
            return this.endBci;
        }

        public void setEndBci(int bci) {
            this.endBci = bci;
        }

        public BitSet getLoops() {
            return this.loops;
        }

        public BciBlock exceptionDispatchBlock() {
            if (this.successors.size() > 0 && this.successors.get(this.successors.size() - 1) instanceof ExceptionDispatchBlock) {
                return this.successors.get(this.successors.size() - 1);
            }
            return null;
        }

        public int getId() {
            return this.id;
        }

        public int getPredecessorCount() {
            return this.predecessorCount;
        }

        public int numNormalSuccessors() {
            if (this.exceptionDispatchBlock() != null) {
                return this.successors.size() - 1;
            }
            return this.successors.size();
        }

        public BciBlock copy() {
            try {
                BciBlock block = (BciBlock)super.clone();
                if (block.jsrData != null) {
                    block.jsrData = block.jsrData.copy();
                }
                block.successors = new ArrayList<BciBlock>(this.successors);
                block.loops = (BitSet)block.loops.clone();
                return block;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public BciBlock duplicate() {
            try {
                BciBlock block = (BciBlock)super.clone();
                if (block.jsrData != null) {
                    throw new PermanentBailoutException("Can not duplicate block with JSR data");
                }
                block.successors = new ArrayList<BciBlock>(this.successors);
                block.loops = new BitSet();
                block.loopId = 0;
                block.id = -1;
                block.isLoopHeader = false;
                block.visited = false;
                block.active = false;
                block.predecessorCount = 0;
                block.loopIdChain = null;
                block.duplicate = true;
                return block;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        private BciBlock duplicateAsNoExceptionHandlerEntry() {
            BciBlock dup = this.duplicate();
            dup.isExceptionEntry = false;
            return dup;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("B").append(this.getId());
            sb.append('[').append(this.startBci).append("..").append(this.endBci);
            if (this.isLoopHeader || this.isExceptionEntry || this instanceof ExceptionDispatchBlock) {
                sb.append(' ');
                if (this.isLoopHeader) {
                    sb.append('L');
                }
                if (this.isExceptionEntry) {
                    sb.append('!');
                } else if (this instanceof ExceptionDispatchBlock) {
                    sb.append("<!>");
                }
            }
            sb.append(']');
            if (this.duplicate) {
                sb.append(" (duplicate)");
            }
            return sb.toString();
        }

        public boolean isLoopHeader() {
            return this.isLoopHeader;
        }

        public boolean isExceptionEntry() {
            return this.isExceptionEntry;
        }

        public void setIsExceptionEntry() {
            this.isExceptionEntry = true;
        }

        public BciBlock getSuccessor(int index) {
            return this.successors.get(index);
        }

        public int getLoopId() {
            return this.loopId;
        }

        public boolean isDuplicate() {
            return this.duplicate;
        }

        private JSRData getOrCreateJSRData() {
            if (this.jsrData == null) {
                this.jsrData = new JSRData();
            }
            return this.jsrData;
        }

        void setEndsWithRet() {
            this.getOrCreateJSRData().endsWithRet = true;
        }

        public JsrScope getJsrScope() {
            if (this.jsrData == null) {
                return JsrScope.EMPTY_SCOPE;
            }
            return this.jsrData.jsrScope;
        }

        public boolean endsWithRet() {
            if (this.jsrData == null) {
                return false;
            }
            return this.jsrData.endsWithRet;
        }

        void setRetSuccessor(BciBlock bciBlock) {
            this.getOrCreateJSRData().retSuccessor = bciBlock;
        }

        public BciBlock getRetSuccessor() {
            if (this.jsrData == null) {
                return null;
            }
            return this.jsrData.retSuccessor;
        }

        public BciBlock getJsrSuccessor() {
            if (this.jsrData == null) {
                return null;
            }
            return this.jsrData.jsrSuccessor;
        }

        public int getJsrReturnBci() {
            if (this.jsrData == null) {
                return -1;
            }
            return this.jsrData.jsrReturnBci;
        }

        public EconomicMap<JsrScope, BciBlock> getJsrAlternatives() {
            if (this.jsrData == null) {
                return null;
            }
            return this.jsrData.jsrAlternatives;
        }

        public void initJsrAlternatives() {
            JSRData data = this.getOrCreateJSRData();
            if (data.jsrAlternatives == null) {
                data.jsrAlternatives = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
            }
        }

        void setJsrScope(JsrScope nextScope) {
            this.getOrCreateJSRData().jsrScope = nextScope;
        }

        void setJsrSuccessor(BciBlock clone) {
            this.getOrCreateJSRData().jsrSuccessor = clone;
        }

        void setJsrReturnBci(int bci) {
            this.getOrCreateJSRData().jsrReturnBci = bci;
        }

        public int getSuccessorCount() {
            return this.successors.size();
        }

        public List<BciBlock> getSuccessors() {
            return this.successors;
        }

        void setId(int i) {
            this.id = i;
        }

        public void addSuccessor(BciBlock sux) {
            this.successors.add(sux);
            ++sux.predecessorCount;
        }

        public void clearSucccessors() {
            for (BciBlock sux : this.successors) {
                --sux.predecessorCount;
            }
            this.successors.clear();
        }

        public boolean isInstructionBlock() {
            return true;
        }

        public void getDebugProperties(Map<String, ? super Object> properties) {
            properties.put("assignedId", (Object)this.getId());
            properties.put("startBci", (Object)this.getStartBci());
            properties.put("endBci", (Object)this.getEndBci());
            properties.put("isExceptionEntry", (Object)this.isExceptionEntry());
            properties.put("isLoopHeader", (Object)this.isLoopHeader());
            properties.put("loopId", (Object)this.getLoopId());
            properties.put("loops", this.getLoops());
            properties.put("predecessorCount", (Object)this.getPredecessorCount());
            properties.put("active", (Object)this.active);
            properties.put("visited", (Object)this.visited);
            properties.put("duplicate", (Object)this.duplicate);
        }

        public boolean isOutOfBounds() {
            return this.outOfBounds;
        }

        public static class JSRData
        implements Cloneable {
            public EconomicMap<JsrScope, BciBlock> jsrAlternatives;
            public JsrScope jsrScope = JsrScope.EMPTY_SCOPE;
            public BciBlock jsrSuccessor;
            public int jsrReturnBci;
            public BciBlock retSuccessor;
            public boolean endsWithRet = false;

            public JSRData copy() {
                try {
                    return (JSRData)this.clone();
                }
                catch (CloneNotSupportedException e) {
                    return null;
                }
            }
        }
    }

    public static class ExceptionDispatchBlock
    extends BciBlock {
        public final ExceptionHandler handler;
        public final int deoptBci;

        protected ExceptionDispatchBlock(ExceptionHandler handler, int deoptBci) {
            super(handler.getHandlerBCI(), handler.getHandlerBCI());
            this.deoptBci = deoptBci;
            this.handler = handler;
        }

        protected ExceptionDispatchBlock(int deoptBci) {
            super(deoptBci, deoptBci);
            this.deoptBci = deoptBci;
            this.handler = null;
        }

        @Override
        public void setEndBci(int bci) {
            throw GraalError.unimplementedOverride();
        }

        @Override
        public void setIsExceptionEntry() {
            throw GraalError.shouldNotReachHere("Dispatch block cannot be exception entry.");
        }

        @Override
        public boolean isInstructionBlock() {
            return false;
        }

        @Override
        public void getDebugProperties(Map<String, ? super Object> properties) {
            super.getDebugProperties(properties);
            properties.put("deoptBci", (Object)this.deoptBci);
            if (this.handler != null) {
                properties.put("catch type", this.handler.getCatchType());
            }
        }
    }

    private static class TraversalStep {
        private final TraversalStep pred;
        private final BciBlock block;
        private int currentSuccessorIndex;

        TraversalStep(TraversalStep pred, BciBlock block) {
            this.pred = pred;
            this.block = block;
            this.currentSuccessorIndex = 0;
        }

        TraversalStep(BciBlock block) {
            this(null, block);
        }

        public String toString() {
            if (this.pred == null) {
                return "TraversalStep{block=" + String.valueOf(this.block) + ", currentSuccessorIndex=" + this.currentSuccessorIndex + "}";
            }
            return "TraversalStep{pred=" + String.valueOf(this.pred) + ", block=" + String.valueOf(this.block) + ", currentSuccessorIndex=" + this.currentSuccessorIndex + "}";
        }
    }

    private static final class DuplicationTraversalStep
    extends TraversalStep {
        private final BciBlock loopHeader;
        private final EconomicMap<BciBlock, BciBlock> duplicationMap;

        DuplicationTraversalStep(TraversalStep pred, BciBlock block, BciBlock loopHeader) {
            super(pred, block);
            this.loopHeader = loopHeader;
            this.duplicationMap = EconomicMap.create();
        }

        DuplicationTraversalStep(DuplicationTraversalStep pred, BciBlock block) {
            super(pred, block);
            this.loopHeader = pred.loopHeader;
            this.duplicationMap = pred.duplicationMap;
        }

        @Override
        public String toString() {
            return super.toString() + " (duplicating " + String.valueOf(this.loopHeader) + ")";
        }
    }

    public static class Options {
        public static final OptionKey<Double> MaxDuplicationFactor = new OptionKey<Double>(2.0);
    }
}

