/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.java;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.java.GraphBuilderPhase;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class LambdaUtils {
    private static final Pattern LAMBDA_PATTERN = Pattern.compile("\\$\\$Lambda[/.][^/]+;");
    private static final char[] HEX = "0123456789abcdef".toCharArray();
    public static final String LAMBDA_SPLIT_PATTERN = "\\$\\$Lambda";
    public static final String LAMBDA_CLASS_NAME_SUBSTRING = "$$Lambda";
    public static final String SERIALIZATION_TEST_LAMBDA_CLASS_SUBSTRING = "$$Lambda";
    public static final String SERIALIZATION_TEST_LAMBDA_CLASS_SPLIT_PATTERN = "\\$\\$Lambda";
    public static final String ADDRESS_PREFIX = ".0x";

    private static GraphBuilderConfiguration buildLambdaParserConfig(ClassInitializationPlugin cip) {
        GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(new InvocationPlugins());
        plugins.setClassInitializationPlugin(cip);
        return GraphBuilderConfiguration.getDefault(plugins).withEagerResolving(true);
    }

    private LambdaUtils() {
    }

    public static String findStableLambdaName(ClassInitializationPlugin cip, Providers providers, ResolvedJavaType lambdaType, OptionValues options, DebugContext debug, Object ctx, Function<GraphBuilderConfiguration, GraphBuilderPhase.Instance> graphBuilderSupplier) throws RuntimeException {
        ResolvedJavaMethod[] lambdaProxyMethods = (ResolvedJavaMethod[])Arrays.stream(lambdaType.getDeclaredMethods(false)).filter(m -> !m.isBridge() && m.isPublic()).toArray(ResolvedJavaMethod[]::new);
        StructuredGraph graph = new StructuredGraph.Builder(options, debug).method(lambdaProxyMethods[0]).build();
        try (DebugContext.Scope ignored = debug.scope("Lambda target method analysis", graph, lambdaType, ctx);){
            GraphBuilderPhase.Instance lambdaParserPhase = graphBuilderSupplier.apply(LambdaUtils.buildLambdaParserConfig(cip));
            HighTierContext context = new HighTierContext(providers, null, OptimisticOptimizations.NONE);
            lambdaParserPhase.apply(graph, context);
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        List<ResolvedJavaMethod> invokedMethods = StreamSupport.stream(graph.getInvokes().spliterator(), false).map(Invoke::getTargetMethod).collect(Collectors.toList());
        if (invokedMethods.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Lambda without a target invoke: ").append(lambdaType.toClassName());
            for (ResolvedJavaMethod m2 : lambdaType.getDeclaredMethods(false)) {
                sb.append("\n  Method: ").append(m2);
            }
            throw new JVMCIError(sb.toString());
        }
        return LambdaUtils.createStableLambdaName(lambdaType, invokedMethods);
    }

    public static boolean isLambdaType(ResolvedJavaType type) {
        String typeName = type.getName();
        return type.isFinalFlagSet() && LambdaUtils.isLambdaName(typeName);
    }

    public static boolean isLambdaName(String name) {
        return name.contains("$$Lambda") && LambdaUtils.lambdaMatcher(name).find();
    }

    private static String createStableLambdaName(ResolvedJavaType lambdaType, List<ResolvedJavaMethod> targetMethods) {
        String lambdaName = lambdaType.getName();
        assert (LambdaUtils.lambdaMatcher(lambdaName).find()) : "Stable name should be created for lambda types: " + lambdaName;
        Matcher m = LambdaUtils.lambdaMatcher(lambdaName);
        StringBuilder sb = new StringBuilder();
        targetMethods.forEach(targetMethod -> sb.append(targetMethod.format("%H.%n(%P)%R")));
        return m.replaceFirst(Matcher.quoteReplacement("$$Lambda.0x" + LambdaUtils.digest(sb.toString()) + ";"));
    }

    private static Matcher lambdaMatcher(String value) {
        return LAMBDA_PATTERN.matcher(value);
    }

    public static String toHex(byte[] data) {
        StringBuilder r = new StringBuilder(data.length * 2);
        for (byte b : data) {
            r.append(HEX[b >> 4 & 0xF]);
            r.append(HEX[b & 0xF]);
        }
        return r.toString();
    }

    public static String digest(String value) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(value.getBytes(StandardCharsets.UTF_8));
            return LambdaUtils.toHex(md.digest());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new JVMCIError((Throwable)ex);
        }
    }

    public static String capturingClass(String className) {
        return className.split("\\$\\$Lambda")[0];
    }
}

