/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.java;

import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.java.GraphBuilderPhase;
import jdk.graal.compiler.java.LambdaUtils;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public class StableMethodNameFormatter
implements Function<ResolvedJavaMethod, String> {
    public static final String MULTI_METHOD_KEY_SEPARATOR = "%%";
    private static final Pattern LAMBDA_METHOD_PATTERN = Pattern.compile("\\$\\$Lambda\\$\\d+/0x[0-9a-f]+");
    private static final Pattern MH_METHOD_PATTERN = Pattern.compile("LambdaForm\\$[A-Z]*MH.0x[0-9a-f]+");
    private static final String LAMBDA_PREFIX = "$$Lambda$";
    private static final String MH_PREFIX = "LambdaForm$";
    public static final String METHOD_FORMAT = "%H.%n(%p)";
    private static final String INVOKED_METHOD_FORMAT = "%H.%n(%P)%R";
    private final Providers providers;
    private GraphBuilderPhase graphBuilderPhase;
    private final DebugContext debug;
    private final boolean considerMH;
    private final EconomicMap<ResolvedJavaMethod, String> methodName = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
    public static final String LAMBDA_MH_CLASS_NAME_SUBSTRING = "LambdaForm$MH";

    public StableMethodNameFormatter(Providers providers, DebugContext debug) {
        this(providers, debug, false);
    }

    public StableMethodNameFormatter(Providers providers, DebugContext debug, boolean considerMH) {
        this.providers = providers;
        this.debug = debug;
        this.considerMH = considerMH;
    }

    @Override
    public String apply(ResolvedJavaMethod method) {
        String result = (String)this.methodName.get((Object)method);
        if (result != null) {
            return result;
        }
        result = this.findMethodName(method);
        this.methodName.put((Object)method, (Object)result);
        return result;
    }

    private String findMethodName(ResolvedJavaMethod method) {
        if (LambdaUtils.isLambdaType(method.getDeclaringClass())) {
            return this.findStableLambdaMethodName(method);
        }
        if (this.considerMH && StableMethodNameFormatter.isMethodHandle(method.getDeclaringClass())) {
            return this.findStableMHName(method);
        }
        return method.format(METHOD_FORMAT);
    }

    public static boolean isMethodHandle(ResolvedJavaType declaringClass) {
        String typeName = declaringClass.getName();
        if (typeName.contains(MH_PREFIX)) {
            return MH_METHOD_PATTERN.matcher(typeName).find();
        }
        return false;
    }

    private GraphBuilderPhase getGraphBuilderPhase() {
        if (this.graphBuilderPhase != null) {
            return this.graphBuilderPhase;
        }
        GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(new InvocationPlugins());
        GraphBuilderConfiguration builderConfiguration = GraphBuilderConfiguration.getDefault(plugins).withEagerResolving(true);
        this.graphBuilderPhase = new GraphBuilderPhase(builderConfiguration);
        return this.graphBuilderPhase;
    }

    private String findStableMHName(ResolvedJavaMethod method) {
        StructuredGraph methodGraph = new StructuredGraph.Builder(this.debug.getOptions(), this.debug).method(method).build();
        try (DebugContext.Scope ignored = this.debug.scope("Lambda method analysis", methodGraph, method, this);){
            HighTierContext context = new HighTierContext(this.providers, null, OptimisticOptimizations.NONE);
            this.getGraphBuilderPhase().apply(methodGraph, context);
        }
        catch (Throwable e) {
            throw this.debug.handle(e);
        }
        List<ResolvedJavaMethod> invokedMethods = StreamSupport.stream(methodGraph.getInvokes().spliterator(), false).map(Invoke::getTargetMethod).collect(Collectors.toList());
        String lambdaName = method.format(METHOD_FORMAT);
        Matcher matcher = MH_METHOD_PATTERN.matcher(lambdaName);
        StringBuilder sb = new StringBuilder();
        invokedMethods.forEach(targetMethod -> sb.append(targetMethod.format(INVOKED_METHOD_FORMAT)));
        return matcher.replaceFirst(Matcher.quoteReplacement(MH_PREFIX + LambdaUtils.digest(sb.toString())));
    }

    private String findStableLambdaMethodName(ResolvedJavaMethod method) {
        StructuredGraph methodGraph = new StructuredGraph.Builder(this.debug.getOptions(), this.debug).method(method).build();
        try (DebugContext.Scope ignored = this.debug.scope("Lambda method analysis", methodGraph, method, this);){
            HighTierContext context = new HighTierContext(this.providers, null, OptimisticOptimizations.NONE);
            this.getGraphBuilderPhase().apply(methodGraph, context);
        }
        catch (Throwable e) {
            throw this.debug.handle(e);
        }
        List<ResolvedJavaMethod> invokedMethods = StreamSupport.stream(methodGraph.getInvokes().spliterator(), false).map(Invoke::getTargetMethod).collect(Collectors.toList());
        String lambdaName = method.format(METHOD_FORMAT);
        Matcher matcher = LAMBDA_METHOD_PATTERN.matcher(lambdaName);
        StringBuilder sb = new StringBuilder();
        invokedMethods.forEach(targetMethod -> sb.append(targetMethod.format(INVOKED_METHOD_FORMAT)));
        return matcher.replaceFirst(Matcher.quoteReplacement(LAMBDA_PREFIX + LambdaUtils.digest(sb.toString())));
    }
}

