/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir;

import java.util.ArrayList;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.core.common.cfg.AbstractControlFlowGraph;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.core.common.util.EventCounter;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LabelRef;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.gen.LIRGenerator;
import jdk.graal.compiler.options.OptionValues;

public final class LIR
extends LIRGenerator.VariableProvider
implements EventCounter {
    private final AbstractControlFlowGraph<?> cfg;
    private final int[] linearScanOrder;
    private int[] codeEmittingOrder;
    private final BlockMap<ArrayList<LIRInstruction>> lirInstructions;
    private ArrayList<LIRInstruction.LIRInstructionSlowPath> slowPaths;
    private boolean hasArgInCallerFrame;
    private final OptionValues options;
    private final DebugContext debug;
    private int eventCounter;
    public static final int MAX_EXCEPTION_EDGE_OP_DISTANCE_FROM_END = 3;

    public LIR(AbstractControlFlowGraph<?> cfg, int[] linearScanOrder, OptionValues options, DebugContext debug) {
        this.cfg = cfg;
        this.codeEmittingOrder = null;
        this.linearScanOrder = linearScanOrder;
        this.lirInstructions = new BlockMap(cfg);
        this.options = options;
        this.debug = debug;
    }

    @Override
    public boolean eventCounterOverflows(int max) {
        if (this.eventCounter++ > max) {
            this.eventCounter = 0;
            return true;
        }
        return false;
    }

    public AbstractControlFlowGraph<?> getControlFlowGraph() {
        return this.cfg;
    }

    public BasicBlock<?> getBlockById(int blockId) {
        assert (blockId <= 0x7FFFFFFE);
        return this.cfg.getBlocks()[blockId];
    }

    public static boolean isBlockDeleted(int blockId) {
        return AbstractControlFlowGraph.blockIsDeletedOrNew(blockId);
    }

    public OptionValues getOptions() {
        return this.options;
    }

    public DebugContext getDebug() {
        return this.debug;
    }

    public boolean hasDebugInfo() {
        for (int c : this.linearScanOrder()) {
            BasicBlock b = this.cfg.getBlocks()[c];
            for (LIRInstruction op : this.getLIRforBlock(b)) {
                if (!op.hasState()) continue;
                return true;
            }
        }
        return false;
    }

    public ArrayList<LIRInstruction> getLIRforBlock(BasicBlock<?> block) {
        return this.lirInstructions.get(block);
    }

    public void setLIRforBlock(BasicBlock<?> block, ArrayList<LIRInstruction> list) {
        assert (this.getLIRforBlock(block) == null) : "lir instruction list should only be initialized once";
        this.lirInstructions.put(block, list);
    }

    public int[] linearScanOrder() {
        return this.linearScanOrder;
    }

    public int[] codeEmittingOrder() {
        if (!this.codeEmittingOrderAvailable()) {
            throw new IllegalStateException("codeEmittingOrder not computed, consider using getBlocks() or linearScanOrder()");
        }
        return this.codeEmittingOrder;
    }

    public void setCodeEmittingOrder(int[] codeEmittingOrder) {
        this.codeEmittingOrder = codeEmittingOrder;
    }

    public boolean codeEmittingOrderAvailable() {
        return this.codeEmittingOrder != null;
    }

    public ArrayList<LIRInstruction.LIRInstructionSlowPath> getSlowPaths() {
        return this.slowPaths;
    }

    public void addSlowPath(LIRInstruction op, Runnable slowPath) {
        if (this.slowPaths == null) {
            this.slowPaths = new ArrayList();
        }
        this.slowPaths.add(new LIRInstruction.LIRInstructionSlowPath(op, slowPath));
    }

    public int[] getBlocks() {
        if (this.codeEmittingOrderAvailable()) {
            return this.codeEmittingOrder;
        }
        return this.linearScanOrder;
    }

    public void setHasArgInCallerFrame() {
        this.hasArgInCallerFrame = true;
    }

    public boolean hasArgInCallerFrame() {
        return this.hasArgInCallerFrame;
    }

    public static BasicBlock<?> getNextBlock(AbstractControlFlowGraph<?> cfg, int[] blocks, int blockIndex) {
        for (int nextIndex = blockIndex + 1; nextIndex > 0 && nextIndex < blocks.length; ++nextIndex) {
            int nextBlock = blocks[nextIndex];
            if (nextBlock == Integer.MAX_VALUE) continue;
            return cfg.getBlocks()[nextBlock];
        }
        return null;
    }

    public static LabelRef getExceptionEdge(LIRInstruction op) {
        LabelRef[] exceptionEdge = new LabelRef[]{null};
        op.forEachState(state -> {
            if (state.exceptionEdge != null) {
                assert (exceptionEdge[0] == null);
                exceptionEdge[0] = state.exceptionEdge;
            }
        });
        return exceptionEdge[0];
    }

    public static boolean verifyBlock(LIR lir, BasicBlock<?> block) {
        ArrayList<LIRInstruction> ops = lir.getLIRforBlock(block);
        if (ops.size() == 0) {
            return false;
        }
        assert (ops.get(0) instanceof StandardOp.LabelOp) : String.format("Not a Label %s (Block %s)", ops.get(0).getClass(), block);
        LIRInstruction opWithExceptionEdge = null;
        int index = 0;
        int lastIndex = ops.size() - 1;
        for (LIRInstruction op : ops.subList(0, lastIndex)) {
            assert (!(op instanceof StandardOp.BlockEndOp)) : String.format("BlockEndOp %s (Block %s)", op.getClass(), block);
            LabelRef exceptionEdge = LIR.getExceptionEdge(op);
            if (exceptionEdge != null) {
                assert (opWithExceptionEdge == null) : "multiple ops with an exception edge not allowed";
                opWithExceptionEdge = op;
                int distanceFromEnd = lastIndex - index;
                assert (distanceFromEnd <= 3) : distanceFromEnd;
            }
            ++index;
        }
        LIRInstruction end = ops.get(lastIndex);
        assert (end instanceof StandardOp.BlockEndOp) : String.format("Not a BlockEndOp %s (Block %s)", end.getClass(), block);
        return true;
    }

    public static boolean verifyBlocks(LIR lir, int[] blocks) {
        for (int blockId : blocks) {
            int i;
            if (blockId == Integer.MAX_VALUE) continue;
            BasicBlock<?> block = lir.getBlockById(blockId);
            for (i = 0; i < block.getSuccessorCount(); ++i) {
                Object sux = block.getSuccessorAt(i);
                assert (LIR.contains(blocks, ((BasicBlock)sux).getId())) : "missing successor from: " + String.valueOf(block) + "to: " + String.valueOf(sux);
            }
            for (i = 0; i < block.getPredecessorCount(); ++i) {
                Object pred = block.getPredecessorAt(i);
                assert (LIR.contains(blocks, ((BasicBlock)pred).getId())) : "missing predecessor from: " + String.valueOf(block) + "to: " + String.valueOf(pred);
            }
            if (LIR.verifyBlock(lir, block)) continue;
            return false;
        }
        return true;
    }

    private static boolean contains(int[] blockIndices, int key) {
        for (int index : blockIndices) {
            if (index != key) continue;
            return true;
        }
        return false;
    }

    public void resetLabels() {
        for (int b : this.getBlocks()) {
            BasicBlock block = this.cfg.getBlocks()[b];
            if (block == null) continue;
            for (LIRInstruction inst : this.lirInstructions.get(block)) {
                Label label;
                if (!(inst instanceof StandardOp.LabelHoldingOp) || (label = ((StandardOp.LabelHoldingOp)((Object)inst)).getLabel()) == null) continue;
                label.reset();
            }
        }
        if (this.slowPaths != null) {
            this.slowPaths.clear();
        }
    }
}

