/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64ASIMDAssembler;
import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.aarch64.AArch64ComplexVectorOp;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@Opcode(value="ARRAY_COMPARE_TO")
public final class AArch64ArrayCompareToOp
extends AArch64ComplexVectorOp {
    public static final LIRInstructionClass<AArch64ArrayCompareToOp> TYPE = LIRInstructionClass.create(AArch64ArrayCompareToOp.class);
    private final boolean isLL;
    private final boolean isUU;
    private final boolean isLU;
    private final boolean isUL;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected Value resultValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value array1Value;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value array2Value;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected Value length1Value;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected Value length2Value;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value length1ValueTemp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value length2ValueTemp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value[] temp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue[] vectorTemp;

    public AArch64ArrayCompareToOp(LIRGeneratorTool tool, Stride strideA, Stride strideB, Value result, Value arrayA, Value lengthA, Value arrayB, Value lengthB) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        GraalError.guarantee(arrayA.getPlatformKind() == AArch64Kind.QWORD && arrayA.getPlatformKind() == arrayB.getPlatformKind(), "pointer value expected");
        GraalError.guarantee(lengthA.getPlatformKind() == AArch64Kind.DWORD && lengthA.getPlatformKind() == lengthB.getPlatformKind(), "int value expected");
        GraalError.guarantee(result.getPlatformKind() == AArch64Kind.DWORD, "int value expected");
        GraalError.guarantee(strideA == Stride.S1 || strideA == Stride.S2, "strideA must be S1 or S2");
        GraalError.guarantee(strideB == Stride.S1 || strideB == Stride.S2, "strideB must be S1 or S2");
        this.isLL = strideA == strideB && strideA == Stride.S1;
        this.isUU = strideA == strideB && strideA == Stride.S2;
        this.isLU = strideA != strideB && strideA == Stride.S1;
        this.isUL = strideA != strideB && strideA == Stride.S2;
        this.resultValue = result;
        this.array1Value = arrayA;
        this.array2Value = arrayB;
        this.length1Value = this.length1ValueTemp = lengthA;
        this.length2Value = this.length2ValueTemp = lengthB;
        this.temp = AArch64ArrayCompareToOp.allocateTempRegisters(tool, 6);
        this.vectorTemp = AArch64ArrayCompareToOp.allocateVectorRegisters(tool, 5);
    }

    @Override
    protected void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register result = ValueUtil.asRegister((Value)this.resultValue);
        Register length1 = ValueUtil.asRegister((Value)this.length1Value);
        Register length2 = ValueUtil.asRegister((Value)this.length2Value);
        Register array1 = ValueUtil.asRegister((Value)this.temp[0]);
        Register array2 = ValueUtil.asRegister((Value)this.temp[1]);
        Register length = ValueUtil.asRegister((Value)this.temp[2]);
        Label done = new Label();
        Label stringsEqualUptoLength = new Label();
        Label simdImpl = new Label();
        masm.mov(64, array1, ValueUtil.asRegister((Value)this.array1Value));
        masm.mov(64, array2, ValueUtil.asRegister((Value)this.array2Value));
        masm.prfm(AArch64Address.createBaseRegisterOnlyAddress(64, array1), AArch64Assembler.PrefetchMode.PLDL1STRM);
        masm.prfm(AArch64Address.createBaseRegisterOnlyAddress(64, array2), AArch64Assembler.PrefetchMode.PLDL1STRM);
        if (!this.isLL) {
            masm.lsr(64, length2, length2, 1L);
        }
        if (this.isUU) {
            masm.lsr(64, length1, length1, 1L);
        }
        masm.cmp(32, length1, length2);
        masm.csel(32, length, length1, length2, AArch64Assembler.ConditionFlag.LT);
        masm.cbz(64, length, stringsEqualUptoLength);
        if (!this.isLL) {
            masm.lsl(64, length, length, 1L);
        }
        int simdByteThreshold = 32;
        masm.compare(64, length, simdByteThreshold);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.GE, simdImpl);
        this.emitScalarCode(masm, stringsEqualUptoLength, done);
        masm.jmp(done);
        masm.bind(simdImpl);
        this.emitSIMDCode(masm, stringsEqualUptoLength);
        masm.jmp(done);
        masm.bind(stringsEqualUptoLength);
        if (this.isUL) {
            masm.sub(32, result, length2, length1);
        } else {
            masm.sub(32, result, length1, length2);
        }
        masm.bind(done);
    }

    private void emitScalarCode(AArch64MacroAssembler masm, Label stringsEqualUptoLength, Label done) {
        Register result = ValueUtil.asRegister((Value)this.resultValue);
        Register array1 = ValueUtil.asRegister((Value)this.temp[0]);
        Register array2 = ValueUtil.asRegister((Value)this.temp[1]);
        Register byteLength = ValueUtil.asRegister((Value)this.temp[2]);
        Register tmp = ValueUtil.asRegister((Value)this.temp[3]);
        Register remainingBytes = ValueUtil.asRegister((Value)this.temp[4]);
        Label charSearchLoop = new Label();
        int elementByteSize = this.isLL ? 1 : 2;
        int elementBitSize = elementByteSize * 8;
        masm.mov(64, remainingBytes, byteLength);
        masm.align(16);
        masm.bind(charSearchLoop);
        if (this.isLU || this.isUL) {
            masm.ldr(8, tmp, AArch64Address.createImmediateAddress(8, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, array1, 1));
        } else {
            masm.ldr(elementBitSize, tmp, AArch64Address.createImmediateAddress(elementBitSize, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, array1, elementByteSize));
        }
        masm.ldr(elementBitSize, result, AArch64Address.createImmediateAddress(elementBitSize, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, array2, elementByteSize));
        if (this.isUL) {
            masm.subs(32, result, result, tmp);
        } else {
            masm.subs(32, result, tmp, result);
        }
        masm.branchConditionally(AArch64Assembler.ConditionFlag.NE, done);
        masm.subs(64, remainingBytes, remainingBytes, elementByteSize);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, stringsEqualUptoLength);
        masm.jmp(charSearchLoop);
    }

    private void emitSIMDCode(AArch64MacroAssembler masm, Label stringsEqualUptoLength) {
        Register tmp;
        Register result = ValueUtil.asRegister((Value)this.resultValue);
        Register array1 = ValueUtil.asRegister((Value)this.temp[0]);
        Register array2 = ValueUtil.asRegister((Value)this.temp[1]);
        Register byteLength = ValueUtil.asRegister((Value)this.temp[2]);
        Register endOfComparison = ValueUtil.asRegister((Value)this.temp[3]);
        Register lastChunkAddress1 = ValueUtil.asRegister((Value)this.temp[4]);
        Register lastChunkAddress2 = ValueUtil.asRegister((Value)this.temp[5]);
        Register array1LowV = ValueUtil.asRegister((Value)this.vectorTemp[0]);
        Register array1HighV = ValueUtil.asRegister((Value)this.vectorTemp[1]);
        Register array2LowV = ValueUtil.asRegister((Value)this.vectorTemp[2]);
        Register array2HighV = ValueUtil.asRegister((Value)this.vectorTemp[3]);
        Register tmpRegV1 = ValueUtil.asRegister((Value)this.vectorTemp[4]);
        Label simdLoop = new Label();
        Label mismatchInChunk = new Label();
        boolean isSameEncoding = this.isLL || this.isUU;
        int elementBitSize = this.isLL ? 8 : 16;
        int chunkByteSize = 32;
        AArch64ASIMDAssembler.ElementSize eSize = AArch64ASIMDAssembler.ElementSize.fromSize(elementBitSize);
        if (isSameEncoding) {
            masm.add(64, endOfComparison, array1, byteLength);
            masm.sub(64, byteLength, byteLength, 32);
            masm.add(64, lastChunkAddress1, array1, byteLength);
            masm.add(64, lastChunkAddress2, array2, byteLength);
        } else {
            masm.add(64, endOfComparison, array1, byteLength, AArch64Assembler.ShiftType.LSR, 1);
            masm.sub(64, byteLength, byteLength, 32);
            masm.add(64, lastChunkAddress1, array1, byteLength, AArch64Assembler.ShiftType.LSR, 1);
            masm.add(64, lastChunkAddress2, array2, byteLength);
        }
        masm.align(16);
        masm.bind(simdLoop);
        if (isSameEncoding) {
            masm.fldp(128, array1LowV, array1HighV, AArch64Address.createImmediateAddress(128, AArch64Address.AddressingMode.IMMEDIATE_PAIR_POST_INDEXED, array1, 32));
        } else {
            masm.fldr(128, array1LowV, AArch64Address.createImmediateAddress(128, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, array1, 16));
            masm.neon.uxtl2VV(AArch64ASIMDAssembler.ElementSize.Byte, array1HighV, array1LowV);
            masm.neon.uxtlVV(AArch64ASIMDAssembler.ElementSize.Byte, array1LowV, array1LowV);
        }
        masm.fldp(128, array2LowV, array2HighV, AArch64Address.createImmediateAddress(128, AArch64Address.AddressingMode.IMMEDIATE_PAIR_POST_INDEXED, array2, 32));
        masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, array1LowV, array1LowV, array2LowV);
        masm.neon.cmeqVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, array1HighV, array1HighV, array2HighV);
        masm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, tmpRegV1, array1LowV, array1HighV);
        masm.neon.uminvSV(AArch64ASIMDAssembler.ASIMDSize.FullReg, eSize, tmpRegV1, tmpRegV1);
        try (AArch64MacroAssembler.ScratchRegister scratchReg = masm.getScratchRegister();){
            tmp = scratchReg.getRegister();
            masm.neon.umovGX(AArch64ASIMDAssembler.ElementSize.DoubleWord, tmp, tmpRegV1, 0);
            masm.cbz(64, tmp, mismatchInChunk);
        }
        masm.cmp(64, array1, lastChunkAddress1);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.LO, simdLoop);
        masm.cmp(64, array1, endOfComparison);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.HS, stringsEqualUptoLength);
        masm.mov(64, array1, lastChunkAddress1);
        masm.mov(64, array2, lastChunkAddress2);
        masm.jmp(simdLoop);
        masm.bind(mismatchInChunk);
        scratchReg = masm.getScratchRegister();
        try {
            tmp = scratchReg.getRegister();
            AArch64ArrayCompareToOp.initCalcIndexOfFirstMatchMask(masm, tmpRegV1, tmp);
            AArch64ArrayCompareToOp.calcIndexOfFirstMatch(masm, result, array1LowV, array1HighV, tmpRegV1, true);
        }
        finally {
            if (scratchReg != null) {
                scratchReg.close();
            }
        }
        masm.asr(64, result, result, 1L);
        masm.sub(64, result, result, 32);
        if (isSameEncoding) {
            masm.ldr(elementBitSize, lastChunkAddress1, AArch64Address.createRegisterOffsetAddress(elementBitSize, array1, result, false));
        } else {
            scratchReg = masm.getScratchRegister();
            try {
                Register tmpReg = scratchReg.getRegister();
                masm.asr(64, tmpReg, result, 1L);
                masm.ldr(8, lastChunkAddress1, AArch64Address.createRegisterOffsetAddress(8, array1, tmpReg, false));
            }
            finally {
                if (scratchReg != null) {
                    scratchReg.close();
                }
            }
        }
        masm.ldr(elementBitSize, lastChunkAddress2, AArch64Address.createRegisterOffsetAddress(elementBitSize, array2, result, false));
        if (this.isUL) {
            masm.sub(32, result, lastChunkAddress2, lastChunkAddress1);
        } else {
            masm.sub(32, result, lastChunkAddress1, lastChunkAddress2);
        }
    }
}

