/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.DiagnosticLIRGeneratorTool;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;

public class AArch64Call {
    public static boolean isNearCall(ForeignCallLinkage linkage) {
        long maxOffset = linkage.getMaxCallTargetOffset();
        return maxOffset != -1L && AArch64MacroAssembler.isBranchImmediateOffset(maxOffset);
    }

    public static int directCall(CompilationResultBuilder crb, AArch64MacroAssembler masm, InvokeTarget callTarget, Register scratch, LIRFrameState info) {
        return AArch64Call.directCall(crb, masm, callTarget, scratch, info, null);
    }

    public static int directCall(CompilationResultBuilder crb, AArch64MacroAssembler masm, InvokeTarget callTarget, Register scratch, LIRFrameState info, Label label) {
        int before = masm.position();
        if (scratch != null) {
            masm.movNativeAddress(scratch, 0L, true);
            masm.blr(scratch);
        } else {
            masm.bl();
        }
        if (label != null) {
            masm.bind(label);
        }
        int after = masm.position();
        Call call = crb.recordDirectCall(before, after, callTarget, info);
        crb.recordExceptionHandlers(after, info);
        masm.postCallNop((Infopoint)call);
        return before;
    }

    public static int indirectCall(CompilationResultBuilder crb, AArch64MacroAssembler masm, Register dst, InvokeTarget callTarget, LIRFrameState info) {
        int before = masm.position();
        masm.blr(dst);
        int after = masm.position();
        Call call = crb.recordIndirectCall(before, after, callTarget, info);
        crb.recordExceptionHandlers(after, info);
        masm.postCallNop((Infopoint)call);
        return before;
    }

    public static void directJmp(CompilationResultBuilder crb, AArch64MacroAssembler masm, ForeignCallLinkage callTarget) {
        try (AArch64MacroAssembler.ScratchRegister scratch = masm.getScratchRegister();){
            int before = masm.position();
            if (AArch64Call.isNearCall(callTarget)) {
                masm.jmp();
            } else {
                masm.movNativeAddress(scratch.getRegister(), 0L, true);
                masm.jmp(scratch.getRegister());
            }
            int after = masm.position();
            Call call = crb.recordDirectCall(before, after, callTarget, null);
            masm.postCallNop((Infopoint)call);
        }
    }

    @Opcode(value="FAR_FOREIGN_CALL")
    public static class DirectFarForeignCallOp
    extends ForeignCallOp {
        public static final LIRInstructionClass<DirectFarForeignCallOp> TYPE = LIRInstructionClass.create(DirectFarForeignCallOp.class);

        public DirectFarForeignCallOp(ForeignCallLinkage callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state, Label label) {
            super(TYPE, callTarget, result, parameters, temps, state, label);
        }

        @Override
        protected void emitCall(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            try (AArch64MacroAssembler.ScratchRegister scratch = masm.getScratchRegister();){
                AArch64Call.directCall(crb, masm, this.callTarget, scratch.getRegister(), this.state, this.label);
            }
        }
    }

    @Opcode(value="NEAR_FOREIGN_CALL")
    public static class DirectNearForeignCallOp
    extends ForeignCallOp {
        public static final LIRInstructionClass<DirectNearForeignCallOp> TYPE = LIRInstructionClass.create(DirectNearForeignCallOp.class);

        public DirectNearForeignCallOp(ForeignCallLinkage callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state, Label label) {
            super(TYPE, callTarget, result, parameters, temps, state, label);
        }

        @Override
        protected void emitCall(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64Call.directCall(crb, masm, this.callTarget, null, this.state, this.label);
        }
    }

    public static abstract class ForeignCallOp
    extends CallOp
    implements StandardOp.LabelHoldingOp,
    DiagnosticLIRGeneratorTool.ZapRegistersAfterInstruction {
        protected final ForeignCallLinkage callTarget;
        protected final Label label;

        protected ForeignCallOp(LIRInstructionClass<? extends ForeignCallOp> c, ForeignCallLinkage callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state, Label label) {
            super(c, result, parameters, temps, state);
            this.callTarget = callTarget;
            this.label = label;
        }

        @Override
        public boolean destroysCallerSavedRegisters() {
            return this.callTarget.destroysRegisters();
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            this.emitCall(crb, masm);
        }

        protected abstract void emitCall(CompilationResultBuilder var1, AArch64MacroAssembler var2);

        @Override
        public Label getLabel() {
            return this.label;
        }
    }

    @Opcode(value="CALL_DIRECT")
    public static abstract class DirectCallOp
    extends MethodCallOp {
        public static final LIRInstructionClass<DirectCallOp> TYPE = LIRInstructionClass.create(DirectCallOp.class);

        public DirectCallOp(ResolvedJavaMethod target, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            super(TYPE, target, result, parameters, temps, state);
        }

        protected DirectCallOp(LIRInstructionClass<? extends DirectCallOp> c, ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            super(c, callTarget, result, parameters, temps, state);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64Call.directCall(crb, masm, (InvokeTarget)this.callTarget, null, this.state);
        }
    }

    @Opcode(value="CALL_INDIRECT")
    public static class IndirectCallOp
    extends MethodCallOp {
        public static final LIRInstructionClass<IndirectCallOp> TYPE = LIRInstructionClass.create(IndirectCallOp.class);
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected Value targetAddress;

        public IndirectCallOp(ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, Value targetAddress, LIRFrameState state) {
            this(TYPE, callTarget, result, parameters, temps, targetAddress, state);
        }

        protected IndirectCallOp(LIRInstructionClass<? extends IndirectCallOp> c, ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, Value targetAddress, LIRFrameState state) {
            super(c, callTarget, result, parameters, temps, state);
            this.targetAddress = targetAddress;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register target = ValueUtil.asRegister((Value)this.targetAddress);
            AArch64Call.indirectCall(crb, masm, target, (InvokeTarget)this.callTarget, this.state);
        }

        @Override
        public void verify() {
            super.verify();
            assert (ValueUtil.isRegister((Value)this.targetAddress)) : "The current register allocator cannot handle variables to be used at call sites, it must be in a fixed register for now";
        }
    }

    public static abstract class MethodCallOp
    extends CallOp {
        protected final ResolvedJavaMethod callTarget;

        protected MethodCallOp(LIRInstructionClass<? extends MethodCallOp> c, ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            super(c, result, parameters, temps, state);
            this.callTarget = callTarget;
        }
    }

    public static abstract class CallOp
    extends AArch64LIRInstruction {
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        protected Value result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected Value[] parameters;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected Value[] temps;
        @LIRInstruction.State
        protected LIRFrameState state;

        protected CallOp(LIRInstructionClass<? extends CallOp> c, Value result, Value[] parameters, Value[] temps, LIRFrameState state) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)c);
            this.result = result;
            this.parameters = parameters;
            this.state = state;
            this.temps = CallOp.addStackSlotsToTemporaries(parameters, temps);
            assert (temps != null);
        }

        @Override
        public boolean destroysCallerSavedRegisters() {
            return true;
        }
    }
}

