/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import java.util.Arrays;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64ASIMDAssembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.code.DataSection;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.ArrayDataPointerConstant;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;

public abstract class AArch64ComplexVectorOp
extends AArch64LIRInstruction {
    private static final Register[] consecutiveSIMDRegisters = new Register[]{AArch64.v0, AArch64.v1, AArch64.v2, AArch64.v3, AArch64.v4, AArch64.v5, AArch64.v6, AArch64.v7, AArch64.v8, AArch64.v9, AArch64.v10, AArch64.v11, AArch64.v12, AArch64.v13, AArch64.v14, AArch64.v15, AArch64.v16, AArch64.v17, AArch64.v18, AArch64.v19, AArch64.v20, AArch64.v21, AArch64.v22, AArch64.v23, AArch64.v24, AArch64.v25, AArch64.v26, AArch64.v27, AArch64.v28, AArch64.v29, AArch64.v30, AArch64.v31};
    private static final Runnable NO_ACTION = () -> {};

    protected AArch64ComplexVectorOp(LIRInstructionClass<? extends AArch64LIRInstruction> c) {
        super(c);
    }

    protected static AllocatableValue[] allocateTempRegisters(LIRGeneratorTool tool, int n) {
        return AArch64ComplexVectorOp.allocateRegisters(tool, LIRKind.value(tool.target().arch.getWordKind()), n);
    }

    protected static AllocatableValue[] allocateVectorRegisters(LIRGeneratorTool tool, int n) {
        return AArch64ComplexVectorOp.allocateRegisters(tool, LIRKind.value(tool.target().arch.getLargestStorableKind(AArch64.SIMD)), n);
    }

    protected static Value[] allocateVectorRegisters(LIRGeneratorTool tool, int n, boolean consecutive) {
        if (consecutive) {
            return AArch64ComplexVectorOp.allocateConsecutiveVectorRegisters(tool, n);
        }
        return AArch64ComplexVectorOp.allocateVectorRegisters(tool, n);
    }

    private static AllocatableValue[] allocateRegisters(LIRGeneratorTool tool, LIRKind kind, int n) {
        AllocatableValue[] values = new AllocatableValue[n];
        for (int i = 0; i < values.length; ++i) {
            values[i] = tool.newVariable(kind);
        }
        return values;
    }

    protected static Value[] allocateConsecutiveVectorRegisters(LIRGeneratorTool tool, int n) {
        Value[] ret = new Value[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = consecutiveSIMDRegisters[i].asValue((ValueKind)LIRKind.value(tool.target().arch.getLargestStorableKind(AArch64.SIMD)));
        }
        return ret;
    }

    protected static void loadDataSectionAddress(CompilationResultBuilder crb, AArch64MacroAssembler asm, Register dst, DataSection.Data data) {
        crb.recordDataSectionReference(data);
        asm.adrpAdd(dst);
    }

    protected static void cbnzVector(AArch64MacroAssembler asm, AArch64ASIMDAssembler.ElementSize eSize, Register vecDst, Register vecSrc, Register tmp, boolean allOnes, Label label) {
        AArch64ComplexVectorOp.vectorCheckZeroReduce(asm, eSize, vecDst, vecSrc, tmp, allOnes);
        asm.cbnz(64, tmp, label);
    }

    protected static void cmpZeroVector(AArch64MacroAssembler asm, Register vecDst, Register vecSrc, Register tmp) {
        AArch64ComplexVectorOp.vectorCheckZeroReduce(asm, AArch64ASIMDAssembler.ElementSize.Byte, vecDst, vecSrc, tmp, false);
        asm.cmp(64, tmp, AArch64.zr);
    }

    protected static void cmpZeroVector(AArch64MacroAssembler asm, AArch64ASIMDAssembler.ElementSize eSize, Register vecDst, Register vecSrc, Register tmp, boolean allOnes) {
        AArch64ComplexVectorOp.vectorCheckZeroReduce(asm, eSize, vecDst, vecSrc, tmp, allOnes);
        asm.cmp(64, tmp, AArch64.zr);
    }

    private static void vectorCheckZeroReduce(AArch64MacroAssembler asm, AArch64ASIMDAssembler.ElementSize eSize, Register vecDst, Register vecSrc, Register tmp, boolean allOnes) {
        assert (vecSrc.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (vecDst.getRegisterCategory().equals((Object)AArch64.SIMD));
        assert (tmp.getRegisterCategory().equals((Object)AArch64.CPU));
        if (eSize == AArch64ASIMDAssembler.ElementSize.Byte || !allOnes) {
            asm.neon.umaxpVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Word, vecDst, vecSrc, vecSrc);
        } else {
            asm.neon.xtnVV(eSize.narrow(), vecDst, vecSrc);
        }
        asm.neon.umovGX(AArch64ASIMDAssembler.ElementSize.DoubleWord, tmp, vecDst, 0);
    }

    protected static void initCalcIndexOfFirstMatchMask(AArch64MacroAssembler asm, Register vecMask, Register tmp) {
        asm.mov(tmp, -1070593021);
        asm.neon.dupVG(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Word, vecMask, tmp);
    }

    protected static void calcIndexOfFirstMatch(AArch64MacroAssembler asm, Register dst, Register vec1, Register vec2, Register vecMask, boolean inverse) {
        AArch64ComplexVectorOp.calcIndexOfFirstMatch(asm, dst, vec1, vec2, vecMask, inverse, NO_ACTION);
    }

    protected static void calcIndexOfFirstMatch(AArch64MacroAssembler asm, Register dst, Register vec1, Register vec2, Register vecMask, boolean inverse, Runnable interleavedInstructions) {
        if (inverse) {
            asm.neon.bicVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vec1, vecMask, vec1);
            asm.neon.bicVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vec2, vecMask, vec2);
        } else {
            asm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vec1, vec1, vecMask);
            asm.neon.andVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vec2, vec2, vecMask);
        }
        asm.neon.addpVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vec1, vec1, vec2);
        asm.neon.addpVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vec1, vec1, vec2);
        asm.neon.moveFromIndex(AArch64ASIMDAssembler.ElementSize.DoubleWord, AArch64ASIMDAssembler.ElementSize.DoubleWord, dst, vec1, 0);
        interleavedInstructions.run();
        asm.rbit(64, dst, dst);
        asm.clz(64, dst, dst);
    }

    protected DataSection.Data createTailANDMask(CompilationResultBuilder crb, int n) {
        byte[] mask = new byte[n << 1];
        Arrays.fill(mask, n, mask.length, (byte)-1);
        return AArch64ComplexVectorOp.writeToDataSection(crb, mask);
    }

    protected static DataSection.Data createTailShuffleMask(CompilationResultBuilder crb, int n) {
        byte[] mask = new byte[n + 16];
        for (int i = 0; i < n; ++i) {
            mask[i] = (byte)i;
        }
        Arrays.fill(mask, n, mask.length, (byte)-1);
        return AArch64ComplexVectorOp.writeToDataSection(crb, mask);
    }

    protected static DataSection.Data writeToDataSection(CompilationResultBuilder crb, byte[] array) {
        int align = crb.dataBuilder.ensureValidDataAlignment((array.length & 0xF) == 0 ? array.length : (array.length & 0xFFFFFFF0) + 16);
        ArrayDataPointerConstant arrayConstant = new ArrayDataPointerConstant(array, align);
        return crb.dataBuilder.createSerializableData(arrayConstant, align);
    }
}

