/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64ASIMDAssembler;
import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.aarch64.AArch64ComplexVectorOp;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.aarch64.AArch64Move;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@Opcode(value="AArch64_ENCODE_ARRAY")
@SyncPort(from="https://github.com/openjdk/jdk/blob/0a3a925ad88921d387aa851157f54ac0054d347b/src/hotspot/cpu/aarch64/macroAssembler_aarch64.cpp#L5649-L5761", sha1="95adbb3a56ad94eca2698b6fd6d8359a15069de7")
public final class AArch64EncodeArrayOp
extends AArch64ComplexVectorOp {
    public static final LIRInstructionClass<AArch64EncodeArrayOp> TYPE = LIRInstructionClass.create(AArch64EncodeArrayOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    private Value resultValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value originSrcValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value originDstValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value lenValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private AllocatableValue srcValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private AllocatableValue dstValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value[] vectorTempValue;
    private final LIRGeneratorTool.CharsetName charset;

    public AArch64EncodeArrayOp(LIRGeneratorTool tool, Value result, Value src, Value dst, Value length, LIRGeneratorTool.CharsetName charset) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.resultValue = result;
        this.originSrcValue = src;
        this.originDstValue = dst;
        this.lenValue = length;
        this.srcValue = tool.newVariable(src.getValueKind());
        this.dstValue = tool.newVariable(dst.getValueKind());
        this.vectorTempValue = AArch64EncodeArrayOp.allocateConsecutiveVectorRegisters(tool, charset == LIRGeneratorTool.CharsetName.ASCII ? 7 : 6);
        this.charset = charset;
        assert (charset == LIRGeneratorTool.CharsetName.ASCII || charset == LIRGeneratorTool.CharsetName.ISO_8859_1) : charset;
    }

    @Override
    protected void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        AArch64Move.move(AArch64Kind.QWORD, crb, masm, this.srcValue, this.originSrcValue);
        AArch64Move.move(AArch64Kind.QWORD, crb, masm, this.dstValue, this.originDstValue);
        boolean ascii = this.charset == LIRGeneratorTool.CharsetName.ASCII;
        Register src = ValueUtil.asRegister((Value)this.srcValue);
        Register dst = ValueUtil.asRegister((Value)this.dstValue);
        Register len = ValueUtil.asRegister((Value)this.lenValue);
        Register res = ValueUtil.asRegister((Value)this.resultValue);
        Register vtmp0 = ValueUtil.asRegister((Value)this.vectorTempValue[0]);
        Register vtmp1 = ValueUtil.asRegister((Value)this.vectorTempValue[1]);
        Register vtmp2 = ValueUtil.asRegister((Value)this.vectorTempValue[2]);
        Register vtmp3 = ValueUtil.asRegister((Value)this.vectorTempValue[3]);
        Register vlo0 = ValueUtil.asRegister((Value)this.vectorTempValue[4]);
        Register vlo1 = ValueUtil.asRegister((Value)this.vectorTempValue[5]);
        Register vmask = ascii ? ValueUtil.asRegister((Value)this.vectorTempValue[6]) : null;
        Register cnt = res;
        masm.prfm(AArch64Address.createBaseRegisterOnlyAddress(64, src), AArch64Assembler.PrefetchMode.PLDL1STRM);
        masm.mov(32, cnt, len);
        if (ascii) {
            masm.neon.moveVI(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.HalfWord, vmask, -128L);
        }
        Label labelLoop32 = new Label();
        Label labelDone32 = new Label();
        Label labelFail32 = new Label();
        masm.bind(labelLoop32);
        masm.compare(32, cnt, 32);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.LT, labelDone32);
        masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.HalfWord, vtmp0, vtmp1, vtmp2, vtmp3, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.HalfWord, src, 64));
        masm.neon.uzp1VVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vlo0, vtmp0, vtmp1);
        masm.neon.uzp1VVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vlo1, vtmp2, vtmp3);
        masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vtmp0, vtmp0, vtmp1);
        masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vtmp2, vtmp2, vtmp3);
        masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vtmp0, vtmp0, vtmp2);
        if (ascii) {
            masm.neon.cmtstVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.HalfWord, vtmp0, vtmp0, vmask);
            masm.neon.xtnVV(AArch64ASIMDAssembler.ElementSize.HalfWord.narrow(), vtmp0, vtmp0);
        } else {
            masm.neon.uzp2VVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vtmp0, vtmp0, vtmp0);
        }
        try (AArch64MacroAssembler.ScratchRegister sc1 = masm.getScratchRegister();){
            Register tmp = sc1.getRegister();
            masm.neon.umovGX(AArch64ASIMDAssembler.ElementSize.DoubleWord, tmp, vtmp0, 0);
            masm.cbnz(64, tmp, labelFail32);
        }
        masm.sub(32, cnt, cnt, 32);
        masm.fstp(128, vlo0, vlo1, AArch64Address.createImmediateAddress(AArch64ASIMDAssembler.ASIMDSize.FullReg.bits(), AArch64Address.AddressingMode.IMMEDIATE_PAIR_POST_INDEXED, dst, 32));
        masm.jmp(labelLoop32);
        masm.bind(labelFail32);
        masm.sub(64, src, src, 64);
        masm.bind(labelDone32);
        Label labelLoop8 = new Label();
        Label labelSkip8 = new Label();
        masm.bind(labelLoop8);
        masm.compare(32, cnt, 8);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.LT, labelSkip8);
        masm.fldr(128, vtmp0, AArch64Address.createBaseRegisterOnlyAddress(128, src));
        masm.neon.uzp1VVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vlo0, vtmp0, vtmp0);
        if (ascii) {
            masm.neon.cmtstVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.HalfWord, vtmp0, vtmp0, vmask);
            masm.neon.xtnVV(AArch64ASIMDAssembler.ElementSize.HalfWord.narrow(), vtmp0, vtmp0);
        } else {
            masm.neon.uzp2VVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vtmp0, vtmp0, vtmp0);
        }
        try (AArch64MacroAssembler.ScratchRegister sc1 = masm.getScratchRegister();){
            Register tmp = sc1.getRegister();
            masm.neon.umovGX(AArch64ASIMDAssembler.ElementSize.DoubleWord, tmp, vtmp0, 0);
            masm.cbnz(64, tmp, labelSkip8);
        }
        masm.fstr(64, vlo0, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, dst, 8));
        masm.sub(32, cnt, cnt, 8);
        masm.add(64, src, src, 16);
        masm.jmp(labelLoop8);
        masm.bind(labelSkip8);
        sc1 = masm.getScratchRegister();
        try {
            Label labelLoop = new Label();
            Label labelDone = new Label();
            masm.cbz(32, cnt, labelDone);
            masm.bind(labelLoop);
            Register chr = sc1.getRegister();
            masm.ldr(16, chr, AArch64Address.createImmediateAddress(16, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, src, 2));
            masm.tst(32, chr, ascii ? 65408L : 65280L);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.NE, labelDone);
            masm.str(8, chr, AArch64Address.createImmediateAddress(8, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, dst, 1));
            masm.subs(32, cnt, cnt, 1);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.GT, labelLoop);
            masm.bind(labelDone);
            masm.sub(32, res, len, cnt);
        }
        finally {
            if (sc1 != null) {
                sc1.close();
            }
        }
    }
}

