/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.lir.framemap.FrameMap;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.meta.PlatformKind;

public class AArch64FrameMap
extends FrameMap {
    public AArch64FrameMap(CodeCacheProvider codeCache, RegisterConfig registerConfig, FrameMap.ReferenceMapBuilderFactory referenceMapFactory) {
        super(codeCache, registerConfig, referenceMapFactory);
        this.spillSize = this.initialSpillSize = this.frameSetupSize();
    }

    @Override
    public int totalFrameSize() {
        return this.frameSize() + this.frameSetupSize();
    }

    private int frameSetupSize() {
        return this.getTarget().arch.getWordSize() * 2;
    }

    @Override
    public int currentFrameSize() {
        return this.alignFrameSize(this.outgoingSize + this.spillSize);
    }

    public StackSlot allocateDeoptimizationRescueSlot() {
        assert (this.spillSize == this.initialSpillSize) : "Deoptimization rescue slot must be the first stack slot";
        return this.allocateSpillSlot(LIRKind.value((PlatformKind)AArch64Kind.QWORD));
    }
}

