/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import jdk.graal.compiler.asm.aarch64.AArch64ASIMDAssembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;

@SyncPort(from="https://github.com/openjdk/jdk/blob/1fc726a8b34fcd41dae12a6d7c63232f9ccef3f4/src/hotspot/cpu/aarch64/macroAssembler_aarch64.hpp#L522-L525", sha1="f723de35aeda75e448037a23cd6af82f457c24cf")
public class AArch64HalfFloatToFloatOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64HalfFloatToFloatOp> TYPE = LIRInstructionClass.create(AArch64HalfFloatToFloatOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected Value dstValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value srcValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value tmpValue;

    public AArch64HalfFloatToFloatOp(LIRGeneratorTool tool, Value dstValue, Value srcValue) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.dstValue = dstValue;
        this.srcValue = srcValue;
        this.tmpValue = tool.newVariable(dstValue.getValueKind());
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register dst = ValueUtil.asRegister((Value)this.dstValue);
        Register src = ValueUtil.asRegister((Value)this.srcValue);
        Register tmp = ValueUtil.asRegister((Value)this.tmpValue);
        masm.neon.insXG(AArch64ASIMDAssembler.ElementSize.HalfWord, tmp, 0, src);
        masm.fcvt(32, 16, dst, tmp);
    }
}

