/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import jdk.graal.compiler.asm.aarch64.AArch64ASIMDAssembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@Opcode(value="MATH_SIGNUM")
public final class AArch64MathCopySignOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64MathCopySignOp> TYPE = LIRInstructionClass.create(AArch64MathCopySignOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected Value result;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value magnitude;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value sign;

    public AArch64MathCopySignOp(Value result, AllocatableValue magnitude, AllocatableValue sign) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.result = result;
        this.magnitude = magnitude;
        this.sign = sign;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register resultReg = ValueUtil.asRegister((Value)this.result);
        Register magnitudeReg = ValueUtil.asRegister((Value)this.magnitude);
        Register signReg = ValueUtil.asRegister((Value)this.sign);
        int size = this.result.getPlatformKind().getSizeInBytes() * 8;
        masm.fmov(size, resultReg, 0.0);
        masm.fneg(size, resultReg, resultReg);
        masm.neon.bslVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, resultReg, signReg, magnitudeReg);
    }
}

