/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@SyncPort(from="https://github.com/openjdk/jdk/blob/0a3a925ad88921d387aa851157f54ac0054d347b/src/hotspot/cpu/aarch64/aarch64.ad#L9594-L9676", sha1="84da421c1489e188366d61bb4298e0425ccac14b")
public class AArch64NormalizedUnsignedCompareOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64NormalizedUnsignedCompareOp> TYPE = LIRInstructionClass.create(AArch64NormalizedUnsignedCompareOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue result;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue x;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue y;

    public AArch64NormalizedUnsignedCompareOp(AllocatableValue result, AllocatableValue x, AllocatableValue y) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.result = result;
        this.x = x;
        this.y = y;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        if (this.x.getPlatformKind() == AArch64Kind.DWORD) {
            masm.cmp(32, ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y));
        } else {
            GraalError.guarantee(this.x.getPlatformKind() == AArch64Kind.QWORD, "unsupported value kind %s", (Object)this.x.getPlatformKind());
            masm.cmp(64, ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y));
        }
        masm.cset(32, ValueUtil.asRegister((Value)this.result), AArch64Assembler.ConditionFlag.NE);
        masm.csneg(32, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.result), AArch64Assembler.ConditionFlag.HI);
    }
}

