/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.aarch64.AArch64Move;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.meta.JavaConstant;

@Opcode(value="ZAP_STACK")
public final class AArch64ZapStackOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64ZapStackOp> TYPE = LIRInstructionClass.create(AArch64ZapStackOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.STACK})
    protected final StackSlot[] zappedStack;
    protected final JavaConstant[] zapValues;

    public AArch64ZapStackOp(StackSlot[] zappedStack, JavaConstant[] zapValues) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.zappedStack = zappedStack;
        this.zapValues = zapValues;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        for (int i = 0; i < this.zappedStack.length; ++i) {
            StackSlot slot = this.zappedStack[i];
            if (slot == null) continue;
            AArch64Kind moveKind = (AArch64Kind)crb.target.arch.getPlatformKind(this.zapValues[i].getJavaKind());
            AArch64Move.const2stack(moveKind, crb, masm, slot, this.zapValues[i]);
        }
    }
}

