/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.alloc.lsra;

import jdk.graal.compiler.core.common.util.CompilationAlarm;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.lir.LIR;

public final class Range {
    public int from;
    public int to;
    public Range next;
    public LIR lir;

    boolean intersects(Range r) {
        return this.intersectsAt(r) != -1;
    }

    Range(int from, int to, Range next, LIR lir) {
        this.from = from;
        this.to = to;
        this.next = next;
        this.lir = lir;
    }

    public boolean isEndMarker() {
        assert (this.from != Integer.MAX_VALUE || this.to == Integer.MAX_VALUE && this.next == null) : Assertions.errorMessage(this.from, this.to, this.next);
        return this.from == Integer.MAX_VALUE;
    }

    int intersectsAt(Range other) {
        Range r1;
        block8: {
            r1 = this;
            Range r2 = other;
            assert (r2 != null) : "null ranges not allowed";
            assert (!r1.isEndMarker() && !r2.isEndMarker()) : "empty ranges not allowed";
            while (true) {
                CompilationAlarm.checkProgress(this.lir.getOptions(), this.lir);
                if (r1.from < r2.from) {
                    if (r1.to <= r2.from) {
                        r1 = r1.next;
                        if (!r1.isEndMarker()) continue;
                        return -1;
                    }
                    return r2.from;
                }
                if (r2.from < r1.from) {
                    if (r2.to <= r1.from) {
                        r2 = r2.next;
                        if (!r2.isEndMarker()) continue;
                        return -1;
                    }
                    return r1.from;
                }
                if (r1.from == r1.to) {
                    r1 = r1.next;
                    if (!r1.isEndMarker()) continue;
                    return -1;
                }
                if (r2.from != r2.to) break block8;
                r2 = r2.next;
                if (r2.isEndMarker()) break;
            }
            return -1;
        }
        return r1.from;
    }

    public String toString() {
        return "[" + this.from + ", " + this.to + "]";
    }
}

