/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.alloc.lsra.ssa;

import java.util.ArrayList;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.debug.CounterKey;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.alloc.lsra.Interval;
import jdk.graal.compiler.lir.alloc.lsra.LinearScan;
import jdk.graal.compiler.lir.alloc.lsra.LinearScanResolveDataFlowPhase;
import jdk.graal.compiler.lir.alloc.lsra.MoveResolver;
import jdk.graal.compiler.lir.ssa.SSAUtil;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;

class SSALinearScanResolveDataFlowPhase
extends LinearScanResolveDataFlowPhase {
    private static final CounterKey numPhiResolutionMoves = DebugContext.counter("SSA LSRA[numPhiResolutionMoves]");
    private static final CounterKey numStackToStackMoves = DebugContext.counter("SSA LSRA[numStackToStackMoves]");

    SSALinearScanResolveDataFlowPhase(LinearScan allocator) {
        super(allocator);
    }

    @Override
    protected void resolveCollectMappings(BasicBlock<?> fromBlock, BasicBlock<?> toBlock, BasicBlock<?> midBlock, final MoveResolver moveResolver) {
        super.resolveCollectMappings(fromBlock, toBlock, midBlock, moveResolver);
        if (toBlock.getPredecessorCount() > 1) {
            int phiOutId;
            final int toBlockFirstInstructionId = this.allocator.getFirstLirInstructionId(toBlock);
            int fromBlockLastInstructionId = this.allocator.getLastLirInstructionId(fromBlock) + 1;
            BasicBlock<?> phiOutBlock = midBlock != null ? midBlock : fromBlock;
            ArrayList<LIRInstruction> instructions = this.allocator.getLIR().getLIRforBlock(phiOutBlock);
            int phiOutIdx = SSAUtil.phiOutIndex(this.allocator.getLIR(), phiOutBlock);
            int n = phiOutId = midBlock != null ? fromBlockLastInstructionId : instructions.get(phiOutIdx).id();
            assert (phiOutId >= 0) : phiOutId;
            SSAUtil.PhiValueVisitor visitor = new SSAUtil.PhiValueVisitor(){
                final /* synthetic */ SSALinearScanResolveDataFlowPhase this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void visit(Value phiIn, Value phiOut) {
                    assert (!ValueUtil.isRegister((Value)phiOut)) : "phiOut is a register: " + String.valueOf(phiOut);
                    assert (!ValueUtil.isRegister((Value)phiIn)) : "phiIn is a register: " + String.valueOf(phiIn);
                    Interval toInterval = this.this$0.allocator.splitChildAtOpId(this.this$0.allocator.intervalFor(phiIn), toBlockFirstInstructionId, LIRInstruction.OperandMode.DEF);
                    DebugContext debug = this.this$0.allocator.getDebug();
                    if (LIRValueUtil.isConstantValue(phiOut)) {
                        numPhiResolutionMoves.increment(debug);
                        moveResolver.addMapping(LIRValueUtil.asConstant(phiOut), toInterval);
                    } else {
                        Interval fromInterval = this.this$0.allocator.splitChildAtOpId(this.this$0.allocator.intervalFor(phiOut), phiOutId, LIRInstruction.OperandMode.DEF);
                        if (fromInterval != toInterval && !fromInterval.location().equals((Object)toInterval.location())) {
                            numPhiResolutionMoves.increment(debug);
                            if (!LIRValueUtil.isStackSlotValue((Value)toInterval.location()) || !LIRValueUtil.isStackSlotValue((Value)fromInterval.location())) {
                                moveResolver.addMapping(fromInterval, toInterval);
                            } else {
                                numStackToStackMoves.increment(debug);
                                moveResolver.addMapping(fromInterval, toInterval);
                            }
                        }
                    }
                }
            };
            SSAUtil.forEachPhiValuePair(this.allocator.getLIR(), toBlock, phiOutBlock, visitor);
            SSAUtil.removePhiOut(this.allocator.getLIR(), phiOutBlock);
        }
    }
}

