/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.SyncPorts;
import jdk.graal.compiler.lir.amd64.AMD64BigIntegerMulAddOp;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;

@SyncPorts(value={@SyncPort(from="https://github.com/openjdk/jdk/blob/0a3a925ad88921d387aa851157f54ac0054d347b/src/hotspot/cpu/x86/stubGenerator_x86_64.cpp#L3063-L3107", sha1="ab70559cefe0dc177a290d417047955fba3ad1fc"), @SyncPort(from="https://github.com/openjdk/jdk/blob/0a3a925ad88921d387aa851157f54ac0054d347b/src/hotspot/cpu/x86/macroAssembler_x86.cpp#L6926-L7239", sha1="2e4ea1436904cbd5a933eb8c687296d9bbefe4f0")})
public final class AMD64BigIntegerSquareToLenOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64BigIntegerSquareToLenOp> TYPE = LIRInstructionClass.create(AMD64BigIntegerSquareToLenOp.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    private Value xValue;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    private Value lenValue;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    private Value zValue;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    private Value zlenValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value tmp1Value;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value[] tmpValues;

    public AMD64BigIntegerSquareToLenOp(Value xValue, Value lenValue, Value zValue, Value zlenValue, Register heapBaseRegister) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        GraalError.guarantee(ValueUtil.asRegister((Value)xValue).equals((Object)AMD64.rdi), "expect xValue at rdi, but was %s", (Object)xValue);
        GraalError.guarantee(ValueUtil.asRegister((Value)lenValue).equals((Object)AMD64.rsi), "expect lenValue at rsi, but was %s", (Object)lenValue);
        GraalError.guarantee(ValueUtil.asRegister((Value)zValue).equals((Object)AMD64.r11), "expect zValue at r11, but was %s", (Object)zValue);
        GraalError.guarantee(ValueUtil.asRegister((Value)zlenValue).equals((Object)AMD64.rcx), "expect zlenValue at rcx, but was %s", (Object)zlenValue);
        this.xValue = xValue;
        this.lenValue = lenValue;
        this.zValue = zValue;
        this.zlenValue = zlenValue;
        this.tmp1Value = AMD64.r12.equals((Object)heapBaseRegister) ? AMD64.r14.asValue() : AMD64.r12.asValue();
        this.tmpValues = new Value[]{AMD64.rax.asValue(), AMD64.rcx.asValue(), AMD64.rdx.asValue(), AMD64.rbx.asValue(), AMD64.rsi.asValue(), AMD64.rdi.asValue(), AMD64.r9.asValue(), AMD64.r10.asValue(), AMD64.r11.asValue(), AMD64.r13.asValue()};
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        GraalError.guarantee(this.xValue.getPlatformKind().equals((Object)AMD64Kind.QWORD), "Invalid xValue kind: %s", (Object)this.xValue);
        GraalError.guarantee(this.lenValue.getPlatformKind().equals((Object)AMD64Kind.DWORD), "Invalid lenValue kind: %s", (Object)this.lenValue);
        GraalError.guarantee(this.zValue.getPlatformKind().equals((Object)AMD64Kind.QWORD), "Invalid zValue kind: %s", (Object)this.zValue);
        GraalError.guarantee(this.zlenValue.getPlatformKind().equals((Object)AMD64Kind.DWORD), "Invalid zlenValue kind: %s", (Object)this.zlenValue);
        Register x = ValueUtil.asRegister((Value)this.xValue);
        Register len = ValueUtil.asRegister((Value)this.lenValue);
        Register z = ValueUtil.asRegister((Value)this.zValue);
        Register zlen = ValueUtil.asRegister((Value)this.zlenValue);
        Register tmp1 = ValueUtil.asRegister((Value)this.tmp1Value);
        Register tmp2 = AMD64.r13;
        Register tmp3 = AMD64.r9;
        Register tmp4 = AMD64.r10;
        Register tmp5 = AMD64.rbx;
        AMD64BigIntegerSquareToLenOp.squareToLen(masm, x, len, z, zlen, tmp1, tmp2, tmp3, tmp4, tmp5, AMD64.rdx, AMD64.rax);
    }

    static void squareRshift(AMD64MacroAssembler masm, Register x, Register xlen, Register z, Register tmp1, Register tmp4, Register tmp5, Register rdxReg, Register raxReg) {
        masm.xorq(tmp5, tmp5);
        masm.xorq(rdxReg, rdxReg);
        masm.xorl(tmp1, tmp1);
        masm.xorl(tmp4, tmp4);
        Label lFirstLoop = new Label();
        Label lFirstLoopExit = new Label();
        masm.testlAndJcc(xlen, 1, AMD64Assembler.ConditionFlag.Zero, lFirstLoop, true);
        masm.movl(raxReg, new AMD64Address(x, tmp1, Stride.S4, 0));
        masm.imulq(raxReg, raxReg);
        masm.shrq(raxReg, 1);
        masm.adcq(tmp5, 0);
        masm.movq(new AMD64Address(z, tmp4, Stride.S4, 0), raxReg);
        masm.incl(tmp1);
        masm.addl(tmp4, 2);
        masm.bind(lFirstLoop);
        masm.cmpqAndJcc(tmp1, xlen, AMD64Assembler.ConditionFlag.Equal, lFirstLoopExit, true);
        masm.movq(raxReg, new AMD64Address(x, tmp1, Stride.S4, 0));
        masm.rorq(raxReg, 32);
        masm.mulq(raxReg);
        masm.shrq(tmp5, 1);
        masm.rcrq(rdxReg, 1);
        masm.rcrq(raxReg, 1);
        masm.adcq(tmp5, 0);
        masm.movq(new AMD64Address(z, tmp4, Stride.S4, 0), rdxReg);
        masm.movq(new AMD64Address(z, tmp4, Stride.S4, 8), raxReg);
        masm.addl(tmp1, 2);
        masm.addl(tmp4, 4);
        masm.jmp(lFirstLoop);
        masm.bind(lFirstLoopExit);
    }

    static void addOne64(AMD64MacroAssembler masm, Register z, Register zlen, Register carry, Register tmp1) {
        Label lFourthLoop = new Label();
        Label lFourthLoopExit = new Label();
        masm.movl(tmp1, 1);
        masm.subl(zlen, 2);
        masm.addq(new AMD64Address(z, zlen, Stride.S4, 0), carry);
        masm.bind(lFourthLoop);
        masm.jccb(AMD64Assembler.ConditionFlag.CarryClear, lFourthLoopExit);
        masm.sublAndJcc(zlen, 2, AMD64Assembler.ConditionFlag.Negative, lFourthLoopExit, true);
        masm.addq(new AMD64Address(z, zlen, Stride.S4, 0), tmp1);
        masm.jmp(lFourthLoop);
        masm.bind(lFourthLoopExit);
    }

    static void lshiftBy1(AMD64MacroAssembler masm, Register z, Register zlen, Register tmp1, Register tmp2, Register tmp3, Register tmp4) {
        Label lFifthLoop = new Label();
        Label lFifthLoopExit = new Label();
        Register prevCarry = tmp1;
        Register newCarry = tmp4;
        Register value = tmp2;
        Register zidx = tmp3;
        masm.movl(zidx, zlen);
        masm.xorl(prevCarry, prevCarry);
        masm.bind(lFifthLoop);
        masm.decl(zidx);
        masm.declAndJcc(zidx, AMD64Assembler.ConditionFlag.Negative, lFifthLoopExit, true);
        if (AMD64BigIntegerMulAddOp.useBMI2Instructions(masm)) {
            masm.movq(value, new AMD64Address(z, zidx, Stride.S4, 0));
            masm.rclq(value, 1);
            masm.rorxq(value, value, 32);
            masm.movq(new AMD64Address(z, zidx, Stride.S4, 0), value);
        } else {
            masm.xorl(newCarry, newCarry);
            masm.movq(value, new AMD64Address(z, zidx, Stride.S4, 0));
            masm.shlq(value, 1);
            masm.adcl(newCarry, 0);
            masm.orq(value, prevCarry);
            masm.rorq(value, 32);
            masm.movq(new AMD64Address(z, zidx, Stride.S4, 0), value);
            masm.movl(prevCarry, newCarry);
        }
        masm.jmp(lFifthLoop);
        masm.bind(lFifthLoopExit);
    }

    private static void squareToLen(AMD64MacroAssembler masm, Register x, Register len, Register z, Register zlen, Register tmp1, Register tmp2, Register tmp3, Register tmp4, Register tmp5, Register rdxReg, Register raxReg) {
        Label lSecondLoop = new Label();
        Label lSecondLoopExit = new Label();
        Label lThirdLoop = new Label();
        Label lThirdLoopExit = new Label();
        Label lLastX = new Label();
        Label lMultiply = new Label();
        AMD64BigIntegerSquareToLenOp.squareRshift(masm, x, len, z, tmp1, tmp4, tmp5, rdxReg, raxReg);
        Register carry = tmp5;
        Register sum = tmp3;
        Register op1 = tmp4;
        Register op2 = tmp2;
        masm.push(zlen);
        masm.push(len);
        masm.addl(zlen, 2);
        masm.bind(lSecondLoop);
        masm.xorq(carry, carry);
        masm.subl(zlen, 4);
        masm.subl(len, 2);
        masm.push(zlen);
        masm.push(len);
        masm.cmplAndJcc(len, 0, AMD64Assembler.ConditionFlag.LessEqual, lSecondLoopExit, true);
        if (AMD64BigIntegerMulAddOp.useBMI2Instructions(masm)) {
            op2 = rdxReg;
            masm.movq(op2, new AMD64Address(x, len, Stride.S4, 0));
            masm.rorxq(op2, op2, 32);
        } else {
            masm.movq(op2, new AMD64Address(x, len, Stride.S4, 0));
            masm.rorq(op2, 32);
        }
        masm.bind(lThirdLoop);
        masm.declAndJcc(len, AMD64Assembler.ConditionFlag.Negative, lThirdLoopExit, true);
        masm.declAndJcc(len, AMD64Assembler.ConditionFlag.Negative, lLastX, true);
        masm.movq(op1, new AMD64Address(x, len, Stride.S4, 0));
        masm.rorq(op1, 32);
        masm.bind(lMultiply);
        masm.subl(zlen, 2);
        masm.movq(sum, new AMD64Address(z, zlen, Stride.S4, 0));
        if (AMD64BigIntegerMulAddOp.useBMI2Instructions(masm)) {
            AMD64BigIntegerMulAddOp.multiplyAdd64Bmi2(masm, sum, op1, op2, carry, tmp2);
        } else {
            AMD64BigIntegerMulAddOp.multiplyAdd64(masm, sum, op1, op2, carry, rdxReg, raxReg);
        }
        masm.movq(new AMD64Address(z, zlen, Stride.S4, 0), sum);
        masm.jmp(lThirdLoop);
        masm.bind(lThirdLoopExit);
        AMD64BigIntegerSquareToLenOp.addOne64(masm, z, zlen, carry, tmp1);
        masm.pop(len);
        masm.pop(zlen);
        masm.jmp(lSecondLoop);
        masm.bind(lLastX);
        masm.movl(op1, new AMD64Address(x, 0));
        masm.jmp(lMultiply);
        masm.bind(lSecondLoopExit);
        masm.pop(len);
        masm.pop(zlen);
        masm.pop(len);
        masm.pop(zlen);
        AMD64BigIntegerSquareToLenOp.lshiftBy1(masm, z, zlen, tmp1, tmp2, tmp3, tmp4);
        masm.movl(tmp3, new AMD64Address(x, len, Stride.S4, -4));
        masm.andl(tmp3, 1);
        masm.orl(new AMD64Address(z, zlen, Stride.S4, -4), tmp3);
    }
}

