/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.amd64.AMD64AddressValue;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.amd64.AMD64Move;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.Value;

public class AMD64Binary {

    public static class RMIOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<RMIOp> TYPE = LIRInstructionClass.create(RMIOp.class);
        @Opcode
        private final AMD64Assembler.AMD64RMIOp opcode;
        private final AMD64BaseAssembler.OperandSize size;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue x;
        private final int y;

        public RMIOp(AMD64Assembler.AMD64RMIOp opcode, AMD64BaseAssembler.OperandSize size, AllocatableValue result, AllocatableValue x, int y) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.opcode = opcode;
            this.size = size;
            this.result = result;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.x)) {
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.x), this.y);
            } else {
                assert (ValueUtil.isStackSlot((Value)this.x));
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), (AMD64Address)crb.asAddress((Value)this.x), this.y);
            }
        }
    }

    public static class MemoryTwoOp
    extends AMD64LIRInstruction
    implements StandardOp.ImplicitNullCheck {
        public static final LIRInstructionClass<MemoryTwoOp> TYPE = LIRInstructionClass.create(MemoryTwoOp.class);
        @Opcode
        private final AMD64Assembler.AMD64RMOp opcode;
        private final AMD64BaseAssembler.OperandSize size;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AMD64AddressValue y;
        @LIRInstruction.State
        protected LIRFrameState state;

        public MemoryTwoOp(AMD64Assembler.AMD64RMOp opcode, AMD64BaseAssembler.OperandSize size, AllocatableValue result, AllocatableValue x, AMD64AddressValue y, LIRFrameState state) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.opcode = opcode;
            this.size = size;
            this.result = result;
            this.x = x;
            this.y = y;
            this.state = state;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Move.move(crb, masm, (Value)this.result, (Value)this.x);
            if (this.state != null) {
                crb.recordImplicitException(masm.position(), this.state);
            }
            this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), this.y.toAddress());
        }

        @Override
        public void verify() {
            super.verify();
            assert (LIRValueUtil.differentRegisters(new Object[]{this.result, this.y}) || LIRValueUtil.sameRegister((Value)this.x, this.y));
        }

        @Override
        public boolean makeNullCheckFor(Value value, LIRFrameState nullCheckState, int implicitNullCheckLimit) {
            if (this.state == null && this.y.isValidImplicitNullCheckFor(value, implicitNullCheckLimit)) {
                this.state = nullCheckState;
                return true;
            }
            return false;
        }

        public AMD64Assembler.AMD64RMOp getOpcode() {
            return this.opcode;
        }
    }

    public static class DataTwoOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<DataTwoOp> TYPE = LIRInstructionClass.create(DataTwoOp.class);
        @Opcode
        private final AMD64Assembler.AMD64RMOp opcode;
        private final AMD64BaseAssembler.OperandSize size;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        private final JavaConstant y;
        private final int alignment;

        public DataTwoOp(AMD64Assembler.AMD64RMOp opcode, AMD64BaseAssembler.OperandSize size, AllocatableValue result, AllocatableValue x, JavaConstant y) {
            this(opcode, size, result, x, y, y.getJavaKind().getByteCount());
        }

        public DataTwoOp(AMD64Assembler.AMD64RMOp opcode, AMD64BaseAssembler.OperandSize size, AllocatableValue result, AllocatableValue x, JavaConstant y, int alignment) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.opcode = opcode;
            this.size = size;
            this.result = result;
            this.x = x;
            this.y = y;
            this.alignment = alignment;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Move.move(crb, masm, (Value)this.result, (Value)this.x);
            this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), (AMD64Address)crb.recordDataReferenceInCode((Constant)this.y, this.alignment));
        }
    }

    public static class ConstOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<ConstOp> TYPE = LIRInstructionClass.create(ConstOp.class);
        @Opcode
        private final AMD64Assembler.AMD64MIOp opcode;
        private final AMD64BaseAssembler.OperandSize size;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        private final int y;

        public ConstOp(AMD64Assembler.AMD64BinaryArithmetic opcode, AMD64BaseAssembler.OperandSize size, AllocatableValue result, AllocatableValue x, int y) {
            this(opcode.getMIOpcode(size, NumUtil.isByte(y)), size, result, x, y);
        }

        public ConstOp(AMD64Assembler.AMD64MIOp opcode, AMD64BaseAssembler.OperandSize size, AllocatableValue result, AllocatableValue x, int y) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.opcode = opcode;
            this.size = size;
            this.result = result;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Move.move(crb, masm, (Value)this.result, (Value)this.x);
            this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), this.y);
        }
    }

    public static class CommutativeTwoOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<CommutativeTwoOp> TYPE = LIRInstructionClass.create(CommutativeTwoOp.class);
        @Opcode
        private final AMD64Assembler.AMD64RMOp opcode;
        private final AMD64BaseAssembler.OperandSize size;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue x;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue y;

        public CommutativeTwoOp(AMD64Assembler.AMD64RMOp opcode, AMD64BaseAssembler.OperandSize size, AllocatableValue result, AllocatableValue x, AllocatableValue y) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.opcode = opcode;
            this.size = size;
            this.result = result;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AllocatableValue input;
            if (LIRValueUtil.sameRegister((Value)this.result, (Value)this.y)) {
                input = this.x;
            } else {
                AMD64Move.move(crb, masm, (Value)this.result, (Value)this.x);
                input = this.y;
            }
            if (ValueUtil.isRegister((Value)input)) {
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)input));
            } else {
                assert (ValueUtil.isStackSlot((Value)input));
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), (AMD64Address)crb.asAddress((Value)input));
            }
        }

        public AMD64Assembler.AMD64RMOp getOpcode() {
            return this.opcode;
        }
    }

    public static class TwoOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<TwoOp> TYPE = LIRInstructionClass.create(TwoOp.class);
        @Opcode
        private final AMD64Assembler.AMD64RMOp opcode;
        private final AMD64BaseAssembler.OperandSize size;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue y;

        public TwoOp(AMD64Assembler.AMD64RMOp opcode, AMD64BaseAssembler.OperandSize size, AllocatableValue result, AllocatableValue x, AllocatableValue y) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.opcode = opcode;
            this.size = size;
            this.result = result;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Move.move(crb, masm, (Value)this.result, (Value)this.x);
            if (ValueUtil.isRegister((Value)this.y)) {
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.y));
            } else {
                assert (ValueUtil.isStackSlot((Value)this.y));
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), (AMD64Address)crb.asAddress((Value)this.y));
            }
        }
    }
}

