/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;

@SyncPort(from="https://github.com/openjdk/jdk/blob/0a3a925ad88921d387aa851157f54ac0054d347b/src/hotspot/cpu/x86/c2_MacroAssembler_x86.cpp#L5744-L5826", sha1="cb807f6ece0a42ba5abae88477e8899436d09a4e")
public final class AMD64BitSwapOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64BitSwapOp> TYPE = LIRInstructionClass.create(AMD64BitSwapOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected Value dstValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value srcValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value rtmpValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value rtmp2Value;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value xtmp1Value;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value xtmp2Value;

    public AMD64BitSwapOp(LIRGeneratorTool tool, Value dstValue, Value srcValue) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.dstValue = dstValue;
        this.srcValue = srcValue;
        this.rtmpValue = tool.newVariable(dstValue.getValueKind());
        if (AMD64BitSwapOp.supportsGFNI(tool.target().arch)) {
            this.rtmp2Value = Value.ILLEGAL;
            LIRKind lirKind = LIRKind.value((PlatformKind)AMD64Kind.DOUBLE);
            this.xtmp1Value = tool.newVariable(lirKind);
            this.xtmp2Value = tool.newVariable(lirKind);
        } else {
            this.rtmp2Value = dstValue.getPlatformKind() == AMD64Kind.QWORD ? tool.newVariable(dstValue.getValueKind()) : Value.ILLEGAL;
            this.xtmp1Value = Value.ILLEGAL;
            this.xtmp2Value = Value.ILLEGAL;
        }
    }

    private static boolean supportsGFNI(Architecture arch) {
        try {
            return arch.getFeatures().contains(AMD64.CPUFeature.valueOf((String)"GFNI"));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Register dst = ValueUtil.asRegister((Value)this.dstValue);
        Register src = ValueUtil.asRegister((Value)this.srcValue);
        Register rtmp = ValueUtil.asRegister((Value)this.rtmpValue);
        switch ((AMD64Kind)this.dstValue.getPlatformKind()) {
            case DWORD: {
                if (masm.supports(AMD64.CPUFeature.GFNI)) {
                    Register xtmp1 = ValueUtil.asRegister((Value)this.xtmp1Value);
                    Register xtmp2 = ValueUtil.asRegister((Value)this.xtmp2Value);
                    masm.movq(rtmp, -9205322385119247871L);
                    masm.movdq(xtmp1, src);
                    masm.movdq(xtmp2, rtmp);
                    masm.gf2p8affineqb(xtmp1, xtmp2, 0);
                    masm.movdq(dst, xtmp1);
                } else {
                    masm.movl(rtmp, src);
                    masm.andl(rtmp, 0x55555555);
                    masm.shll(rtmp, 1);
                    masm.movl(dst, src);
                    masm.andl(dst, -1431655766);
                    masm.shrl(dst, 1);
                    masm.orl(dst, rtmp);
                    masm.movl(rtmp, dst);
                    masm.andl(rtmp, 0x33333333);
                    masm.shll(rtmp, 2);
                    masm.andl(dst, -858993460);
                    masm.shrl(dst, 2);
                    masm.orl(dst, rtmp);
                    masm.movl(rtmp, dst);
                    masm.andl(rtmp, 0xF0F0F0F);
                    masm.shll(rtmp, 4);
                    masm.andl(dst, -252645136);
                    masm.shrl(dst, 4);
                    masm.orl(dst, rtmp);
                }
                masm.bswapl(dst);
                break;
            }
            case QWORD: {
                if (masm.supports(AMD64.CPUFeature.GFNI)) {
                    Register xtmp1 = ValueUtil.asRegister((Value)this.xtmp1Value);
                    Register xtmp2 = ValueUtil.asRegister((Value)this.xtmp2Value);
                    masm.movq(rtmp, -9205322385119247871L);
                    masm.movdq(xtmp1, src);
                    masm.movdq(xtmp2, rtmp);
                    masm.gf2p8affineqb(xtmp1, xtmp2, 0);
                    masm.movdq(dst, xtmp1);
                } else {
                    Register rtmp1 = rtmp;
                    Register rtmp2 = ValueUtil.asRegister((Value)this.rtmp2Value);
                    masm.movq(rtmp1, src);
                    masm.movq(rtmp2, 0x5555555555555555L);
                    masm.andq(rtmp1, rtmp2);
                    masm.shlq(rtmp1, 1);
                    masm.movq(dst, src);
                    masm.notq(rtmp2);
                    masm.andq(dst, rtmp2);
                    masm.shrq(dst, 1);
                    masm.orq(dst, rtmp1);
                    masm.movq(rtmp1, dst);
                    masm.movq(rtmp2, 0x3333333333333333L);
                    masm.andq(rtmp1, rtmp2);
                    masm.shlq(rtmp1, 2);
                    masm.notq(rtmp2);
                    masm.andq(dst, rtmp2);
                    masm.shrq(dst, 2);
                    masm.orq(dst, rtmp1);
                    masm.movq(rtmp1, dst);
                    masm.movq(rtmp2, 0xF0F0F0F0F0F0F0FL);
                    masm.andq(rtmp1, rtmp2);
                    masm.shlq(rtmp1, 4);
                    masm.notq(rtmp2);
                    masm.andq(dst, rtmp2);
                    masm.shrq(dst, 4);
                    masm.orq(dst, rtmp1);
                }
                masm.bswapq(dst);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHereUnexpectedValue(this.dstValue.getPlatformKind());
            }
        }
    }
}

