/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.amd64.AMD64Move;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;

@Opcode(value="BSWAP")
public final class AMD64ByteSwapOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64ByteSwapOp> TYPE = LIRInstructionClass.create(AMD64ByteSwapOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
    protected Value result;
    @LIRInstruction.Use
    protected Value input;

    public AMD64ByteSwapOp(Value result, Value input) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.result = result;
        this.input = input;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        AMD64Move.move(crb, masm, this.result, this.input);
        switch ((AMD64Kind)this.input.getPlatformKind()) {
            case DWORD: {
                masm.bswapl(ValueUtil.asRegister((Value)this.result));
                break;
            }
            case QWORD: {
                masm.bswapq(ValueUtil.asRegister((Value)this.result));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHereUnexpectedValue(this.input.getPlatformKind());
            }
        }
    }
}

