/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

public class AMD64ClearRegisterOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64ClearRegisterOp> TYPE = LIRInstructionClass.create(AMD64ClearRegisterOp.class);
    @Opcode
    private final AMD64Assembler.AMD64RMOp op;
    private final AMD64BaseAssembler.OperandSize size;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue result;

    public AMD64ClearRegisterOp(AMD64BaseAssembler.OperandSize size, AllocatableValue result) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.op = AMD64Assembler.AMD64BinaryArithmetic.XOR.getRMOpcode(size);
        this.size = size;
        this.result = result;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        this.op.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.result));
    }
}

